/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mybatis;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.bean.BeanProcessor;
import org.apache.camel.component.mybatis.MyBatisBeanEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.ExchangeHelper;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyBatisBeanProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(MyBatisBeanProducer.class);
    private final MyBatisBeanEndpoint endpoint;

    public MyBatisBeanProducer(MyBatisBeanEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    public void process(Exchange exchange) throws Exception {
        ExecutorType executorType = this.endpoint.getExecutorType();
        SqlSession session = executorType == null ? this.endpoint.getSqlSessionFactory().openSession() : this.endpoint.getSqlSessionFactory().openSession(executorType);
        LOG.debug("Opened MyBatis SqlSession: {}", (Object)session);
        try {
            this.doProcess(exchange, session);
            session.commit();
        }
        catch (Exception e) {
            session.rollback();
            throw e;
        }
        finally {
            LOG.debug("Closing MyBatis SqlSession: {}", (Object)session);
            session.close();
        }
    }

    protected void doProcess(Exchange exchange, SqlSession session) throws Exception {
        LOG.trace("Invoking MyBatisBean on {}:{}", (Object)this.endpoint.getBeanName(), (Object)this.endpoint.getMethodName());
        Exchange copy = ExchangeHelper.createCopy((Exchange)exchange, (boolean)true);
        Object input = this.getInput(copy);
        copy.getMessage().setBody(input);
        BeanProcessor beanProcessor = this.createBeanProcessor(session);
        beanProcessor.start();
        beanProcessor.process(copy);
        beanProcessor.stop();
        Object result = copy.getMessage().getBody();
        if (result != input) {
            if (this.endpoint.getOutputHeader() != null) {
                LOG.trace("Setting result as header [{}]: {}", (Object)this.endpoint.getOutputHeader(), result);
                exchange.getMessage().setHeader(this.endpoint.getOutputHeader(), result);
            } else {
                LOG.trace("Setting result as body: {}", result);
                exchange.getMessage().setBody(result);
                exchange.getMessage().setHeader("CamelMyBatisResult", result);
            }
        }
    }

    private BeanProcessor createBeanProcessor(SqlSession session) throws Exception {
        Class clazz = session.getConfiguration().getTypeAliasRegistry().resolveAlias(this.endpoint.getBeanName());
        if (clazz == null) {
            clazz = this.getEndpoint().getCamelContext().getClassResolver().resolveMandatoryClass(this.endpoint.getBeanName());
        }
        LOG.debug("Resolved MyBatis Bean: {} as class: {}", (Object)this.endpoint.getBeanName(), (Object)clazz);
        Object mapper = session.getMapper(clazz);
        if (mapper == null) {
            throw new IllegalArgumentException("No Mapper with typeAlias or class name: " + this.endpoint.getBeanName() + " in MyBatis configuration.");
        }
        LOG.debug("Resolved MyBatis Bean mapper: {}", mapper);
        BeanProcessor answer = new BeanProcessor(mapper, this.getEndpoint().getCamelContext());
        answer.setMethod(this.endpoint.getMethodName());
        return answer;
    }

    private Object getInput(Exchange exchange) {
        String inputHeader = this.endpoint.getInputHeader();
        if (inputHeader != null) {
            return exchange.getIn().getHeader(inputHeader);
        }
        return exchange.getIn().getBody();
    }
}

