/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.mvel;

import java.io.Serializable;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.ExpressionEvaluationException;
import org.apache.camel.ExpressionIllegalSyntaxException;
import org.apache.camel.impl.ExpressionSupport;
import org.apache.camel.language.mvel.MvelLanguage;
import org.apache.camel.language.mvel.RootObject;
import org.mvel.MVEL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MvelExpression
extends ExpressionSupport {
    private final String expressionString;
    private final Class<?> type;
    private final Serializable compiled;

    public MvelExpression(MvelLanguage language, String expressionString, Class<?> type) {
        this.expressionString = expressionString;
        this.type = type;
        try {
            this.compiled = MVEL.compileExpression((String)expressionString);
        }
        catch (Exception e) {
            throw new ExpressionIllegalSyntaxException(expressionString, (Throwable)e);
        }
    }

    public static MvelExpression mvel(String expression) {
        return new MvelExpression(new MvelLanguage(), expression, Object.class);
    }

    public Object evaluate(Exchange exchange) {
        try {
            return MVEL.executeExpression((Object)this.compiled, (Object)new RootObject(exchange));
        }
        catch (Exception e) {
            throw new ExpressionEvaluationException((Expression)this, exchange, (Throwable)e);
        }
    }

    protected String assertionFailureMessage(Exchange exchange) {
        return this.expressionString;
    }

    public String toString() {
        return "Mvel[" + this.expressionString + "]";
    }
}

