/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mongodb;

import com.mongodb.ClientBulkWriteException;
import com.mongodb.ClientSessionOptions;
import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.client.ChangeStreamIterable;
import com.mongodb.client.ClientSession;
import com.mongodb.client.ListDatabasesIterable;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCluster;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.bulk.ClientBulkWriteOptions;
import com.mongodb.client.model.bulk.ClientBulkWriteResult;
import com.mongodb.client.model.bulk.ClientNamespacedWriteModel;
import com.mongodb.connection.ClusterDescription;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.camel.util.function.Suppliers;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslAwareMongoClient
implements MongoClient {
    private static final Logger LOG = LoggerFactory.getLogger(SslAwareMongoClient.class);
    private static final TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }
    }};
    private final Supplier<MongoClient> wrappedMongoClient = Suppliers.memorize((Supplier)new Supplier<MongoClient>(){

        @Override
        public MongoClient get() {
            Object credentials;
            Object object = credentials = SslAwareMongoClient.this.username == null ? "" : SslAwareMongoClient.this.username;
            if (!((String)credentials).isEmpty()) {
                credentials = (String)credentials + (String)(SslAwareMongoClient.this.password == null ? "@" : ":" + SslAwareMongoClient.this.password + "@");
            }
            MongoClientSettings settings = MongoClientSettings.builder().applyToSslSettings(builder -> {
                builder.enabled(SslAwareMongoClient.this.ssl);
                if (!SslAwareMongoClient.this.sslValidationEnabled) {
                    builder.invalidHostNameAllowed(true);
                    SSLContext sc = null;
                    try {
                        sc = SSLContext.getInstance("TLSv1.2");
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw new RuntimeException("Error instantiating trust all SSL context.", e);
                    }
                    try {
                        sc.init(null, trustAllCerts, new SecureRandom());
                    }
                    catch (KeyManagementException e) {
                        throw new RuntimeException("Error instantiating trust all SSL context.", e);
                    }
                    builder.context(sc);
                }
            }).applyConnectionString(new ConnectionString(String.format("mongodb://%s%s", credentials, SslAwareMongoClient.this.hosts))).build();
            LOG.info("Connection created using provided credentials");
            return MongoClients.create((MongoClientSettings)settings);
        }
    });
    private String hosts = null;
    private String username = null;
    private String password = null;
    private boolean ssl = true;
    private boolean sslValidationEnabled = true;

    public MongoClient getWrappedMongoClient() {
        return this.wrappedMongoClient.get();
    }

    public MongoDatabase getDatabase(String s) {
        return this.getWrappedMongoClient().getDatabase(s);
    }

    public ClientSession startSession() {
        return this.getWrappedMongoClient().startSession();
    }

    public ClientSession startSession(ClientSessionOptions clientSessionOptions) {
        return this.getWrappedMongoClient().startSession(clientSessionOptions);
    }

    public void close() {
        this.getWrappedMongoClient().close();
    }

    public MongoIterable<String> listDatabaseNames() {
        return this.getWrappedMongoClient().listDatabaseNames();
    }

    public MongoIterable<String> listDatabaseNames(ClientSession clientSession) {
        return this.getWrappedMongoClient().listDatabaseNames(clientSession);
    }

    public ListDatabasesIterable<Document> listDatabases() {
        return this.getWrappedMongoClient().listDatabases();
    }

    public ListDatabasesIterable<Document> listDatabases(ClientSession clientSession) {
        return this.getWrappedMongoClient().listDatabases(clientSession);
    }

    public <TResult> ListDatabasesIterable<TResult> listDatabases(Class<TResult> aClass) {
        return this.getWrappedMongoClient().listDatabases(aClass);
    }

    public <TResult> ListDatabasesIterable<TResult> listDatabases(ClientSession clientSession, Class<TResult> aClass) {
        return this.getWrappedMongoClient().listDatabases(clientSession, aClass);
    }

    public ChangeStreamIterable<Document> watch() {
        return this.getWrappedMongoClient().watch();
    }

    public <TResult> ChangeStreamIterable<TResult> watch(Class<TResult> aClass) {
        return this.getWrappedMongoClient().watch(aClass);
    }

    public ChangeStreamIterable<Document> watch(List<? extends Bson> list) {
        return this.getWrappedMongoClient().watch(list);
    }

    public <TResult> ChangeStreamIterable<TResult> watch(List<? extends Bson> list, Class<TResult> aClass) {
        return this.getWrappedMongoClient().watch(list, aClass);
    }

    public ChangeStreamIterable<Document> watch(ClientSession clientSession) {
        return this.getWrappedMongoClient().watch(clientSession);
    }

    public <TResult> ChangeStreamIterable<TResult> watch(ClientSession clientSession, Class<TResult> aClass) {
        return this.getWrappedMongoClient().watch(clientSession, aClass);
    }

    public ChangeStreamIterable<Document> watch(ClientSession clientSession, List<? extends Bson> list) {
        return this.getWrappedMongoClient().watch(clientSession, list);
    }

    public <TResult> ChangeStreamIterable<TResult> watch(ClientSession clientSession, List<? extends Bson> list, Class<TResult> aClass) {
        return this.getWrappedMongoClient().watch(clientSession, list, aClass);
    }

    public ClientBulkWriteResult bulkWrite(List<? extends ClientNamespacedWriteModel> list) throws ClientBulkWriteException {
        return this.getWrappedMongoClient().bulkWrite(list);
    }

    public ClientBulkWriteResult bulkWrite(List<? extends ClientNamespacedWriteModel> list, ClientBulkWriteOptions clientBulkWriteOptions) throws ClientBulkWriteException {
        return this.getWrappedMongoClient().bulkWrite(list, clientBulkWriteOptions);
    }

    public ClientBulkWriteResult bulkWrite(ClientSession clientSession, List<? extends ClientNamespacedWriteModel> list) throws ClientBulkWriteException {
        return this.getWrappedMongoClient().bulkWrite(clientSession, list);
    }

    public ClientBulkWriteResult bulkWrite(ClientSession clientSession, List<? extends ClientNamespacedWriteModel> list, ClientBulkWriteOptions clientBulkWriteOptions) throws ClientBulkWriteException {
        return this.getWrappedMongoClient().bulkWrite(clientSession, list, clientBulkWriteOptions);
    }

    public ClusterDescription getClusterDescription() {
        return this.getWrappedMongoClient().getClusterDescription();
    }

    public CodecRegistry getCodecRegistry() {
        return this.getWrappedMongoClient().getCodecRegistry();
    }

    public ReadPreference getReadPreference() {
        return this.getWrappedMongoClient().getReadPreference();
    }

    public WriteConcern getWriteConcern() {
        return this.getWrappedMongoClient().getWriteConcern();
    }

    public ReadConcern getReadConcern() {
        return this.getWrappedMongoClient().getReadConcern();
    }

    public Long getTimeout(TimeUnit timeUnit) {
        return this.getWrappedMongoClient().getTimeout(timeUnit);
    }

    public MongoCluster withCodecRegistry(CodecRegistry codecRegistry) {
        return this.getWrappedMongoClient().withCodecRegistry(codecRegistry);
    }

    public MongoCluster withReadPreference(ReadPreference readPreference) {
        return this.getWrappedMongoClient().withReadPreference(readPreference);
    }

    public MongoCluster withWriteConcern(WriteConcern writeConcern) {
        return this.getWrappedMongoClient().withWriteConcern(writeConcern);
    }

    public MongoCluster withReadConcern(ReadConcern readConcern) {
        return this.getWrappedMongoClient().withReadConcern(readConcern);
    }

    public MongoCluster withTimeout(long l, TimeUnit timeUnit) {
        return this.getWrappedMongoClient().withTimeout(l, timeUnit);
    }

    public String getHosts() {
        return this.hosts;
    }

    public void setHosts(String hosts) {
        this.hosts = hosts;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    public boolean isSslValidationEnabled() {
        return this.sslValidationEnabled;
    }

    public void setSslValidationEnabled(boolean sslValidationEnabled) {
        this.sslValidationEnabled = sslValidationEnabled;
    }
}

