/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mongodb;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import java.util.concurrent.CountDownLatch;
import org.apache.camel.Consumer;
import org.apache.camel.component.mongodb.MongoDbEndpoint;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class MongoAbstractConsumerThread
implements Runnable {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final long cursorRegenerationDelay;
    protected final boolean cursorRegenerationDelayEnabled;
    protected final MongoCollection<Document> dbCol;
    protected final Consumer consumer;
    protected final MongoDbEndpoint endpoint;
    protected MongoCursor cursor;
    volatile boolean keepRunning = true;
    private volatile boolean stopped;
    private volatile CountDownLatch stoppedLatch;

    MongoAbstractConsumerThread(MongoDbEndpoint endpoint, Consumer consumer) {
        this.endpoint = endpoint;
        this.consumer = consumer;
        this.dbCol = endpoint.getMongoCollection();
        this.cursorRegenerationDelay = endpoint.getCursorRegenerationDelay();
        this.cursorRegenerationDelayEnabled = this.cursorRegenerationDelay != 0L;
    }

    protected abstract MongoCursor<Document> initializeCursor();

    protected abstract void init() throws Exception;

    protected abstract void doRun();

    protected abstract void regeneratingCursor();

    @Override
    public void run() {
        this.stoppedLatch = new CountDownLatch(1);
        try {
            while (this.keepRunning) {
                try {
                    this.doRun();
                }
                catch (Exception e) {
                    if (this.keepRunning) {
                        this.log.warn("Exception from consuming from MongoDB caused by {}. Will try again on next poll.", (Object)e.getMessage());
                    }
                    this.log.warn("Exception from consuming from MongoDB caused by {}. ConsumerThread will be stopped.", (Object)e.getMessage(), (Object)e);
                }
                if (!this.keepRunning) continue;
                this.cursor.close();
                this.regeneratingCursor();
                if (this.cursorRegenerationDelayEnabled) {
                    try {
                        Thread.sleep(this.cursorRegenerationDelay);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.cursor = this.initializeCursor();
            }
        }
        finally {
            this.stopped = true;
            this.stoppedLatch.countDown();
        }
    }

    protected void stop() throws Exception {
        if (this.log.isInfoEnabled()) {
            this.log.info("Stopping MongoDB Tailable Cursor consumer, bound to collection: {}", (Object)String.format("db: %s, col: %s", this.endpoint.getDatabase(), this.endpoint.getCollection()));
        }
        this.keepRunning = false;
        if (this.cursor != null) {
            this.cursor.close();
        }
        this.awaitStopped();
        if (this.log.isInfoEnabled()) {
            this.log.info("Stopped MongoDB Tailable Cursor consumer, bound to collection: {}", (Object)String.format("db: %s, col: %s", this.endpoint.getDatabase(), this.endpoint.getCollection()));
        }
    }

    private void awaitStopped() throws InterruptedException {
        if (!this.stopped) {
            this.log.info("Going to wait for stopping");
            this.stoppedLatch.await();
        }
    }
}

