/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mongodb.converters;

import com.mongodb.BasicDBObject;
import com.mongodb.util.JSON;
import com.mongodb.util.JSONCallback;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Map;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.converter.IOConverter;
import org.apache.camel.util.IOHelper;
import org.bson.BSONCallback;
import org.bson.BasicBSONDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Converter
public final class MongoDbBasicConverters {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDbBasicConverters.class);

    private MongoDbBasicConverters() {
    }

    @Converter
    public static BasicDBObject fromMapToDBObject(Map<?, ?> map) {
        return new BasicDBObject(map);
    }

    @Converter
    public static Map<String, Object> fromBasicDBObjectToMap(BasicDBObject basicDbObject) {
        return basicDbObject;
    }

    @Converter
    public static BasicDBObject fromFileToDBObject(File f, Exchange exchange) throws Exception {
        return MongoDbBasicConverters.fromInputStreamToDBObject(new FileInputStream(f), exchange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Converter
    public static BasicDBObject fromInputStreamToDBObject(InputStream is, Exchange exchange) throws Exception {
        BasicDBObject answer;
        try {
            byte[] input = IOConverter.toBytes((InputStream)is);
            if (MongoDbBasicConverters.isBson(input)) {
                JSONCallback callback = new JSONCallback();
                new BasicBSONDecoder().decode(input, (BSONCallback)callback);
                answer = (BasicDBObject)callback.get();
            } else {
                answer = (BasicDBObject)JSON.parse((String)IOConverter.toString((byte[])input, (Exchange)exchange));
            }
        }
        finally {
            IOHelper.close((Closeable)is, (String)"InputStream", (Logger)LOG);
        }
        return answer;
    }

    private static boolean isBson(byte[] input) {
        int i = 0;
        while (i < input.length) {
            if (input[i] == 123) {
                return false;
            }
            if (Character.isWhitespace(input[i])) continue;
            return true;
        }
        return true;
    }
}

