/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mongodb;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.mongodb.CamelMongoDbException;
import org.apache.camel.component.mongodb.MongoDbComponent;
import org.apache.camel.component.mongodb.MongoDbConsumerType;
import org.apache.camel.component.mongodb.MongoDbOperation;
import org.apache.camel.component.mongodb.MongoDbProducer;
import org.apache.camel.component.mongodb.MongoDbTailTrackingConfig;
import org.apache.camel.component.mongodb.MongoDbTailableCursorConsumer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.impl.DefaultMessage;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDbEndpoint
extends DefaultEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDbEndpoint.class);
    private Mongo mongoConnection;
    private String database;
    private String collection;
    private String collectionIndex;
    private MongoDbOperation operation;
    private boolean createCollection = true;
    private boolean invokeGetLastError;
    private WriteConcern writeConcern;
    private WriteConcern writeConcernRef;
    private ReadPreference readPreference;
    private boolean dynamicity;
    private boolean writeResultAsHeader;
    private MongoDbConsumerType consumerType;
    private long cursorRegenerationDelay = 1000L;
    private String tailTrackIncreasingField;
    private boolean persistentTailTracking;
    private String persistentId;
    private String tailTrackDb;
    private String tailTrackCollection;
    private String tailTrackField;
    private MongoDbTailTrackingConfig tailTrackingConfig;
    private DBCollection dbCollection;
    private DB db;

    public MongoDbEndpoint() {
    }

    public MongoDbEndpoint(String uri, MongoDbComponent component) {
        super(uri, (Component)component);
    }

    public MongoDbEndpoint(String endpointUri) {
        super(endpointUri);
    }

    public Producer createProducer() throws Exception {
        this.validateOptions('P');
        this.initializeConnection();
        return new MongoDbProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        this.validateOptions('C');
        this.createCollection = false;
        this.initializeConnection();
        if (this.consumerType == null) {
            this.consumerType = MongoDbConsumerType.tailable;
        }
        if (this.consumerType != MongoDbConsumerType.tailable) {
            throw new CamelMongoDbException("Consumer type not supported: " + (Object)((Object)this.consumerType));
        }
        MongoDbTailableCursorConsumer consumer = new MongoDbTailableCursorConsumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    private void validateOptions(char role) throws IllegalArgumentException {
        if (role == 'P') {
            if (!(ObjectHelper.isEmpty((Object)((Object)this.consumerType)) && !this.persistentTailTracking && ObjectHelper.isEmpty((Object)this.tailTrackDb) && ObjectHelper.isEmpty((Object)this.tailTrackCollection) && ObjectHelper.isEmpty((Object)this.tailTrackField) && this.cursorRegenerationDelay == 1000L)) {
                throw new IllegalArgumentException("consumerType, tailTracking, cursorRegenerationDelay options cannot appear on a producer endpoint");
            }
        } else if (role == 'C') {
            if (!ObjectHelper.isEmpty((Object)((Object)this.operation)) || !ObjectHelper.isEmpty((Object)this.writeConcern) || this.writeConcernRef != null || this.readPreference != null || this.dynamicity || this.invokeGetLastError) {
                throw new IllegalArgumentException("operation, writeConcern, writeConcernRef, readPreference, dynamicity, invokeGetLastError options cannot appear on a consumer endpoint");
            }
            if (this.consumerType == MongoDbConsumerType.tailable) {
                if (this.tailTrackIncreasingField == null) {
                    throw new IllegalArgumentException("tailTrackIncreasingField option must be set for tailable cursor MongoDB consumer endpoint");
                }
                if (this.persistentTailTracking && ObjectHelper.isEmpty((Object)this.persistentId)) {
                    throw new IllegalArgumentException("persistentId is compulsory for persistent tail tracking");
                }
            }
        } else {
            throw new IllegalArgumentException("Unknown endpoint role");
        }
    }

    public boolean isSingleton() {
        return true;
    }

    public void initializeConnection() throws CamelMongoDbException {
        LOG.info("Initialising MongoDb endpoint: {}", (Object)this.toString());
        if (this.database == null || this.collection == null) {
            throw new CamelMongoDbException("Missing required endpoint configuration: database and/or collection");
        }
        this.db = this.mongoConnection.getDB(this.database);
        if (this.db == null) {
            throw new CamelMongoDbException("Could not initialise MongoDbComponent. Database " + this.database + " does not exist.");
        }
        if (!this.createCollection && !this.db.collectionExists(this.collection)) {
            throw new CamelMongoDbException("Could not initialise MongoDbComponent. Collection " + this.collection + " and createCollection is false.");
        }
        this.dbCollection = this.db.getCollection(this.collection);
        LOG.debug("MongoDb component initialised and endpoint bound to MongoDB collection with the following parameters. Address list: {}, Db: {}, Collection: {}", new Object[]{this.mongoConnection.getAllAddress().toString(), this.db.getName(), this.dbCollection.getName()});
        try {
            if (ObjectHelper.isNotEmpty((Object)this.collectionIndex)) {
                this.ensureIndex(this.dbCollection, this.createIndex());
            }
        }
        catch (Exception e) {
            throw new CamelMongoDbException("Error creating index", e);
        }
    }

    public void ensureIndex(DBCollection collection, List<DBObject> dynamicIndex) {
        collection.dropIndexes();
        if (dynamicIndex != null && !dynamicIndex.isEmpty()) {
            for (DBObject index : dynamicIndex) {
                LOG.debug("create BDObject Index {}", (Object)index);
                collection.ensureIndex(index);
            }
        }
    }

    public List<DBObject> createIndex() throws Exception {
        ArrayList<DBObject> indexList = new ArrayList<DBObject>();
        if (ObjectHelper.isNotEmpty((Object)this.collectionIndex)) {
            HashMap indexMap = (HashMap)new ObjectMapper().readValue(this.collectionIndex, HashMap.class);
            for (Map.Entry set : indexMap.entrySet()) {
                BasicDBObject index = new BasicDBObject();
                index.put((String)set.getKey(), set.getValue());
                indexList.add((DBObject)index);
            }
        }
        return indexList;
    }

    protected void doStart() throws Exception {
        if (this.writeConcern != null && this.writeConcernRef != null) {
            String msg = "Cannot set both writeConcern and writeConcernRef at the same time. Respective values: " + this.writeConcern + ", " + this.writeConcernRef + ". Aborting initialization.";
            throw new IllegalArgumentException(msg);
        }
        this.setWriteReadOptionsOnConnection();
        super.doStart();
    }

    public Exchange createMongoDbExchange(DBObject dbObj) {
        DefaultExchange exchange = new DefaultExchange(this.getCamelContext(), this.getExchangePattern());
        DefaultMessage message = new DefaultMessage();
        message.setHeader("CamelMongoDbDatabase", (Object)this.database);
        message.setHeader("CamelMongoDbCollection", (Object)this.collection);
        message.setHeader("CamelMongoDbTailable", (Object)true);
        message.setBody((Object)dbObj);
        exchange.setIn((Message)message);
        return exchange;
    }

    private void setWriteReadOptionsOnConnection() {
        if (this.writeConcern != null) {
            this.mongoConnection.setWriteConcern(this.writeConcern);
        } else if (this.writeConcernRef != null) {
            this.mongoConnection.setWriteConcern(this.writeConcernRef);
        }
        if (this.readPreference != null) {
            this.mongoConnection.setReadPreference(this.readPreference);
        }
    }

    public void setCollection(String collection) {
        this.collection = collection;
    }

    public String getCollection() {
        return this.collection;
    }

    public void setCollectionIndex(String collectionIndex) {
        this.collectionIndex = collectionIndex;
    }

    public String getCollectionIndex() {
        return this.collectionIndex;
    }

    public void setOperation(String operation) throws CamelMongoDbException {
        try {
            this.operation = MongoDbOperation.valueOf(operation);
        }
        catch (IllegalArgumentException e) {
            throw new CamelMongoDbException("Operation not supported", e);
        }
    }

    public MongoDbOperation getOperation() {
        return this.operation;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setCreateCollection(boolean createCollection) {
        this.createCollection = createCollection;
    }

    public boolean isCreateCollection() {
        return this.createCollection;
    }

    public DB getDb() {
        return this.db;
    }

    public DBCollection getDbCollection() {
        return this.dbCollection;
    }

    public void setMongoConnection(Mongo mongoConnection) {
        this.mongoConnection = mongoConnection;
    }

    public Mongo getMongoConnection() {
        return this.mongoConnection;
    }

    public void setWriteConcern(String writeConcern) {
        this.writeConcern = WriteConcern.valueOf((String)writeConcern);
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    public void setInvokeGetLastError(boolean invokeGetLastError) {
        this.invokeGetLastError = invokeGetLastError;
    }

    public boolean isInvokeGetLastError() {
        return this.invokeGetLastError;
    }

    public void setWriteConcernRef(String writeConcernRef) {
        WriteConcern wc = (WriteConcern)this.getCamelContext().getRegistry().lookupByNameAndType(writeConcernRef, WriteConcern.class);
        if (wc == null) {
            String msg = "Camel MongoDB component could not find the WriteConcern in the Registry. Verify that the provided bean name (" + writeConcernRef + ")  is correct. Aborting initialization.";
            throw new IllegalArgumentException(msg);
        }
        this.writeConcernRef = wc;
    }

    public WriteConcern getWriteConcernRef() {
        return this.writeConcernRef;
    }

    public void setReadPreference(String readPreference) {
        Class<?>[] innerClasses;
        for (Class<?> inClass : innerClasses = ReadPreference.class.getDeclaredClasses()) {
            if (inClass.getSuperclass() != ReadPreference.class || !inClass.getName().equals(readPreference)) continue;
            try {
                this.readPreference = (ReadPreference)inClass.getConstructor(new Class[]{null}).newInstance(null);
                break;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        String msg = "Could not resolve specified ReadPreference of type " + readPreference + ". Read preferences are resolved from inner classes of com.mongodb.ReadPreference.";
        throw new IllegalArgumentException(msg);
    }

    public ReadPreference getReadPreference() {
        return this.readPreference;
    }

    public void setDynamicity(boolean dynamicity) {
        this.dynamicity = dynamicity;
    }

    public boolean isDynamicity() {
        return this.dynamicity;
    }

    public void setConsumerType(String consumerType) throws CamelMongoDbException {
        try {
            this.consumerType = MongoDbConsumerType.valueOf(consumerType);
        }
        catch (IllegalArgumentException e) {
            throw new CamelMongoDbException("Consumer type not supported", e);
        }
    }

    public MongoDbConsumerType getConsumerType() {
        return this.consumerType;
    }

    public String getTailTrackDb() {
        return this.tailTrackDb;
    }

    public void setTailTrackDb(String tailTrackDb) {
        this.tailTrackDb = tailTrackDb;
    }

    public String getTailTrackCollection() {
        return this.tailTrackCollection;
    }

    public void setTailTrackCollection(String tailTrackCollection) {
        this.tailTrackCollection = tailTrackCollection;
    }

    public String getTailTrackField() {
        return this.tailTrackField;
    }

    public void setTailTrackField(String tailTrackField) {
        this.tailTrackField = tailTrackField;
    }

    public void setPersistentTailTracking(boolean persistentTailTracking) {
        this.persistentTailTracking = persistentTailTracking;
    }

    public boolean isPersistentTailTracking() {
        return this.persistentTailTracking;
    }

    public void setTailTrackIncreasingField(String tailTrackIncreasingField) {
        this.tailTrackIncreasingField = tailTrackIncreasingField;
    }

    public String getTailTrackIncreasingField() {
        return this.tailTrackIncreasingField;
    }

    public MongoDbTailTrackingConfig getTailTrackingConfig() {
        if (this.tailTrackingConfig == null) {
            this.tailTrackingConfig = new MongoDbTailTrackingConfig(this.persistentTailTracking, this.tailTrackIncreasingField, this.tailTrackDb == null ? this.database : this.tailTrackDb, this.tailTrackCollection, this.tailTrackField, this.getPersistentId());
        }
        return this.tailTrackingConfig;
    }

    public void setCursorRegenerationDelay(long cursorRegenerationDelay) {
        this.cursorRegenerationDelay = cursorRegenerationDelay;
    }

    public long getCursorRegenerationDelay() {
        return this.cursorRegenerationDelay;
    }

    public void setPersistentId(String persistentId) {
        this.persistentId = persistentId;
    }

    public String getPersistentId() {
        return this.persistentId;
    }

    public boolean isWriteResultAsHeader() {
        return this.writeResultAsHeader;
    }

    public void setWriteResultAsHeader(boolean writeResultAsHeader) {
        this.writeResultAsHeader = writeResultAsHeader;
    }
}

