/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mongodb;

import com.mongodb.Mongo;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.mongodb.CamelMongoDbException;
import org.apache.camel.component.mongodb.MongoDbEndpoint;
import org.apache.camel.component.mongodb.MongoDbOperation;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.util.CamelContextHelper;

public class MongoDbComponent
extends DefaultComponent {
    public static final Set<MongoDbOperation> WRITE_OPERATIONS = new HashSet<MongoDbOperation>(Arrays.asList(MongoDbOperation.insert, MongoDbOperation.save, MongoDbOperation.update, MongoDbOperation.remove));

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        Mongo db = (Mongo)CamelContextHelper.mandatoryLookup((CamelContext)this.getCamelContext(), (String)remaining, Mongo.class);
        MongoDbEndpoint endpoint = new MongoDbEndpoint(uri, this);
        parameters.put("mongoConnection", db);
        this.setProperties((Object)endpoint, parameters);
        return endpoint;
    }

    public static CamelMongoDbException wrapInCamelMongoDbException(Throwable t) {
        if (t instanceof CamelMongoDbException) {
            return (CamelMongoDbException)t;
        }
        return new CamelMongoDbException(t);
    }
}

