/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mllp.internal;

import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import org.apache.camel.component.mllp.MllpAcknowledgementGenerationException;
import org.apache.camel.component.mllp.MllpProtocolConstants;
import org.apache.camel.component.mllp.internal.MllpSocketBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Hl7Util {
    public static final String NULL_REPLACEMENT_VALUE = "<null>";
    public static final String EMPTY_REPLACEMENT_VALUE = "<>";
    public static final Map<Character, String> CHARACTER_REPLACEMENTS;
    public static final SimpleDateFormat TIMESTAMP_FORMAT;
    static final int STRING_BUFFER_PAD_SIZE = 100;
    static final Logger LOG;
    private final int logPhiMaxBytes;
    private final boolean logPhi;

    public Hl7Util(int logPhiMaxBytes, boolean logPhi) {
        this.logPhiMaxBytes = logPhiMaxBytes;
        this.logPhi = logPhi;
    }

    public int getLogPhiMaxBytes() {
        return this.logPhiMaxBytes;
    }

    public String generateInvalidPayloadExceptionMessage(byte[] hl7Bytes) {
        if (hl7Bytes == null) {
            return "HL7 payload is null";
        }
        return Hl7Util.generateInvalidPayloadExceptionMessage(hl7Bytes, hl7Bytes.length);
    }

    public static String generateInvalidPayloadExceptionMessage(byte[] hl7Bytes, int length) {
        if (hl7Bytes == null) {
            return "HL7 payload is null";
        }
        if (hl7Bytes.length <= 0) {
            return "HL7 payload is empty";
        }
        if (length > hl7Bytes.length) {
            LOG.warn("The length specified for the HL7 payload array <{}> is greater than the actual length of the array <{}> - only validating {} bytes", new Object[]{length, hl7Bytes.length, hl7Bytes.length});
        }
        if (hl7Bytes.length < 3 || hl7Bytes[0] != 77 || hl7Bytes[1] != 83 || hl7Bytes[2] != 72) {
            return String.format("The first segment of the HL7 payload {%s} is not an MSH segment", new String(hl7Bytes, 0, Math.min(3, hl7Bytes.length)));
        }
        int validationLength = Math.min(length, hl7Bytes.length);
        if (hl7Bytes[validationLength - 1] != 13 && hl7Bytes[validationLength - 1] != 10) {
            String format = "The HL7 payload terminating byte [%#x] is incorrect - expected [%#x]  {ASCII [<CR>]}";
            return String.format(format, hl7Bytes[validationLength - 2], (byte)13);
        }
        for (int i = 0; i < validationLength; ++i) {
            switch (hl7Bytes[i]) {
                case 11: {
                    return String.format("HL7 payload contains an embedded START_OF_BLOCK {%#x, ASCII <VT>} at index %d", hl7Bytes[i], i);
                }
                case 28: {
                    return String.format("HL7 payload contains an embedded END_OF_BLOCK {%#x, ASCII <FS>} at index %d", hl7Bytes[i], i);
                }
            }
        }
        return null;
    }

    public static List<Integer> findFieldSeparatorIndicesInSegment(byte[] hl7MessageBytes, int startingIndex) {
        LinkedList<Integer> fieldSeparatorIndices = new LinkedList<Integer>();
        if (hl7MessageBytes != null && hl7MessageBytes.length > startingIndex && hl7MessageBytes.length > 3) {
            byte fieldSeparator = hl7MessageBytes[3];
            for (int i = startingIndex; i < hl7MessageBytes.length; ++i) {
                if (fieldSeparator == hl7MessageBytes[i]) {
                    fieldSeparatorIndices.add(i);
                    continue;
                }
                if (13 != hl7MessageBytes[i]) continue;
                fieldSeparatorIndices.add(i);
                break;
            }
        }
        return fieldSeparatorIndices;
    }

    public String findMsh18(byte[] hl7Message, Charset charset) {
        List<Integer> fieldSeparatorIndexes;
        String answer = "";
        if (hl7Message != null && hl7Message.length > 0 && (fieldSeparatorIndexes = Hl7Util.findFieldSeparatorIndicesInSegment(hl7Message, 0)).size() > 17) {
            int startOfMsh19 = fieldSeparatorIndexes.get(16) + 1;
            int length = fieldSeparatorIndexes.get(17) - fieldSeparatorIndexes.get(16) - 1;
            if (length > 0) {
                answer = new String(hl7Message, startOfMsh19, length, charset);
            }
        }
        return answer;
    }

    public void generateAcknowledgementPayload(MllpSocketBuffer mllpSocketBuffer, byte[] hl7MessageBytes, String acknowledgementCode) throws MllpAcknowledgementGenerationException {
        this.generateAcknowledgementPayload(mllpSocketBuffer, hl7MessageBytes, acknowledgementCode, null);
    }

    public void generateAcknowledgementPayload(MllpSocketBuffer mllpSocketBuffer, byte[] hl7MessageBytes, String acknowledgementCode, String msa3) throws MllpAcknowledgementGenerationException {
        if (hl7MessageBytes == null) {
            throw new MllpAcknowledgementGenerationException("Null HL7 message received for parsing operation", this.logPhi);
        }
        List<Integer> fieldSeparatorIndexes = Hl7Util.findFieldSeparatorIndicesInSegment(hl7MessageBytes, 0);
        if (fieldSeparatorIndexes.isEmpty()) {
            throw new MllpAcknowledgementGenerationException("Failed to find the end of the MSH Segment while attempting to generate response", hl7MessageBytes, this.logPhi);
        }
        if (fieldSeparatorIndexes.size() < 8) {
            String exceptionMessage = String.format("Insufficient number of fields found in MSH to generate a response - 10 are required but %d were found", fieldSeparatorIndexes.size() - 1);
            throw new MllpAcknowledgementGenerationException(exceptionMessage, hl7MessageBytes, this.logPhi);
        }
        byte fieldSeparator = hl7MessageBytes[3];
        mllpSocketBuffer.openMllpEnvelope();
        mllpSocketBuffer.write(hl7MessageBytes, 0, fieldSeparatorIndexes.get(1));
        Hl7Util.writeFieldToBuffer(3, mllpSocketBuffer, hl7MessageBytes, fieldSeparatorIndexes);
        Hl7Util.writeFieldToBuffer(4, mllpSocketBuffer, hl7MessageBytes, fieldSeparatorIndexes);
        Hl7Util.writeFieldToBuffer(1, mllpSocketBuffer, hl7MessageBytes, fieldSeparatorIndexes);
        Hl7Util.writeFieldToBuffer(2, mllpSocketBuffer, hl7MessageBytes, fieldSeparatorIndexes);
        mllpSocketBuffer.write(fieldSeparator);
        mllpSocketBuffer.write(TIMESTAMP_FORMAT.format(new Date()).getBytes());
        mllpSocketBuffer.write(fieldSeparator);
        mllpSocketBuffer.write(fieldSeparator);
        mllpSocketBuffer.write("ACK".getBytes());
        int msh92start = -1;
        byte componentSeparator = hl7MessageBytes[4];
        for (int j = fieldSeparatorIndexes.get(7) + 1; j < fieldSeparatorIndexes.get(8); ++j) {
            if (componentSeparator != hl7MessageBytes[j]) continue;
            msh92start = j;
            break;
        }
        if (-1 == msh92start) {
            LOG.warn("Didn't find component separator for MSH-9.2 - sending ACK in MSH-9");
        } else {
            String msh9Content = this.convertToPrintFriendlyString(hl7MessageBytes, fieldSeparatorIndexes.get(7) + 1, fieldSeparatorIndexes.get(8));
            int[] componentIndexesInMsh9 = this.caretPositionsIn(msh9Content);
            int componentDiff = componentIndexesInMsh9[componentIndexesInMsh9.length - 1] - componentIndexesInMsh9[0];
            if (componentIndexesInMsh9.length == 2) {
                mllpSocketBuffer.write(componentSeparator);
                mllpSocketBuffer.write(hl7MessageBytes, msh92start + 1, componentDiff - 1);
                mllpSocketBuffer.write(componentSeparator);
                mllpSocketBuffer.write("ACK".getBytes());
            } else {
                mllpSocketBuffer.write(hl7MessageBytes, msh92start, fieldSeparatorIndexes.get(8) - msh92start);
            }
        }
        Hl7Util.writeFieldToBuffer(8, mllpSocketBuffer, hl7MessageBytes, fieldSeparatorIndexes);
        if (fieldSeparatorIndexes.get(9) - fieldSeparatorIndexes.get(8) > 1) {
            mllpSocketBuffer.write(65);
        }
        mllpSocketBuffer.write(hl7MessageBytes, fieldSeparatorIndexes.get(9), fieldSeparatorIndexes.get(fieldSeparatorIndexes.size() - 1) - fieldSeparatorIndexes.get(9));
        mllpSocketBuffer.write(13);
        mllpSocketBuffer.write("MSA".getBytes(), 0, 3);
        mllpSocketBuffer.write(fieldSeparator);
        mllpSocketBuffer.write(acknowledgementCode.getBytes(), 0, 2);
        Hl7Util.writeFieldToBuffer(8, mllpSocketBuffer, hl7MessageBytes, fieldSeparatorIndexes);
        if (msa3 != null && !msa3.isEmpty()) {
            mllpSocketBuffer.write(fieldSeparator);
            mllpSocketBuffer.write(msa3.getBytes());
        }
        mllpSocketBuffer.write(13);
        mllpSocketBuffer.write(MllpProtocolConstants.PAYLOAD_TERMINATOR);
    }

    public String convertToPrintFriendlyString(String phiString) {
        if (null == phiString) {
            return NULL_REPLACEMENT_VALUE;
        }
        if (phiString.isEmpty()) {
            return EMPTY_REPLACEMENT_VALUE;
        }
        int conversionLength = this.logPhiMaxBytes > 0 ? Integer.min(phiString.length(), this.logPhiMaxBytes) : phiString.length();
        StringBuilder builder = new StringBuilder(conversionLength + 100);
        for (int i = 0; i < conversionLength; ++i) {
            Hl7Util.appendCharacterAsPrintFriendlyString(builder, phiString.charAt(i));
        }
        return builder.toString();
    }

    public String convertToPrintFriendlyString(byte[] phiBytes) {
        return this.bytesToPrintFriendlyStringBuilder(phiBytes).toString();
    }

    public String convertToPrintFriendlyString(byte[] phiBytes, int startPosition, int endPosition) {
        return this.bytesToPrintFriendlyStringBuilder(phiBytes, startPosition, endPosition).toString();
    }

    public StringBuilder bytesToPrintFriendlyStringBuilder(byte[] phiBytes) {
        return this.bytesToPrintFriendlyStringBuilder(phiBytes, 0, phiBytes != null ? phiBytes.length : -1);
    }

    public StringBuilder bytesToPrintFriendlyStringBuilder(byte[] phiBytes, int startPosition, int endPosition) {
        StringBuilder answer = new StringBuilder();
        this.appendBytesAsPrintFriendlyString(answer, phiBytes, startPosition, endPosition);
        return answer;
    }

    public void appendBytesAsPrintFriendlyString(StringBuilder builder, byte[] phiBytes) {
        this.appendBytesAsPrintFriendlyString(builder, phiBytes, 0, phiBytes != null ? phiBytes.length : 0);
    }

    public void appendBytesAsPrintFriendlyString(StringBuilder builder, byte[] phiBytes, int startPosition, int endPosition) {
        if (builder == null) {
            throw new IllegalArgumentException("StringBuilder cannot be null");
        }
        if (null == phiBytes) {
            builder.append(NULL_REPLACEMENT_VALUE);
        } else if (phiBytes.length == 0) {
            builder.append(EMPTY_REPLACEMENT_VALUE);
        } else if (startPosition <= endPosition) {
            if (startPosition < 0) {
                startPosition = 0;
            }
            if (startPosition < phiBytes.length && endPosition >= -1) {
                int length;
                if (endPosition == -1 || endPosition >= phiBytes.length) {
                    endPosition = phiBytes.length;
                }
                if ((length = endPosition - startPosition) > 0) {
                    int conversionLength;
                    int n = conversionLength = this.logPhiMaxBytes > 0 ? Integer.min(length, this.logPhiMaxBytes) : length;
                    if (builder.capacity() - builder.length() < conversionLength + 100) {
                        builder.ensureCapacity(builder.length() + conversionLength + 100);
                    }
                    for (int i = 0; i < conversionLength; ++i) {
                        Hl7Util.appendCharacterAsPrintFriendlyString(builder, (char)phiBytes[startPosition + i]);
                    }
                }
            }
        }
    }

    static void appendCharacterAsPrintFriendlyString(StringBuilder builder, char c) {
        if (CHARACTER_REPLACEMENTS.containsKey(Character.valueOf(c))) {
            builder.append(CHARACTER_REPLACEMENTS.get(Character.valueOf(c)));
        } else {
            builder.append(c);
        }
    }

    public static String getCharacterAsPrintFriendlyString(char c) {
        if (CHARACTER_REPLACEMENTS.containsKey(Character.valueOf(c))) {
            return CHARACTER_REPLACEMENTS.get(Character.valueOf(c));
        }
        return String.valueOf(c);
    }

    private int[] caretPositionsIn(String data) {
        return IntStream.range(0, data.length()).filter(i -> data.charAt(i) == '^').toArray();
    }

    private static void writeFieldToBuffer(int fieldNumber, MllpSocketBuffer mllpSocketBuffer, byte[] hl7MessageBytes, List<Integer> fieldSeparatorIndexes) {
        mllpSocketBuffer.write(hl7MessageBytes, fieldSeparatorIndexes.get(fieldNumber), fieldSeparatorIndexes.get(fieldNumber + 1) - fieldSeparatorIndexes.get(fieldNumber));
    }

    static {
        TIMESTAMP_FORMAT = new SimpleDateFormat("yyyyMMddHHmmss.SSSZZZZ");
        LOG = LoggerFactory.getLogger(Hl7Util.class);
        CHARACTER_REPLACEMENTS = new HashMap<Character, String>();
        CHARACTER_REPLACEMENTS.put(Character.valueOf('\u0000'), "<0x00 NUL>");
        CHARACTER_REPLACEMENTS.put(Character.valueOf('\u0001'), "<0x01 SOH>");
        CHARACTER_REPLACEMENTS.put(Character.valueOf('\u0002'), "<0x02 STX>");
        CHARACTER_REPLACEMENTS.put(Character.valueOf('\u0003'), "<0x03 ETX>");
        CHARACTER_REPLACEMENTS.put(Character.valueOf('\u0004'), "<0x04 EOT>");
        CHARACTER_REPLACEMENTS.put(Character.valueOf('\u0005'), "<0x05 ENQ>");
        CHARACTER_REPLACEMENTS.put(Character.valueOf('\u0006'), "<0x06 ACK>");
        CHARACTER_REPLACEMENTS.put(Character.valueOf('\u0007'), "<0x07 BEL>");
        CHARACTER_REPLACEMENTS.put(Character.valueOf('\b'), "<0x08 BS>");
        CHARACTER_REPLACEMENTS.put(Character.valueOf('\t'), "<0x09 TAB>");
        CHARACTER_REPLACEMENTS.put(Character.valueOf('\n'), "<0x0A LF>");
        CHARACTER_REPLACEMENTS.put(Character.valueOf('\u000b'), "<0x0B VT>");
        CHARACTER_REPLACEMENTS.put(Character.valueOf('\f'), "<0x0C FF>");
        CHARACTER_REPLACEMENTS.put(Character.valueOf('\r'), "<0x0D CR>");
        CHARACTER_REPLACEMENTS.put(Character.valueOf('\u000e'), "<0x0E SO>");
        CHARACTER_REPLACEMENTS.put(Character.valueOf('\u000f'), "<0x0F SI>");
        CHARACTER_REPLACEMENTS.put(Character.valueOf('\u0010'), "<0x10 DLE>");
        CHARACTER_REPLACEMENTS.put(Character.valueOf('\u0011'), "<0x11 DC1>");
        CHARACTER_REPLACEMENTS.put(Character.valueOf('\u0012'), "<0x12 DC2>");
        CHARACTER_REPLACEMENTS.put(Character.valueOf('\u0013'), "<0x13 DC3>");
        CHARACTER_REPLACEMENTS.put(Character.valueOf('\u0014'), "<0x14 DC4>");
        CHARACTER_REPLACEMENTS.put(Character.valueOf('\u0015'), "<0x15 NAK>");
        CHARACTER_REPLACEMENTS.put(Character.valueOf('\u0016'), "<0x16 SYN>");
        CHARACTER_REPLACEMENTS.put(Character.valueOf('\u0017'), "<0x17 ETB>");
        CHARACTER_REPLACEMENTS.put(Character.valueOf('\u0018'), "<0x18 CAN>");
        CHARACTER_REPLACEMENTS.put(Character.valueOf('\u0019'), "<0x19 EM>");
        CHARACTER_REPLACEMENTS.put(Character.valueOf('\u001a'), "<0x1A SUB>");
        CHARACTER_REPLACEMENTS.put(Character.valueOf('\u001b'), "<0x1B ESC>");
        CHARACTER_REPLACEMENTS.put(Character.valueOf('\u001c'), "<0x1C FS>");
        CHARACTER_REPLACEMENTS.put(Character.valueOf('\u001d'), "<0x1D GS>");
        CHARACTER_REPLACEMENTS.put(Character.valueOf('\u001e'), "<0x1E RS>");
        CHARACTER_REPLACEMENTS.put(Character.valueOf('\u001f'), "<0x1F US>");
        CHARACTER_REPLACEMENTS.put(Character.valueOf('\u007f'), "<0x7F DEL>");
    }
}

