/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mllp;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.SSLContextParametersAware;
import org.apache.camel.component.mllp.MllpConfiguration;
import org.apache.camel.component.mllp.MllpEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.DefaultComponent;

@Component(value="mllp")
public class MllpComponent
extends DefaultComponent
implements SSLContextParametersAware {
    @Metadata(label="advanced", defaultValue="true")
    private boolean logPhi = true;
    @Metadata(label="advanced", defaultValue="5120")
    private int logPhiMaxBytes = 5120;
    @Metadata(label="advanced", defaultValue="ISO-8859-1")
    private String defaultCharset = "ISO_8859_1";
    @Metadata
    private MllpConfiguration configuration;
    @Metadata(label="security", defaultValue="false")
    private boolean useGlobalSslContextParameters;

    public MllpComponent() {
        this.setBridgeErrorHandler(true);
    }

    public MllpComponent(CamelContext context) {
        super(context);
        this.setBridgeErrorHandler(true);
    }

    protected Endpoint createEndpoint(String uriString, String remaining, Map<String, Object> parameters) throws Exception {
        MllpEndpoint endpoint = new MllpEndpoint(uriString, this, this.hasConfiguration() ? this.configuration.copy() : new MllpConfiguration());
        if (endpoint.getConfiguration().getSslContextParameters() == null) {
            endpoint.getConfiguration().setSslContextParameters(this.retrieveGlobalSslContextParameters());
        }
        endpoint.setCharsetName(this.getDefaultCharset());
        int colonIndex = remaining.indexOf(58);
        if (colonIndex != -1) {
            endpoint.setHostname(remaining.substring(0, colonIndex));
            endpoint.setPort(CamelContextHelper.parseInt((CamelContext)this.getCamelContext(), (String)remaining.substring(colonIndex + 1)));
        } else {
            endpoint.setPort(CamelContextHelper.parseInt((CamelContext)this.getCamelContext(), (String)remaining));
        }
        this.setProperties((Endpoint)endpoint, parameters);
        return endpoint;
    }

    public Boolean getLogPhi() {
        return this.logPhi;
    }

    public void setLogPhi(Boolean logPhi) {
        this.logPhi = logPhi;
    }

    public int getLogPhiMaxBytes() {
        return this.logPhiMaxBytes;
    }

    public void setLogPhiMaxBytes(Integer logPhiMaxBytes) {
        this.logPhiMaxBytes = logPhiMaxBytes;
    }

    public String getDefaultCharset() {
        return this.defaultCharset;
    }

    public void setDefaultCharset(String name) {
        this.defaultCharset = name;
    }

    public boolean hasConfiguration() {
        return this.configuration != null;
    }

    public MllpConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(MllpConfiguration configuration) {
        this.configuration = configuration;
    }

    public boolean isUseGlobalSslContextParameters() {
        return this.useGlobalSslContextParameters;
    }

    public void setUseGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
        this.useGlobalSslContextParameters = useGlobalSslContextParameters;
    }
}

