/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.minio;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class MinioEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":bucketName";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;
    private static final Map<String, String> MULTI_VALUE_PREFIXES;

    public boolean isEnabled(String scheme) {
        return "minio".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax = scheme + BASE;
        Object uri = syntax;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, (String)uri, "bucketName", null, true, copy);
        uri = this.buildQueryParameters((String)uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public Map<String, String> multiValuePrefixes() {
        return MULTI_VALUE_PREFIXES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(64);
        props.add("accessKey");
        props.add("autoCloseBody");
        props.add("autoCreateBucket");
        props.add("backoffErrorThreshold");
        props.add("backoffIdleThreshold");
        props.add("backoffMultiplier");
        props.add("bridgeErrorHandler");
        props.add("bucketName");
        props.add("bypassGovernanceMode");
        props.add("customHttpClient");
        props.add("delay");
        props.add("deleteAfterRead");
        props.add("deleteAfterWrite");
        props.add("delimiter");
        props.add("destinationBucketName");
        props.add("destinationObjectName");
        props.add("endpoint");
        props.add("exceptionHandler");
        props.add("exchangePattern");
        props.add("greedy");
        props.add("includeBody");
        props.add("includeFolders");
        props.add("includeUserMetadata");
        props.add("includeVersions");
        props.add("initialDelay");
        props.add("keyName");
        props.add("lazyStartProducer");
        props.add("length");
        props.add("matchETag");
        props.add("maxConnections");
        props.add("maxMessagesPerPoll");
        props.add("minioClient");
        props.add("modifiedSince");
        props.add("moveAfterRead");
        props.add("notMatchETag");
        props.add("objectLock");
        props.add("objectName");
        props.add("offset");
        props.add("operation");
        props.add("pojoRequest");
        props.add("policy");
        props.add("pollStrategy");
        props.add("prefix");
        props.add("proxyPort");
        props.add("recursive");
        props.add("region");
        props.add("repeatCount");
        props.add("runLoggingLevel");
        props.add("scheduledExecutorService");
        props.add("scheduler");
        props.add("schedulerProperties");
        props.add("secretKey");
        props.add("secure");
        props.add("sendEmptyMessageWhenIdle");
        props.add("serverSideEncryption");
        props.add("serverSideEncryptionCustomerKey");
        props.add("startAfter");
        props.add("startScheduler");
        props.add("storageClass");
        props.add("timeUnit");
        props.add("unModifiedSince");
        props.add("useFixedDelay");
        props.add("useVersion1");
        props.add("versionId");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(2);
        secretProps.add("accessKey");
        secretProps.add("secretKey");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
        HashMap<String, String> prefixes = new HashMap<String, String>(1);
        prefixes.put("schedulerProperties", "scheduler.");
        MULTI_VALUE_PREFIXES = Collections.unmodifiableMap(prefixes);
    }
}

