/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mina;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinaPayloadHolder
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final transient Log LOG = LogFactory.getLog(MinaPayloadHolder.class);
    private Object inBody;
    private Object outBody;
    private Object faultBody;
    private Map<String, Object> inHeaders = new LinkedHashMap<String, Object>();
    private Map<String, Object> outHeaders = new LinkedHashMap<String, Object>();
    private Map<String, Object> properties = new LinkedHashMap<String, Object>();
    private Map<String, Object> faultHeaders = new LinkedHashMap<String, Object>();
    private Throwable exception;

    public static MinaPayloadHolder marshal(Exchange exchange) {
        MinaPayloadHolder payload = new MinaPayloadHolder();
        payload.inBody = MinaPayloadHolder.checkSerializableObject(exchange.getIn().getBody());
        if (exchange.getOut(false) != null) {
            payload.outBody = MinaPayloadHolder.checkSerializableObject(exchange.getOut().getBody());
        }
        payload.inHeaders.putAll(MinaPayloadHolder.checkMapSerializableObjects(exchange.getIn().getHeaders()));
        payload.outHeaders.putAll(MinaPayloadHolder.checkMapSerializableObjects(exchange.getOut().getHeaders()));
        payload.properties.putAll(MinaPayloadHolder.checkMapSerializableObjects(exchange.getProperties()));
        payload.exception = exchange.getException();
        if (exchange.getFault(false) != null) {
            payload.faultBody = exchange.getFault().getBody();
            payload.faultHeaders.putAll(MinaPayloadHolder.checkMapSerializableObjects(exchange.getFault().getHeaders()));
        }
        return payload;
    }

    public static void unmarshal(Exchange exchange, MinaPayloadHolder payload) {
        exchange.getIn().setBody(payload.inBody);
        exchange.getOut().setBody(payload.outBody);
        exchange.getIn().setHeaders(payload.inHeaders);
        exchange.getOut().setHeaders(payload.outHeaders);
        if (payload.faultBody != null) {
            exchange.getFault().setBody(payload.faultBody);
            exchange.getFault().setHeaders(payload.faultHeaders);
        }
        for (String key : payload.properties.keySet()) {
            exchange.setProperty(key, payload.properties.get(key));
        }
        exchange.setException(payload.exception);
    }

    public String toString() {
        return "MinaPayloadHolder{inBody=" + this.inBody + ", outBody=" + this.outBody + ", inHeaders=" + this.inHeaders + ", outHeaders=" + this.outHeaders + ", faultBody=" + this.faultBody + " , faultHeaders=" + this.faultHeaders + ", properties=" + this.properties + ", exception=" + this.exception + '}';
    }

    private static Object checkSerializableObject(Object object) {
        if (object instanceof Serializable) {
            return object;
        }
        LOG.warn((Object)("Object " + object + " can't be serialized, it will be excluded by the MinaPayloadHolder"));
        return null;
    }

    private static Map<String, Object> checkMapSerializableObjects(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() instanceof Serializable) {
                result.put(entry.getKey(), entry.getValue());
                continue;
            }
            LOG.warn((Object)("Object " + entry.getValue() + " of key " + entry.getKey() + " can't be serialized, it will be excluded by the MinaPayloadHolder"));
        }
        return result;
    }
}

