/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mina;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.ExchangePattern;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.component.mina.MinaEndpoint;
import org.apache.camel.component.mina.MinaExchange;
import org.apache.camel.component.mina.TextLineCodecFactory;
import org.apache.camel.component.mina.TextLineDelimiter;
import org.apache.camel.impl.DefaultComponent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoAcceptor;
import org.apache.mina.common.IoAcceptorConfig;
import org.apache.mina.common.IoConnector;
import org.apache.mina.common.IoConnectorConfig;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.LoggingFilter;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;
import org.apache.mina.filter.codec.serialization.ObjectSerializationCodecFactory;
import org.apache.mina.filter.codec.textline.LineDelimiter;
import org.apache.mina.transport.socket.nio.DatagramAcceptor;
import org.apache.mina.transport.socket.nio.DatagramAcceptorConfig;
import org.apache.mina.transport.socket.nio.DatagramConnector;
import org.apache.mina.transport.socket.nio.DatagramConnectorConfig;
import org.apache.mina.transport.socket.nio.SocketAcceptor;
import org.apache.mina.transport.socket.nio.SocketAcceptorConfig;
import org.apache.mina.transport.socket.nio.SocketConnector;
import org.apache.mina.transport.socket.nio.SocketConnectorConfig;
import org.apache.mina.transport.vmpipe.VmPipeAcceptor;
import org.apache.mina.transport.vmpipe.VmPipeAddress;
import org.apache.mina.transport.vmpipe.VmPipeConnector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinaComponent
extends DefaultComponent<MinaExchange> {
    private static final transient Log LOG = LogFactory.getLog(MinaComponent.class);
    private static final long DEFAULT_CONNECT_TIMEOUT = 30000L;
    private boolean sync = true;
    private boolean textline;
    private TextLineDelimiter textlineDelimiter;
    private String codec;
    private String encoding;
    private long timeout;
    private boolean lazySessionCreation;
    private boolean transferExchange;
    private boolean minaLogger;
    private CharsetEncoder encoder;

    public MinaComponent() {
    }

    public MinaComponent(CamelContext context) {
        super(context);
    }

    protected Endpoint<MinaExchange> createEndpoint(String uri, String remaining, Map parameters) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Creating MinaEndpoint from uri: " + uri));
        }
        this.setProperties((Object)this, parameters);
        URI u = new URI(remaining);
        String protocol = u.getScheme();
        if (protocol != null) {
            if (protocol.equals("tcp")) {
                return this.createSocketEndpoint(uri, u, parameters);
            }
            if (protocol.equals("udp") || protocol.equals("mcast") || protocol.equals("multicast")) {
                return this.createDatagramEndpoint(uri, u, parameters);
            }
            if (protocol.equals("vm")) {
                return this.createVmEndpoint(uri, u);
            }
        }
        throw new IllegalArgumentException("Unrecognised MINA protocol: " + protocol + " for uri: " + uri);
    }

    protected MinaEndpoint createVmEndpoint(String uri, URI connectUri) {
        VmPipeAcceptor acceptor = new VmPipeAcceptor();
        VmPipeAddress address = new VmPipeAddress(connectUri.getPort());
        VmPipeConnector connector = new VmPipeConnector();
        this.configureCodecFactory("MinaProducer", connector.getDefaultConfig(), this.textline, this.encoding, this.codec);
        if (this.minaLogger) {
            connector.getFilterChain().addLast("logger", (IoFilter)new LoggingFilter());
        }
        this.configureCodecFactory("MinaConsumer", acceptor.getDefaultConfig(), this.textline, this.encoding, this.codec);
        if (this.minaLogger) {
            acceptor.getFilterChain().addLast("logger", (IoFilter)new LoggingFilter());
        }
        MinaEndpoint endpoint = new MinaEndpoint(uri, this, (SocketAddress)address, (IoAcceptor)acceptor, null, (IoConnector)connector, null, false, this.timeout, this.transferExchange, this.sync);
        if (this.encoding != null) {
            endpoint.setCharsetName(MinaComponent.getEncodingParameter("MinaProducer", this.encoding).name());
        }
        if (this.sync) {
            endpoint.setExchangePattern(ExchangePattern.InOut);
        } else {
            endpoint.setExchangePattern(ExchangePattern.InOnly);
        }
        return endpoint;
    }

    protected MinaEndpoint createSocketEndpoint(String uri, URI connectUri, Map parameters) {
        SocketAcceptor acceptor = new SocketAcceptor();
        InetSocketAddress address = new InetSocketAddress(connectUri.getHost(), connectUri.getPort());
        SocketConnector connector = new SocketConnector();
        SocketConnectorConfig connectorConfig = new SocketConnectorConfig();
        this.configureCodecFactory("MinaProducer", (IoServiceConfig)connectorConfig, this.textline, this.encoding, this.codec);
        if (this.minaLogger) {
            connectorConfig.getFilterChain().addLast("logger", (IoFilter)new LoggingFilter());
        }
        long connectTimeout = this.timeout > 0L ? this.timeout : 30000L;
        connectorConfig.setConnectTimeout((int)(connectTimeout / 1000L));
        SocketAcceptorConfig acceptorConfig = new SocketAcceptorConfig();
        this.configureCodecFactory("MinaConsumer", (IoServiceConfig)acceptorConfig, this.textline, this.encoding, this.codec);
        acceptorConfig.setReuseAddress(true);
        acceptorConfig.setDisconnectOnUnbind(true);
        if (this.minaLogger) {
            acceptorConfig.getFilterChain().addLast("logger", (IoFilter)new LoggingFilter());
        }
        MinaEndpoint endpoint = new MinaEndpoint(uri, this, address, (IoAcceptor)acceptor, (IoAcceptorConfig)acceptorConfig, (IoConnector)connector, (IoConnectorConfig)connectorConfig, this.lazySessionCreation, this.timeout, this.transferExchange, this.sync);
        if (this.encoding != null) {
            endpoint.setCharsetName(MinaComponent.getEncodingParameter("MinaProducer", this.encoding).name());
        }
        if (this.sync) {
            endpoint.setExchangePattern(ExchangePattern.InOut);
        } else {
            endpoint.setExchangePattern(ExchangePattern.InOnly);
        }
        return endpoint;
    }

    protected void configureCodecFactory(String type, IoServiceConfig config, boolean textline, String encoding, String codec) {
        ProtocolCodecFactory codecFactory = this.getCodecFactory(type, codec);
        if (codecFactory == null) {
            if (textline) {
                Charset charset = MinaComponent.getEncodingParameter(type, encoding);
                LineDelimiter delimiter = this.getLineDelimiterParameter();
                codecFactory = new TextLineCodecFactory(charset, delimiter);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(type + ": Using TextLineCodecFactory: " + codecFactory + " using encoding: " + charset + " and line delimiter: " + (Object)((Object)this.textlineDelimiter) + "(" + delimiter + ")"));
                }
            } else {
                codecFactory = new ObjectSerializationCodecFactory();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(type + ": Using ObjectSerializationCodecFactory: " + codecFactory));
                }
            }
        }
        this.addCodecFactory(config, codecFactory);
    }

    protected MinaEndpoint createDatagramEndpoint(String uri, URI connectUri, Map parameters) {
        DatagramAcceptor acceptor = new DatagramAcceptor();
        InetSocketAddress address = new InetSocketAddress(connectUri.getHost(), connectUri.getPort());
        DatagramConnector connector = new DatagramConnector();
        if (this.transferExchange) {
            throw new IllegalArgumentException("transferExchange=true is not supported for datagram protocol");
        }
        DatagramConnectorConfig connectorConfig = new DatagramConnectorConfig();
        this.configureDataGramCodecFactory("MinaProducer", (IoServiceConfig)connectorConfig, this.encoding, this.codec);
        if (this.minaLogger) {
            connectorConfig.getFilterChain().addLast("logger", (IoFilter)new LoggingFilter());
        }
        long connectTimeout = this.timeout > 0L ? this.timeout : 30000L;
        connectorConfig.setConnectTimeout((int)(connectTimeout / 1000L));
        DatagramAcceptorConfig acceptorConfig = new DatagramAcceptorConfig();
        this.configureDataGramCodecFactory("MinaConsumer", (IoServiceConfig)acceptorConfig, this.encoding, this.codec);
        acceptorConfig.setDisconnectOnUnbind(true);
        if (this.minaLogger) {
            acceptorConfig.getFilterChain().addLast("logger", (IoFilter)new LoggingFilter());
        }
        MinaEndpoint endpoint = new MinaEndpoint(uri, this, address, (IoAcceptor)acceptor, (IoAcceptorConfig)acceptorConfig, (IoConnector)connector, (IoConnectorConfig)connectorConfig, this.lazySessionCreation, this.timeout, this.transferExchange, this.sync);
        if (this.encoding != null) {
            endpoint.setCharsetName(MinaComponent.getEncodingParameter("MinaProducer", this.encoding).name());
        }
        if (this.sync) {
            endpoint.setExchangePattern(ExchangePattern.InOut);
        } else {
            endpoint.setExchangePattern(ExchangePattern.InOnly);
        }
        return endpoint;
    }

    private static Charset getEncodingParameter(String type, String encoding) {
        if (encoding == null) {
            encoding = Charset.defaultCharset().name();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(type + ": No encoding parameter using default charset: " + encoding));
            }
        }
        if (!Charset.isSupported(encoding)) {
            throw new IllegalArgumentException("The encoding: " + encoding + " is not supported");
        }
        return Charset.forName(encoding);
    }

    protected void configureDataGramCodecFactory(String type, IoServiceConfig config, String encoding, String codec) {
        ProtocolCodecFactory codecFactory = this.getCodecFactory(type, codec);
        if (codecFactory == null) {
            codecFactory = new ProtocolCodecFactory(){

                public ProtocolEncoder getEncoder() throws Exception {
                    return new ProtocolEncoder(){

                        public void encode(IoSession session, Object message, ProtocolEncoderOutput out) throws Exception {
                            ByteBuffer buf = MinaComponent.this.toByteBuffer(message);
                            buf.flip();
                            out.write(buf);
                        }

                        public void dispose(IoSession session) throws Exception {
                        }
                    };
                }

                public ProtocolDecoder getDecoder() throws Exception {
                    return new ProtocolDecoder(){

                        public void decode(IoSession session, ByteBuffer in, ProtocolDecoderOutput out) throws Exception {
                            in.acquire();
                            out.write((Object)in);
                        }

                        public void finishDecode(IoSession session, ProtocolDecoderOutput out) throws Exception {
                        }

                        public void dispose(IoSession session) throws Exception {
                        }
                    };
                }
            };
            Charset charset = MinaComponent.getEncodingParameter(type, encoding);
            this.encoder = charset.newEncoder();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(type + ": Using CodecFactory: " + codecFactory + " using encoding: " + charset));
            }
        }
        this.addCodecFactory(config, codecFactory);
    }

    protected ByteBuffer toByteBuffer(Object message) throws CharacterCodingException {
        ByteBuffer answer = null;
        try {
            answer = (ByteBuffer)this.convertTo(ByteBuffer.class, message);
        }
        catch (NoTypeConversionAvailableException e) {
            String value = (String)this.convertTo(String.class, message);
            answer = ByteBuffer.allocate((int)value.length()).setAutoExpand(true);
            answer.putString((CharSequence)value, this.encoder);
        }
        return answer;
    }

    protected ProtocolCodecFactory getCodecFactory(String type, String codec) {
        ProtocolCodecFactory codecFactory = null;
        if (codec != null) {
            codecFactory = (ProtocolCodecFactory)this.getCamelContext().getRegistry().lookup(codec, ProtocolCodecFactory.class);
            if (codecFactory == null) {
                throw new IllegalArgumentException("Codec " + codec + " not found in registry.");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(type + ": Using custom CodecFactory: " + codecFactory));
            }
        }
        return codecFactory;
    }

    protected void addCodecFactory(IoServiceConfig config, ProtocolCodecFactory codecFactory) {
        config.getFilterChain().addLast("codec", (IoFilter)new ProtocolCodecFilter(codecFactory));
    }

    private LineDelimiter getLineDelimiterParameter() {
        if (this.textlineDelimiter == null) {
            return LineDelimiter.DEFAULT;
        }
        switch (this.textlineDelimiter) {
            case DEFAULT: {
                return LineDelimiter.DEFAULT;
            }
            case AUTO: {
                return LineDelimiter.AUTO;
            }
            case UNIX: {
                return LineDelimiter.UNIX;
            }
            case WINDOWS: {
                return LineDelimiter.WINDOWS;
            }
            case MAC: {
                return LineDelimiter.MAC;
            }
        }
        throw new IllegalArgumentException("Unknown textline delimiter: " + (Object)((Object)this.textlineDelimiter));
    }

    public boolean isSync() {
        return this.sync;
    }

    public void setSync(boolean sync) {
        this.sync = sync;
    }

    public boolean isTextline() {
        return this.textline;
    }

    public void setTextline(boolean textline) {
        this.textline = textline;
    }

    public TextLineDelimiter getTextlineDelimiter() {
        return this.textlineDelimiter;
    }

    public void setTextlineDelimiter(TextLineDelimiter textlineDelimiter) {
        this.textlineDelimiter = textlineDelimiter;
    }

    public String getCodec() {
        return this.codec;
    }

    public void setCodec(String codec) {
        this.codec = codec;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public boolean isLazySessionCreation() {
        return this.lazySessionCreation;
    }

    public void setLazySessionCreation(boolean lazySessionCreation) {
        this.lazySessionCreation = lazySessionCreation;
    }

    public boolean isTransferExchange() {
        return this.transferExchange;
    }

    public void setTransferExchange(boolean transferExchange) {
        this.transferExchange = transferExchange;
    }

    public boolean isMinaLogger() {
        return this.minaLogger;
    }

    public void setMinaLogger(boolean minaLogger) {
        this.minaLogger = minaLogger;
    }
}

