/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mina;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.mina.MinaEndpoint;
import org.apache.camel.component.mina.MinaExchange;
import org.apache.camel.converter.ObjectConverter;
import org.apache.camel.impl.DefaultComponent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoAcceptor;
import org.apache.mina.common.IoAcceptorConfig;
import org.apache.mina.common.IoConnector;
import org.apache.mina.common.IoConnectorConfig;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.LoggingFilter;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;
import org.apache.mina.filter.codec.serialization.ObjectSerializationCodecFactory;
import org.apache.mina.filter.codec.textline.TextLineCodecFactory;
import org.apache.mina.transport.socket.nio.DatagramAcceptor;
import org.apache.mina.transport.socket.nio.DatagramAcceptorConfig;
import org.apache.mina.transport.socket.nio.DatagramConnector;
import org.apache.mina.transport.socket.nio.DatagramConnectorConfig;
import org.apache.mina.transport.socket.nio.SocketAcceptor;
import org.apache.mina.transport.socket.nio.SocketAcceptorConfig;
import org.apache.mina.transport.socket.nio.SocketConnector;
import org.apache.mina.transport.socket.nio.SocketConnectorConfig;
import org.apache.mina.transport.vmpipe.VmPipeAcceptor;
import org.apache.mina.transport.vmpipe.VmPipeAddress;
import org.apache.mina.transport.vmpipe.VmPipeConnector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinaComponent
extends DefaultComponent<MinaExchange> {
    private static final transient Log LOG = LogFactory.getLog(MinaComponent.class);
    private CharsetEncoder encoder;

    public MinaComponent() {
    }

    public MinaComponent(CamelContext context) {
        super(context);
    }

    protected Endpoint<MinaExchange> createEndpoint(String uri, String remaining, Map parameters) throws Exception {
        URI u;
        String protocol;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Creating MinaEndpoint from uri: " + uri));
        }
        if ((protocol = (u = new URI(remaining)).getScheme()) != null) {
            if (protocol.equals("tcp")) {
                return this.createSocketEndpoint(uri, u, parameters);
            }
            if (protocol.equals("udp") || protocol.equals("mcast") || protocol.equals("multicast")) {
                return this.createDatagramEndpoint(uri, u, parameters);
            }
            if (protocol.equals("vm")) {
                return this.createVmEndpoint(uri, u);
            }
        }
        throw new IllegalArgumentException("Unrecognised MINA protocol: " + protocol + " for uri: " + uri);
    }

    protected MinaEndpoint createVmEndpoint(String uri, URI connectUri) {
        VmPipeAcceptor acceptor = new VmPipeAcceptor();
        VmPipeAddress address = new VmPipeAddress(connectUri.getPort());
        VmPipeConnector connector = new VmPipeConnector();
        return new MinaEndpoint(uri, this, (SocketAddress)address, (IoAcceptor)acceptor, null, (IoConnector)connector, null, false, 0L, false);
    }

    protected MinaEndpoint createSocketEndpoint(String uri, URI connectUri, Map parameters) {
        SocketAcceptor acceptor = new SocketAcceptor();
        InetSocketAddress address = new InetSocketAddress(connectUri.getHost(), connectUri.getPort());
        SocketConnector connector = new SocketConnector();
        boolean lazySessionCreation = ObjectConverter.toBool(parameters.get("lazySessionCreation"));
        long timeout = MinaComponent.getTimeoutParameter(parameters);
        boolean transferExchange = ObjectConverter.toBool(parameters.get("transferExchange"));
        boolean sync = ObjectConverter.toBool(parameters.get("sync"));
        boolean minaLogger = ObjectConverter.toBool(parameters.get("minaLogger"));
        SocketConnectorConfig connectorConfig = new SocketConnectorConfig();
        this.configureSocketCodecFactory("MinaProducer", (IoServiceConfig)connectorConfig, parameters);
        if (minaLogger) {
            connectorConfig.getFilterChain().addLast("logger", (IoFilter)new LoggingFilter());
        }
        SocketAcceptorConfig acceptorConfig = new SocketAcceptorConfig();
        this.configureSocketCodecFactory("MinaConsumer", (IoServiceConfig)acceptorConfig, parameters);
        acceptorConfig.setReuseAddress(true);
        acceptorConfig.setDisconnectOnUnbind(true);
        if (minaLogger) {
            acceptorConfig.getFilterChain().addLast("logger", (IoFilter)new LoggingFilter());
        }
        MinaEndpoint endpoint = new MinaEndpoint(uri, this, address, (IoAcceptor)acceptor, (IoAcceptorConfig)acceptorConfig, (IoConnector)connector, (IoConnectorConfig)connectorConfig, lazySessionCreation, timeout, transferExchange);
        if (sync) {
            endpoint.setExchangePattern(ExchangePattern.InOut);
        } else {
            endpoint.setExchangePattern(ExchangePattern.InOnly);
        }
        return endpoint;
    }

    protected void configureSocketCodecFactory(String type, IoServiceConfig config, Map parameters) {
        ProtocolCodecFactory codecFactory = this.getCodecFactory(type, parameters);
        if (codecFactory == null) {
            boolean textline = ObjectConverter.toBool(parameters.get("textline"));
            if (textline) {
                Charset encoding = this.getEncodingParameter(type, parameters);
                codecFactory = new TextLineCodecFactory(encoding);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(type + ": Using TextLineCodecFactory: " + codecFactory + " using encoding: " + encoding));
                }
            } else {
                codecFactory = new ObjectSerializationCodecFactory();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(type + ": Using ObjectSerializationCodecFactory: " + codecFactory));
                }
            }
        }
        this.addCodecFactory(config, codecFactory);
    }

    protected MinaEndpoint createDatagramEndpoint(String uri, URI connectUri, Map parameters) {
        DatagramAcceptor acceptor = new DatagramAcceptor();
        InetSocketAddress address = new InetSocketAddress(connectUri.getHost(), connectUri.getPort());
        DatagramConnector connector = new DatagramConnector();
        boolean lazySessionCreation = ObjectConverter.toBool(parameters.get("lazySessionCreation"));
        long timeout = MinaComponent.getTimeoutParameter(parameters);
        boolean transferExchange = false;
        boolean sync = ObjectConverter.toBool(parameters.get("sync"));
        boolean minaLogger = ObjectConverter.toBool(parameters.get("minaLogger"));
        DatagramConnectorConfig connectorConfig = new DatagramConnectorConfig();
        this.configureDataGramCodecFactory("MinaProducer", (IoServiceConfig)connectorConfig, parameters);
        if (minaLogger) {
            connectorConfig.getFilterChain().addLast("logger", (IoFilter)new LoggingFilter());
        }
        DatagramAcceptorConfig acceptorConfig = new DatagramAcceptorConfig();
        this.configureDataGramCodecFactory("MinaConsumer", (IoServiceConfig)acceptorConfig, parameters);
        acceptorConfig.setDisconnectOnUnbind(true);
        if (minaLogger) {
            acceptorConfig.getFilterChain().addLast("logger", (IoFilter)new LoggingFilter());
        }
        MinaEndpoint endpoint = new MinaEndpoint(uri, this, address, (IoAcceptor)acceptor, (IoAcceptorConfig)acceptorConfig, (IoConnector)connector, (IoConnectorConfig)connectorConfig, lazySessionCreation, timeout, transferExchange);
        if (sync) {
            endpoint.setExchangePattern(ExchangePattern.InOut);
        } else {
            endpoint.setExchangePattern(ExchangePattern.InOnly);
        }
        return endpoint;
    }

    private Charset getEncodingParameter(String type, Map parameters) {
        String encoding = (String)parameters.get("encoding");
        if (encoding == null) {
            encoding = Charset.defaultCharset().name();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(type + ": No encoding parameter using default charset: " + encoding));
            }
        }
        if (!Charset.isSupported(encoding)) {
            throw new IllegalArgumentException("The encoding: " + encoding + " is not supported");
        }
        return Charset.forName(encoding);
    }

    private static long getTimeoutParameter(Map parameters) throws IllegalArgumentException {
        long timeout = 0L;
        String value = (String)parameters.get("timeout");
        if (value != null) {
            try {
                timeout = ObjectConverter.toLong((Object)value);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("The timeout parameter is not a number: " + value);
            }
        }
        return timeout;
    }

    protected void configureDataGramCodecFactory(String type, IoServiceConfig config, Map parameters) {
        ProtocolCodecFactory codecFactory = this.getCodecFactory(type, parameters);
        if (codecFactory == null) {
            codecFactory = new ProtocolCodecFactory(){

                public ProtocolEncoder getEncoder() throws Exception {
                    return new ProtocolEncoder(){

                        public void encode(IoSession session, Object message, ProtocolEncoderOutput out) throws Exception {
                            ByteBuffer buf = MinaComponent.this.toByteBuffer(message);
                            buf.flip();
                            out.write(buf);
                        }

                        public void dispose(IoSession session) throws Exception {
                        }
                    };
                }

                public ProtocolDecoder getDecoder() throws Exception {
                    return new ProtocolDecoder(){

                        public void decode(IoSession session, ByteBuffer in, ProtocolDecoderOutput out) throws Exception {
                            in.acquire();
                            out.write((Object)in);
                        }

                        public void finishDecode(IoSession session, ProtocolDecoderOutput out) throws Exception {
                        }

                        public void dispose(IoSession session) throws Exception {
                        }
                    };
                }
            };
            Charset encoding = this.getEncodingParameter(type, parameters);
            this.encoder = encoding.newEncoder();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(type + ": Using CodecFactory: " + codecFactory + " using encoding: " + encoding));
            }
        }
        this.addCodecFactory(config, codecFactory);
    }

    protected ByteBuffer toByteBuffer(Object message) throws CharacterCodingException {
        ByteBuffer answer = (ByteBuffer)this.convertTo(ByteBuffer.class, message);
        if (answer == null) {
            String value = (String)this.convertTo(String.class, message);
            answer = ByteBuffer.allocate((int)value.length()).setAutoExpand(true);
            answer.putString((CharSequence)value, this.encoder);
        }
        return answer;
    }

    protected ProtocolCodecFactory getCodecFactory(String type, Map parameters) {
        ProtocolCodecFactory codecFactory = null;
        String codec = (String)parameters.get("codec");
        if (codec != null) {
            codecFactory = (ProtocolCodecFactory)this.getCamelContext().getRegistry().lookup(codec, ProtocolCodecFactory.class);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(type + ": Using custom CodecFactory: " + codecFactory));
            }
        }
        return codecFactory;
    }

    protected void addCodecFactory(IoServiceConfig config, ProtocolCodecFactory codecFactory) {
        config.getFilterChain().addLast("codec", (IoFilter)new ProtocolCodecFilter(codecFactory));
    }
}

