/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mina;

import java.net.SocketAddress;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.mina.MinaComponent;
import org.apache.camel.component.mina.MinaConsumer;
import org.apache.camel.component.mina.MinaExchange;
import org.apache.camel.component.mina.MinaProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.mina.common.IoAcceptor;
import org.apache.mina.common.IoConnector;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.IoSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinaEndpoint
extends DefaultEndpoint<MinaExchange> {
    private final IoAcceptor acceptor;
    private final SocketAddress address;
    private final IoConnector connector;
    private final IoServiceConfig config;

    public MinaEndpoint(String endpointUri, MinaComponent component, SocketAddress address, IoAcceptor acceptor, IoConnector connector, IoServiceConfig config) {
        super(endpointUri, (Component)component);
        this.config = config;
        this.address = address;
        this.acceptor = acceptor;
        this.connector = connector;
    }

    public Producer<MinaExchange> createProducer() throws Exception {
        return new MinaProducer(this);
    }

    public Consumer<MinaExchange> createConsumer(Processor processor) throws Exception {
        return new MinaConsumer(this, processor);
    }

    public MinaExchange createExchange(ExchangePattern pattern) {
        return new MinaExchange(this.getContext(), pattern);
    }

    public MinaExchange createExchange(IoSession session, Object object) {
        MinaExchange exchange = new MinaExchange(this.getContext(), this.getExchangePattern());
        exchange.getIn().setBody(object);
        return exchange;
    }

    public IoAcceptor getAcceptor() {
        return this.acceptor;
    }

    public SocketAddress getAddress() {
        return this.address;
    }

    public IoConnector getConnector() {
        return this.connector;
    }

    public IoServiceConfig getConfig() {
        return this.config;
    }

    public boolean isSingleton() {
        return true;
    }
}

