/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.milo;

import java.util.Base64;
import java.util.Objects;
import java.util.UUID;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;

public final class NodeIds {
    private NodeIds() {
    }

    public static NodeId toNodeId(UShort namespaceIndex, ExpandedNodeId nodeId) {
        Objects.requireNonNull(namespaceIndex);
        Object id = nodeId.getIdentifier();
        if (id instanceof String) {
            return new NodeId(namespaceIndex, (String)id);
        }
        if (id instanceof UInteger) {
            return new NodeId(namespaceIndex, (UInteger)id);
        }
        if (id instanceof ByteString) {
            return new NodeId(namespaceIndex, (ByteString)id);
        }
        if (id instanceof UUID) {
            return new NodeId(namespaceIndex, (UUID)id);
        }
        throw new IllegalStateException("Invalid id type: " + String.valueOf(id));
    }

    public static NodeId toNodeId(int namespaceIndex, ExpandedNodeId nodeId) {
        return NodeIds.toNodeId(Unsigned.ushort((int)namespaceIndex), nodeId);
    }

    public static String nodeValue(String namespace, String node) {
        Objects.requireNonNull(namespace);
        Objects.requireNonNull(node);
        StringBuilder builder = new StringBuilder("RAW(");
        NodeIds.appendNamespace(builder, namespace);
        builder.append(';');
        NodeIds.appendNodeId(builder, node);
        builder.append(')');
        return builder.toString();
    }

    public static String nodeValue(String namespace, int node) {
        Objects.requireNonNull(namespace);
        StringBuilder builder = new StringBuilder("RAW(");
        NodeIds.appendNamespace(builder, namespace);
        builder.append(';');
        NodeIds.appendNodeId(builder, node);
        builder.append(')');
        return builder.toString();
    }

    public static String nodeValue(String namespace, UUID node) {
        Objects.requireNonNull(namespace);
        Objects.requireNonNull(node);
        StringBuilder builder = new StringBuilder("RAW(");
        NodeIds.appendNamespace(builder, namespace);
        builder.append(';');
        NodeIds.appendNodeId(builder, node);
        builder.append(')');
        return builder.toString();
    }

    public static String nodeValue(String namespace, ByteString node) {
        Objects.requireNonNull(namespace);
        Objects.requireNonNull(node);
        StringBuilder builder = new StringBuilder("RAW(");
        NodeIds.appendNamespace(builder, namespace);
        builder.append(';');
        NodeIds.appendNodeId(builder, node);
        builder.append(')');
        return builder.toString();
    }

    public static String nodeValue(int namespace, String node) {
        Objects.requireNonNull(namespace);
        Objects.requireNonNull(node);
        StringBuilder builder = new StringBuilder("RAW(");
        NodeIds.appendNamespace(builder, namespace);
        builder.append(';');
        NodeIds.appendNodeId(builder, node);
        builder.append(')');
        return builder.toString();
    }

    public static String nodeValue(int namespace, int node) {
        Objects.requireNonNull(namespace);
        StringBuilder builder = new StringBuilder("RAW(");
        NodeIds.appendNamespace(builder, namespace);
        builder.append(';');
        NodeIds.appendNodeId(builder, node);
        builder.append(')');
        return builder.toString();
    }

    public static String nodeValue(int namespace, UUID node) {
        Objects.requireNonNull(namespace);
        Objects.requireNonNull(node);
        StringBuilder builder = new StringBuilder("RAW(");
        NodeIds.appendNamespace(builder, namespace);
        builder.append(';');
        NodeIds.appendNodeId(builder, node);
        builder.append(')');
        return builder.toString();
    }

    public static String nodeValue(int namespace, ByteString node) {
        Objects.requireNonNull(namespace);
        Objects.requireNonNull(node);
        StringBuilder builder = new StringBuilder("RAW(");
        NodeIds.appendNamespace(builder, namespace);
        builder.append(';');
        NodeIds.appendNodeId(builder, node);
        builder.append(')');
        return builder.toString();
    }

    private static void appendNamespace(StringBuilder builder, String namespace) {
        builder.append("nsu=").append(namespace);
    }

    private static void appendNamespace(StringBuilder builder, int namespace) {
        builder.append("ns=").append(Integer.toUnsignedString(namespace));
    }

    private static void appendNodeId(StringBuilder builder, String nodeId) {
        builder.append("s=").append(nodeId);
    }

    private static void appendNodeId(StringBuilder builder, int nodeId) {
        builder.append("i=").append(Integer.toUnsignedString(nodeId));
    }

    private static void appendNodeId(StringBuilder builder, UUID nodeId) {
        builder.append("g=").append(nodeId);
    }

    private static void appendNodeId(StringBuilder builder, ByteString nodeId) {
        builder.append("b=").append(Base64.getEncoder().encodeToString(nodeId.bytes()));
    }
}

