/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.milo;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.NoSuchElementException;
import org.apache.camel.RuntimeCamelException;

public class KeyStoreLoader {
    public static final String DEFAULT_KEY_STORE_TYPE = "PKCS12";
    private String type = "PKCS12";
    private URL url;
    private String keyStorePassword;
    private String keyPassword;
    private String keyAlias;

    public void setType(String type) {
        this.type = type != null ? type : DEFAULT_KEY_STORE_TYPE;
    }

    public String getType() {
        return this.type;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(String url) throws MalformedURLException {
        this.url = new URL(url);
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public void setKeyAlias(String keyAlias) {
        this.keyAlias = keyAlias;
    }

    public String getKeyAlias() {
        return this.keyAlias;
    }

    public Result load() throws GeneralSecurityException, IOException {
        Key privateKey;
        KeyStore keyStore = KeyStore.getInstance(this.type);
        try (InputStream stream = this.url.openStream();){
            keyStore.load(stream, this.keyStorePassword != null ? this.keyStorePassword.toCharArray() : null);
        }
        String effectiveKeyAlias = this.keyAlias;
        if (effectiveKeyAlias == null) {
            if (keyStore.size() != 1) {
                throw new IllegalArgumentException("Key store contains more than one key. The use of the 'keyAlias' parameter is required.");
            }
            try {
                effectiveKeyAlias = keyStore.aliases().nextElement();
            }
            catch (NoSuchElementException e) {
                throw new RuntimeCamelException("Failed to enumerate key alias", (Throwable)e);
            }
        }
        if ((privateKey = keyStore.getKey(effectiveKeyAlias, this.keyPassword != null ? this.keyPassword.toCharArray() : null)) instanceof PrivateKey) {
            X509Certificate certificate = (X509Certificate)keyStore.getCertificate(effectiveKeyAlias);
            if (certificate == null) {
                return null;
            }
            PublicKey publicKey = certificate.getPublicKey();
            KeyPair keyPair = new KeyPair(publicKey, (PrivateKey)privateKey);
            return new Result(certificate, keyPair);
        }
        return null;
    }

    public static class Result {
        private final X509Certificate certificate;
        private final KeyPair keyPair;

        public Result(X509Certificate certificate, KeyPair keyPair) {
            this.certificate = certificate;
            this.keyPair = keyPair;
        }

        public X509Certificate getCertificate() {
            return this.certificate;
        }

        public KeyPair getKeyPair() {
            return this.keyPair;
        }
    }
}

