/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.micrometer;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.util.function.Function;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.component.micrometer.MicrometerEndpoint;
import org.apache.camel.spi.Language;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;

public abstract class AbstractMicrometerProducer<T extends Meter>
extends DefaultProducer {
    private static final String HEADER_PATTERN = "CamelMetrics*";
    private Iterable<Tag> tags;

    protected AbstractMicrometerProducer(MicrometerEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    protected void doBuild() throws Exception {
        super.doBuild();
        this.tags = this.getEndpoint().createTags();
    }

    public MicrometerEndpoint getEndpoint() {
        return (MicrometerEndpoint)super.getEndpoint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Exchange exchange) {
        Message in = exchange.getIn();
        String defaultMetricsName = this.simple(exchange, this.getEndpoint().getMetricsName(), String.class);
        String finalMetricsName = this.getStringHeader(in, "CamelMetricsName", defaultMetricsName);
        String defaultMetricsDescription = this.simple(exchange, this.getEndpoint().getMetricsDescription(), String.class);
        String finalMetricsDescription = this.getStringHeader(in, "CamelMetricsDescription", defaultMetricsDescription);
        Iterable<Tag> headerTags = this.getTagHeader(in, "CamelMetricsTags", (Iterable<Tag>)Tags.empty());
        Tags finalTags = Tags.concat(this.tags, headerTags).stream().map(tag -> Tag.of((String)this.simple(exchange, tag.getKey(), String.class), (String)this.simple(exchange, tag.getValue(), String.class))).reduce(Tags.empty(), (rec$, xva$0) -> ((Tags)rec$).and(new Tag[]{xva$0}), Tags::and).and((Iterable)Tags.of((String)"camelContext", (String)this.getEndpoint().getCamelContext().getName()));
        try {
            this.doProcess(exchange, finalMetricsName, finalMetricsDescription, (Iterable<Tag>)finalTags);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        finally {
            this.clearMetricsHeaders(in);
        }
    }

    protected abstract Function<MeterRegistry, T> registrar(String var1, String var2, Iterable<Tag> var3);

    protected void doProcess(Exchange exchange, String name, String description, Iterable<Tag> tags) {
        this.doProcess(exchange, this.getEndpoint(), this.getOrRegisterMeter(name, description, tags));
    }

    protected T getOrRegisterMeter(String name, String description, Iterable<Tag> tags) {
        MeterRegistry registry = this.getEndpoint().getRegistry();
        return (T)((Meter)this.registrar(name, description, tags).apply(registry));
    }

    protected abstract void doProcess(Exchange var1, MicrometerEndpoint var2, T var3);

    protected <C> C simple(Exchange exchange, String expression, Class<C> clazz) {
        Language language;
        Expression simple;
        if (expression != null && (simple = (language = exchange.getContext().resolveLanguage("simple")).createExpression(expression)) != null) {
            return (C)simple.evaluate(exchange, clazz);
        }
        return (C)this.getEndpoint().getCamelContext().getTypeConverter().convertTo(clazz, (Object)expression);
    }

    protected String getStringHeader(Message in, String header, String defaultValue) {
        String headerValue = (String)in.getHeader(header, String.class);
        return ObjectHelper.isNotEmpty((String)headerValue) ? headerValue : defaultValue;
    }

    protected Double getDoubleHeader(Message in, String header, Double defaultValue) {
        return (Double)in.getHeader(header, (Object)defaultValue, Double.class);
    }

    protected Iterable<Tag> getTagHeader(Message in, String header, Iterable<Tag> defaultTags) {
        return (Iterable)in.getHeader(header, defaultTags, Iterable.class);
    }

    protected boolean clearMetricsHeaders(Message in) {
        return in.removeHeaders(HEADER_PATTERN);
    }
}

