/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.micrometer.prometheus.internal;

import io.micrometer.core.instrument.binder.MeterBinder;
import java.lang.reflect.Modifier;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeSet;
import org.apache.camel.component.micrometer.prometheus.BindersHelper;
import org.apache.camel.impl.engine.DefaultClassResolver;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.util.StringHelper;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;

public class BindersDiscoveryMain {
    private static final String JANDEX_INDEX = "META-INF/micrometer-binder-index.dat";

    public static void main(String[] args) throws Exception {
        TreeSet<String> answer = new TreeSet<String>();
        Index index = BindersHelper.readJandexIndex((ClassResolver)new DefaultClassResolver());
        if (index == null) {
            System.out.println("Cannot read META-INF/micrometer-binder-index.dat with list of known MeterBinder classes");
        } else {
            DotName dn = DotName.createSimple(MeterBinder.class);
            Set classes = index.getAllKnownImplementors(dn);
            for (ClassInfo info : classes) {
                boolean noArg;
                boolean abs;
                boolean deprecated = info.hasAnnotation(Deprecated.class);
                if (deprecated || (abs = Modifier.isAbstract(info.flags())) || !(noArg = info.hasNoArgsConstructor())) continue;
                String name = info.name().local();
                if (name.endsWith("Metrics")) {
                    name = name.substring(0, name.length() - 7);
                }
                name = StringHelper.camelCaseToDash((String)name);
                answer.add(name);
            }
        }
        StringJoiner sj = new StringJoiner(", ");
        answer.forEach(sj::add);
        System.out.println(sj);
    }
}

