/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven;

import java.io.File;
import javax.inject.Inject;
import org.apache.camel.maven.RunMojo;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Resource;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProjectBuilder;

@Mojo(name="dev", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class DevMojo
extends RunMojo {
    @Parameter(property="camel.routesDirectory")
    private String routesDirectory;

    @Inject
    public DevMojo(ArtifactResolver artifactResolver, ArtifactFactory artifactFactory, ArtifactMetadataSource metadataSource, MavenProjectBuilder projectBuilder) {
        super(artifactResolver, artifactFactory, metadataSource, projectBuilder);
    }

    @Override
    protected void beforeBootstrapCamel() throws Exception {
        String dir = this.routesDirectory != null ? this.routesDirectory : (this.project.getResources().size() == 1 ? ((Resource)this.project.getResources().get(0)).getDirectory() : "src/main/resources");
        dir = new File(dir).getAbsolutePath();
        System.setProperty("camel.main.profile", this.profile == null ? "dev" : this.profile);
        System.setProperty("camel.main.routesReloadEnabled", "true");
        System.setProperty("camel.main.routesReloadDirectory", dir);
        System.setProperty("camel.main.routesReloadDirectoryRecursive", "true");
        System.setProperty("camel.main.sourceLocationEnabled", "true");
        System.setProperty("camel.main.durationMaxAction", "stop");
        System.setProperty("camel.main.routesReloadPattern", "*.xml,*.yaml,*.java");
    }

    @Override
    protected String goal() {
        return "camel:dev";
    }
}

