/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.ManagedThrottlerMBean;
import org.apache.camel.builder.Builder;
import org.apache.camel.management.mbean.ManagedProcessor;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.Throttler;
import org.apache.camel.processor.TotalRequestsThrottler;

@ManagedResource(description="Managed Concurrent Requests Throttler")
public class ManagedThrottler
extends ManagedProcessor
implements ManagedThrottlerMBean {
    public ManagedThrottler(CamelContext context, Throttler throttler, ProcessorDefinition<?> definition) {
        super(context, (Processor)throttler, definition);
    }

    public Throttler getProcessor() {
        return (Throttler)super.getProcessor();
    }

    public long getMaximumRequests() {
        return this.getProcessor().getCurrentMaximumRequests();
    }

    public void setMaximumRequests(long maximumConcurrentRequests) {
        this.getProcessor().setMaximumRequestsExpression((Expression)Builder.constant((Object)maximumConcurrentRequests));
    }

    public long getTimePeriodMillis() {
        Throttler throttler = this.getProcessor();
        if (throttler instanceof TotalRequestsThrottler) {
            TotalRequestsThrottler t = (TotalRequestsThrottler)throttler;
            return t.getTimePeriodMillis();
        }
        return 0L;
    }

    public void setTimePeriodMillis(long timePeriodMillis) {
        Throttler throttler = this.getProcessor();
        if (throttler instanceof TotalRequestsThrottler) {
            TotalRequestsThrottler t = (TotalRequestsThrottler)throttler;
            t.setTimePeriodMillis(timePeriodMillis);
        }
    }

    public String getMode() {
        return this.getProcessor().getMode();
    }

    public Boolean isAsyncDelayed() {
        return this.getProcessor().isAsyncDelayed();
    }

    public Boolean isCallerRunsWhenRejected() {
        return this.getProcessor().isCallerRunsWhenRejected();
    }

    public Boolean isRejectExecution() {
        return this.getProcessor().isRejectExecution();
    }
}

