/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.util.Map;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.apache.camel.CamelContext;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.CamelOpenMBeanTypes;
import org.apache.camel.api.management.mbean.ManagedEnricherMBean;
import org.apache.camel.management.mbean.ManagedProcessor;
import org.apache.camel.model.EnrichDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.Enricher;
import org.apache.camel.spi.EndpointUtilizationStatistics;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.util.URISupport;

@ManagedResource(description="Managed Enricher")
public class ManagedEnricher
extends ManagedProcessor
implements ManagedEnricherMBean {
    private String uri;
    private boolean sanitize;

    public ManagedEnricher(CamelContext context, Enricher processor, EnrichDefinition definition) {
        super(context, (Processor)processor, (ProcessorDefinition<?>)definition);
    }

    @Override
    public void init(ManagementStrategy strategy) {
        super.init(strategy);
        this.sanitize = strategy.getManagementAgent().getMask() != null ? strategy.getManagementAgent().getMask() : true;
        this.uri = this.getDefinition().getExpression().getExpression();
        if (this.sanitize) {
            this.uri = URISupport.sanitizeUri((String)this.uri);
        }
    }

    public Enricher getProcessor() {
        return (Enricher)super.getProcessor();
    }

    @Override
    public void reset() {
        super.reset();
        if (this.getProcessor().getEndpointUtilizationStatistics() != null) {
            this.getProcessor().getEndpointUtilizationStatistics().clear();
        }
    }

    @Override
    public Boolean getSupportExtendedInformation() {
        return true;
    }

    public EnrichDefinition getDefinition() {
        return (EnrichDefinition)super.getDefinition();
    }

    public String getExpressionLanguage() {
        return this.getDefinition().getExpression().getLanguage();
    }

    public String getExpression() {
        return this.uri;
    }

    public String getVariableSend() {
        return this.getProcessor().getVariableSend();
    }

    public String getVariableReceive() {
        return this.getProcessor().getVariableReceive();
    }

    public Integer getCacheSize() {
        return this.getProcessor().getCacheSize();
    }

    public Boolean isIgnoreInvalidEndpoint() {
        return this.getProcessor().isIgnoreInvalidEndpoint();
    }

    public Boolean isShareUnitOfWork() {
        return this.getProcessor().isShareUnitOfWork();
    }

    public Boolean isAggregateOnException() {
        return this.getProcessor().isAggregateOnException();
    }

    public TabularData extendedInformation() {
        try {
            TabularDataSupport answer = new TabularDataSupport(CamelOpenMBeanTypes.endpointsUtilizationTabularType());
            EndpointUtilizationStatistics stats = this.getProcessor().getEndpointUtilizationStatistics();
            if (stats != null) {
                for (Map.Entry entry : stats.getStatistics().entrySet()) {
                    Long hits;
                    CompositeType ct = CamelOpenMBeanTypes.endpointsUtilizationCompositeType();
                    String url = (String)entry.getKey();
                    if (this.sanitize) {
                        url = URISupport.sanitizeUri((String)url);
                    }
                    if ((hits = (Long)entry.getValue()) == null) {
                        hits = 0L;
                    }
                    CompositeDataSupport data = new CompositeDataSupport(ct, new String[]{"url", "hits"}, new Object[]{url, hits});
                    answer.put(data);
                }
            }
            return answer;
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
    }
}

