/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.util.Map;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.apache.camel.CamelContext;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.CamelOpenMBeanTypes;
import org.apache.camel.api.management.mbean.ManagedRecipientListMBean;
import org.apache.camel.management.mbean.ManagedProcessor;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RecipientListDefinition;
import org.apache.camel.processor.RecipientList;
import org.apache.camel.spi.EndpointUtilizationStatistics;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.util.URISupport;

@ManagedResource(description="Managed RecipientList")
public class ManagedRecipientList
extends ManagedProcessor
implements ManagedRecipientListMBean {
    private String uri;
    private boolean sanitize;

    public ManagedRecipientList(CamelContext context, RecipientList processor, RecipientListDefinition<?> definition) {
        super(context, (Processor)processor, (ProcessorDefinition<?>)definition);
    }

    @Override
    public void init(ManagementStrategy strategy) {
        super.init(strategy);
        this.sanitize = strategy.getManagementAgent().getMask() != null ? strategy.getManagementAgent().getMask() : true;
        this.uri = this.getDefinition().getExpression().getExpression();
        if (this.sanitize) {
            this.uri = URISupport.sanitizeUri((String)this.uri);
        }
    }

    public RecipientList getProcessor() {
        return (RecipientList)super.getProcessor();
    }

    @Override
    public void reset() {
        super.reset();
        if (this.getProcessor().getEndpointUtilizationStatistics() != null) {
            this.getProcessor().getEndpointUtilizationStatistics().clear();
        }
    }

    @Override
    public Boolean getSupportExtendedInformation() {
        return true;
    }

    public RecipientListDefinition<?> getDefinition() {
        return (RecipientListDefinition)super.getDefinition();
    }

    public String getExpressionLanguage() {
        return this.getDefinition().getExpression().getLanguage();
    }

    public String getExpression() {
        return this.uri;
    }

    public String getUriDelimiter() {
        return this.getProcessor().getDelimiter();
    }

    public Integer getCacheSize() {
        return this.getProcessor().getCacheSize();
    }

    public Boolean isParallelAggregate() {
        return this.getProcessor().isParallelAggregate();
    }

    public Boolean isParallelProcessing() {
        return this.getProcessor().isParallelProcessing();
    }

    public Boolean isStreaming() {
        return this.getProcessor().isStreaming();
    }

    public Boolean isStopOnException() {
        return this.getProcessor().isStopOnException();
    }

    public Boolean isShareUnitOfWork() {
        return this.getProcessor().isShareUnitOfWork();
    }

    public Long getTimeout() {
        return this.getProcessor().getTimeout();
    }

    public TabularData extendedInformation() {
        try {
            TabularDataSupport answer = new TabularDataSupport(CamelOpenMBeanTypes.endpointsUtilizationTabularType());
            EndpointUtilizationStatistics stats = this.getProcessor().getEndpointUtilizationStatistics();
            if (stats != null) {
                for (Map.Entry entry : stats.getStatistics().entrySet()) {
                    Long hits;
                    CompositeType ct = CamelOpenMBeanTypes.endpointsUtilizationCompositeType();
                    String url = (String)entry.getKey();
                    if (this.sanitize) {
                        url = URISupport.sanitizeUri((String)url);
                    }
                    if ((hits = (Long)entry.getValue()) == null) {
                        hits = 0L;
                    }
                    CompositeDataSupport data = new CompositeDataSupport(ct, new String[]{"url", "hits"}, new Object[]{url, hits});
                    answer.put(data);
                }
            }
            return answer;
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
    }
}

