/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.util.Collection;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.apache.camel.CamelContext;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.Service;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.CamelOpenMBeanTypes;
import org.apache.camel.api.management.mbean.ManagedInflightRepositoryMBean;
import org.apache.camel.management.mbean.ManagedService;
import org.apache.camel.spi.InflightRepository;

@ManagedResource(description="Managed InflightRepository")
public class ManagedInflightRepository
extends ManagedService
implements ManagedInflightRepositoryMBean {
    private final InflightRepository inflightRepository;

    public ManagedInflightRepository(CamelContext context, InflightRepository inflightRepository) {
        super(context, (Service)inflightRepository);
        this.inflightRepository = inflightRepository;
    }

    public InflightRepository getInflightRepository() {
        return this.inflightRepository;
    }

    public int getSize() {
        return this.inflightRepository.size();
    }

    public boolean isInflightBrowseEnabled() {
        return this.inflightRepository.isInflightBrowseEnabled();
    }

    public int size(String routeId) {
        return this.inflightRepository.size(routeId);
    }

    public TabularData browse() {
        return this.browse(null, -1, false);
    }

    public TabularData browse(int limit, boolean sortByLongestDuration) {
        return this.browse(null, limit, sortByLongestDuration);
    }

    public TabularData browse(String routeId, int limit, boolean sortByLongestDuration) {
        try {
            TabularDataSupport answer = new TabularDataSupport(CamelOpenMBeanTypes.listInflightExchangesTabularType());
            Collection exchanges = this.inflightRepository.browse(routeId, limit, sortByLongestDuration);
            for (InflightRepository.InflightExchange entry : exchanges) {
                CompositeType ct = CamelOpenMBeanTypes.listInflightExchangesCompositeType();
                CompositeData data = ManagedInflightRepository.toCompositeData(entry, ct);
                answer.put(data);
            }
            return answer;
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
    }

    private static CompositeData toCompositeData(InflightRepository.InflightExchange entry, CompositeType ct) throws OpenDataException {
        String exchangeId = entry.getExchange().getExchangeId();
        String fromRouteId = entry.getFromRouteId();
        String atRouteId = entry.getAtRouteId();
        String nodeId = entry.getNodeId();
        String elapsed = Long.toString(entry.getElapsed());
        String duration = Long.toString(entry.getDuration());
        return new CompositeDataSupport(ct, new String[]{"exchangeId", "fromRouteId", "routeId", "nodeId", "elapsed", "duration"}, new Object[]{exchangeId, fromRouteId, atRouteId, nodeId, elapsed, duration});
    }
}

