/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.apache.camel.CamelContext;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.Service;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.CamelOpenMBeanTypes;
import org.apache.camel.api.management.mbean.ManagedVariableRepositoryMBean;
import org.apache.camel.management.mbean.ManagedService;
import org.apache.camel.spi.BrowsableVariableRepository;

@ManagedResource(description="Managed VariableRepository")
public class ManagedVariableRepository
extends ManagedService
implements ManagedVariableRepositoryMBean {
    private final BrowsableVariableRepository variableRepository;

    public ManagedVariableRepository(CamelContext context, BrowsableVariableRepository variableRepository) {
        super(context, (Service)variableRepository);
        this.variableRepository = variableRepository;
    }

    public BrowsableVariableRepository getVariableRepository() {
        return this.variableRepository;
    }

    public String getId() {
        return this.variableRepository.getId();
    }

    public int getSize() {
        return this.variableRepository.size();
    }

    public void clear() {
        this.variableRepository.clear();
    }

    public Set<String> names() {
        return this.variableRepository.names().collect(Collectors.toSet());
    }

    public TabularData variables() {
        try {
            TabularDataSupport answer = new TabularDataSupport(CamelOpenMBeanTypes.camelVariablesTabularType());
            CompositeType type = CamelOpenMBeanTypes.camelVariablesCompositeType();
            for (Map.Entry entry : this.variableRepository.getVariables().entrySet()) {
                Object value;
                String key = (String)entry.getKey();
                String className = entry.getValue() != null ? entry.getValue().getClass().getName() : "";
                Object object = value = entry.getValue() != null ? entry.getValue().toString() : "";
                if (((String)value).length() > 1000) {
                    value = ((String)value).substring(0, 1000) + "...";
                }
                CompositeDataSupport data = new CompositeDataSupport(type, new String[]{"id", "key", "className", "value"}, new Object[]{this.getId(), key, className, value});
                answer.put(data);
            }
            return answer;
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
    }
}

