/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Processor;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.ManagedAggregateProcessorMBean;
import org.apache.camel.management.mbean.ManagedProcessor;
import org.apache.camel.model.AggregateDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.aggregate.AggregateProcessor;
import org.apache.camel.spi.ManagementStrategy;

@ManagedResource(description="Managed AggregateProcessor")
public class ManagedAggregateProcessor
extends ManagedProcessor
implements ManagedAggregateProcessorMBean {
    private final AggregateProcessor processor;

    public ManagedAggregateProcessor(CamelContext context, AggregateProcessor processor, AggregateDefinition definition) {
        super(context, (Processor)processor, (ProcessorDefinition<?>)definition);
        this.processor = processor;
    }

    @Override
    public void init(ManagementStrategy strategy) {
        super.init(strategy);
    }

    public AggregateProcessor getProcessor() {
        return this.processor;
    }

    public AggregateDefinition getDefinition() {
        return (AggregateDefinition)super.getDefinition();
    }

    public String getCorrelationExpressionLanguage() {
        if (this.getDefinition().getCorrelationExpression() != null) {
            return this.getDefinition().getCorrelationExpression().getExpressionType().getLanguage();
        }
        return null;
    }

    public String getCorrelationExpression() {
        if (this.getDefinition().getCorrelationExpression() != null) {
            return this.getDefinition().getCorrelationExpression().getExpressionType().getExpression();
        }
        return null;
    }

    public long getCompletionTimeout() {
        return this.processor.getCompletionTimeout();
    }

    public String getCompletionTimeoutLanguage() {
        if (this.getDefinition().getCompletionTimeoutExpression() != null) {
            return this.getDefinition().getCompletionTimeoutExpression().getExpressionType().getLanguage();
        }
        return null;
    }

    public String getCompletionTimeoutExpression() {
        if (this.getDefinition().getCompletionTimeoutExpression() != null) {
            return this.getDefinition().getCompletionTimeoutExpression().getExpressionType().getExpression();
        }
        return null;
    }

    public long getCompletionInterval() {
        return this.processor.getCompletionInterval();
    }

    public long getCompletionTimeoutCheckerInterval() {
        return this.processor.getCompletionTimeoutCheckerInterval();
    }

    public int getCompletionSize() {
        return this.processor.getCompletionSize();
    }

    public String getCompletionSizeExpressionLanguage() {
        if (this.getDefinition().getCompletionSizeExpression() != null) {
            return this.getDefinition().getCompletionSizeExpression().getExpressionType().getLanguage();
        }
        return null;
    }

    public String getCompletionSizeExpression() {
        if (this.getDefinition().getCompletionSizeExpression() != null) {
            return this.getDefinition().getCompletionSizeExpression().getExpressionType().getExpression();
        }
        return null;
    }

    public boolean isCompletionFromBatchConsumer() {
        return this.processor.isCompletionFromBatchConsumer();
    }

    public boolean isCompletionOnNewCorrelationGroup() {
        return this.processor.isCompletionOnNewCorrelationGroup();
    }

    public boolean isIgnoreInvalidCorrelationKeys() {
        return this.processor.isIgnoreInvalidCorrelationKeys();
    }

    public Integer getCloseCorrelationKeyOnCompletion() {
        return this.processor.getCloseCorrelationKeyOnCompletion();
    }

    public boolean isParallelProcessing() {
        return this.processor.isParallelProcessing();
    }

    public boolean isOptimisticLocking() {
        return this.processor.isOptimisticLocking();
    }

    public boolean isEagerCheckCompletion() {
        return this.processor.isEagerCheckCompletion();
    }

    public String getCompletionPredicateLanguage() {
        if (this.getDefinition().getCompletionPredicate() != null) {
            return this.getDefinition().getCompletionPredicate().getExpressionType().getLanguage();
        }
        return null;
    }

    public String getCompletionPredicate() {
        if (this.getDefinition().getCompletionPredicate() != null) {
            return this.getDefinition().getCompletionPredicate().getExpressionType().getExpression();
        }
        return null;
    }

    public boolean isDiscardOnCompletionTimeout() {
        return this.processor.isDiscardOnCompletionTimeout();
    }

    public boolean isForceCompletionOnStop() {
        return this.processor.isCompletionFromBatchConsumer();
    }

    public boolean isCompleteAllOnStop() {
        return this.processor.isCompleteAllOnStop();
    }

    public int getInProgressCompleteExchanges() {
        return this.processor.getInProgressCompleteExchanges();
    }

    public int aggregationRepositoryGroups() {
        Set keys = this.processor.getAggregationRepository().getKeys();
        if (keys != null) {
            return keys.size();
        }
        return 0;
    }

    public int forceCompletionOfGroup(String key) {
        if (this.processor.getAggregateController() != null) {
            return this.processor.getAggregateController().forceCompletionOfGroup(key);
        }
        return 0;
    }

    public int forceCompletionOfAllGroups() {
        if (this.processor.getAggregateController() != null) {
            return this.processor.getAggregateController().forceCompletionOfAllGroups();
        }
        return 0;
    }

    public int forceDiscardingOfGroup(String key) {
        if (this.processor.getAggregateController() != null) {
            return this.processor.getAggregateController().forceDiscardingOfGroup(key);
        }
        return 0;
    }

    public int forceDiscardingOfAllGroups() {
        if (this.processor.getAggregateController() != null) {
            return this.processor.getAggregateController().forceDiscardingOfAllGroups();
        }
        return 0;
    }

    public int getClosedCorrelationKeysCacheSize() {
        return this.processor.getClosedCorrelationKeysCacheSize();
    }

    public void clearClosedCorrelationKeysCache() {
        this.processor.clearClosedCorrelationKeysCache();
    }

    public long getTotalIn() {
        return this.processor.getStatistics().getTotalIn();
    }

    public long getTotalCompleted() {
        return this.processor.getStatistics().getTotalCompleted();
    }

    public long getCompletedBySize() {
        return this.processor.getStatistics().getCompletedBySize();
    }

    public long getCompletedByStrategy() {
        return this.processor.getStatistics().getCompletedByStrategy();
    }

    public long getCompletedByInterval() {
        return this.processor.getStatistics().getCompletedByInterval();
    }

    public long getCompletedByTimeout() {
        return this.processor.getStatistics().getCompletedByTimeout();
    }

    public long getCompletedByPredicate() {
        return this.processor.getStatistics().getCompletedByPredicate();
    }

    public long getCompletedByBatchConsumer() {
        return this.processor.getStatistics().getCompletedByBatchConsumer();
    }

    public long getCompletedByForce() {
        return this.processor.getStatistics().getCompletedByForce();
    }

    public long getDiscarded() {
        return this.processor.getStatistics().getDiscarded();
    }

    public void resetStatistics() {
        this.processor.getStatistics().reset();
    }
}

