/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import javax.management.AttributeValueExp;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.Query;
import javax.management.QueryExp;
import javax.management.StringValueExp;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.ManagementStatisticsLevel;
import org.apache.camel.NamedNode;
import org.apache.camel.Route;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.ServiceStatus;
import org.apache.camel.TimerListener;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.CamelOpenMBeanTypes;
import org.apache.camel.api.management.mbean.ManagedProcessorMBean;
import org.apache.camel.api.management.mbean.ManagedRouteMBean;
import org.apache.camel.api.management.mbean.ManagedStepMBean;
import org.apache.camel.api.management.mbean.RouteError;
import org.apache.camel.management.mbean.LoadTriplet;
import org.apache.camel.management.mbean.ManagedPerformanceCounter;
import org.apache.camel.model.Model;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.InflightRepository;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.spi.RoutePolicy;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedResource(description="Managed Route")
public class ManagedRoute
extends ManagedPerformanceCounter
implements TimerListener,
ManagedRouteMBean {
    public static final String VALUE_UNKNOWN = "Unknown";
    private static final Logger LOG = LoggerFactory.getLogger(ManagedRoute.class);
    protected final Route route;
    protected final String description;
    protected final String configurationId;
    protected final String sourceLocation;
    protected final String sourceLocationShort;
    protected final CamelContext context;
    private final LoadTriplet load = new LoadTriplet();
    private final String jmxDomain;

    public ManagedRoute(CamelContext context, Route route) {
        this.route = route;
        this.context = context;
        this.description = route.getDescription();
        this.configurationId = route.getConfigurationId();
        this.sourceLocation = route.getSourceLocation();
        this.sourceLocationShort = route.getSourceLocationShort();
        this.jmxDomain = context.getManagementStrategy().getManagementAgent().getMBeanObjectDomainName();
    }

    @Override
    public void init(ManagementStrategy strategy) {
        super.init(strategy);
        boolean enabled = this.context.getManagementStrategy().getManagementAgent().getStatisticsLevel() != ManagementStatisticsLevel.Off;
        this.setStatisticsEnabled(enabled);
    }

    public Route getRoute() {
        return this.route;
    }

    public CamelContext getContext() {
        return this.context;
    }

    public String getRouteId() {
        String id = this.route.getId();
        if (id == null) {
            id = VALUE_UNKNOWN;
        }
        return id;
    }

    public String getRouteGroup() {
        return this.route.getGroup();
    }

    public TabularData getRouteProperties() {
        try {
            Map properties = this.route.getProperties();
            TabularDataSupport answer = new TabularDataSupport(CamelOpenMBeanTypes.camelRoutePropertiesTabularType());
            CompositeType ct = CamelOpenMBeanTypes.camelRoutePropertiesCompositeType();
            for (Map.Entry entry : properties.entrySet()) {
                String key = (String)entry.getKey();
                String val = (String)this.context.getTypeConverter().convertTo(String.class, entry.getValue());
                CompositeDataSupport data = new CompositeDataSupport(ct, new String[]{"key", "value"}, new Object[]{key, val});
                answer.put(data);
            }
            return answer;
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public String getSourceLocation() {
        return this.sourceLocation;
    }

    public String getSourceLocationShort() {
        return null;
    }

    public String getRouteConfigurationId() {
        return this.configurationId;
    }

    public String getEndpointUri() {
        if (this.route.getEndpoint() != null) {
            return this.route.getEndpoint().getEndpointUri();
        }
        return VALUE_UNKNOWN;
    }

    public String getState() {
        ServiceStatus status = this.context.getRouteController().getRouteStatus(this.route.getId());
        if (status == null) {
            status = ServiceStatus.Stopped;
        }
        return status.name();
    }

    public String getUptime() {
        return this.route.getUptime();
    }

    public long getUptimeMillis() {
        return this.route.getUptimeMillis();
    }

    public String getCamelId() {
        return this.context.getName();
    }

    public String getCamelManagementName() {
        return this.context.getManagementName();
    }

    public Boolean getTracing() {
        return this.route.isTracing();
    }

    public void setTracing(Boolean tracing) {
        this.route.setTracing(tracing);
    }

    public Boolean getMessageHistory() {
        return this.route.isMessageHistory();
    }

    public Boolean getLogMask() {
        return this.route.isLogMask();
    }

    public String getRoutePolicyList() {
        List policyList = this.route.getRoutePolicyList();
        if (policyList == null || policyList.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < policyList.size(); ++i) {
            RoutePolicy policy = (RoutePolicy)policyList.get(i);
            sb.append(policy.getClass().getSimpleName());
            sb.append("(").append(ObjectHelper.getIdentityHashCode((Object)policy)).append(")");
            if (i >= policyList.size() - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public String getLoad01() {
        double load1 = this.load.getLoad1();
        if (Double.isNaN(load1)) {
            return "";
        }
        return String.format("%.2f", load1);
    }

    public String getLoad05() {
        double load5 = this.load.getLoad5();
        if (Double.isNaN(load5)) {
            return "";
        }
        return String.format("%.2f", load5);
    }

    public String getLoad15() {
        double load15 = this.load.getLoad15();
        if (Double.isNaN(load15)) {
            return "";
        }
        return String.format("%.2f", load15);
    }

    public void onTimer() {
        this.load.update(this.getInflightExchanges());
    }

    public void start() throws Exception {
        if (!this.context.getStatus().isStarted()) {
            throw new IllegalArgumentException("CamelContext is not started");
        }
        this.context.getRouteController().startRoute(this.getRouteId());
    }

    public void stop() throws Exception {
        if (!this.context.getStatus().isStarted()) {
            throw new IllegalArgumentException("CamelContext is not started");
        }
        this.context.getRouteController().stopRoute(this.getRouteId());
    }

    public void stopAndFail() throws Exception {
        if (!this.context.getStatus().isStarted()) {
            throw new IllegalArgumentException("CamelContext is not started");
        }
        RejectedExecutionException cause = new RejectedExecutionException("Route " + this.getRouteId() + " is forced stopped and marked as failed");
        this.context.getRouteController().stopRoute(this.getRouteId(), (Throwable)cause);
    }

    public void stop(long timeout) throws Exception {
        if (!this.context.getStatus().isStarted()) {
            throw new IllegalArgumentException("CamelContext is not started");
        }
        this.context.getRouteController().stopRoute(this.getRouteId(), timeout, TimeUnit.SECONDS);
    }

    public boolean stop(Long timeout, Boolean abortAfterTimeout) throws Exception {
        if (!this.context.getStatus().isStarted()) {
            throw new IllegalArgumentException("CamelContext is not started");
        }
        return this.context.getRouteController().stopRoute(this.getRouteId(), timeout.longValue(), TimeUnit.SECONDS, abortAfterTimeout.booleanValue());
    }

    public void shutdown() throws Exception {
        if (!this.context.getStatus().isStarted()) {
            throw new IllegalArgumentException("CamelContext is not started");
        }
        String routeId = this.getRouteId();
        this.context.getRouteController().stopRoute(routeId);
        this.context.removeRoute(routeId);
    }

    public void shutdown(long timeout) throws Exception {
        if (!this.context.getStatus().isStarted()) {
            throw new IllegalArgumentException("CamelContext is not started");
        }
        String routeId = this.getRouteId();
        this.context.getRouteController().stopRoute(routeId, timeout, TimeUnit.SECONDS);
        this.context.removeRoute(routeId);
    }

    public boolean remove() throws Exception {
        if (!this.context.getStatus().isStarted()) {
            throw new IllegalArgumentException("CamelContext is not started");
        }
        return this.context.removeRoute(this.getRouteId());
    }

    public void restart() throws Exception {
        this.restart(1L);
    }

    public void restart(long delay) throws Exception {
        this.stop();
        if (delay > 0L) {
            try {
                LOG.debug("Sleeping {} seconds before starting route: {}", (Object)delay, (Object)this.getRouteId());
                Thread.sleep(delay * 1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.start();
    }

    public String dumpRouteAsXml() throws Exception {
        return this.dumpRouteAsXml(false, false);
    }

    public String dumpRouteAsXml(boolean resolvePlaceholders) throws Exception {
        return this.dumpRouteAsXml(resolvePlaceholders, false);
    }

    public String dumpRouteAsXml(boolean resolvePlaceholders, boolean resolveDelegateEndpoints) throws Exception {
        String id = this.route.getId();
        RouteDefinition def = ((Model)this.context.getExtension(Model.class)).getRouteDefinition(id);
        if (def != null) {
            ExtendedCamelContext ecc = (ExtendedCamelContext)this.context.adapt(ExtendedCamelContext.class);
            return ecc.getModelToXMLDumper().dumpModelAsXml(this.context, (NamedNode)def, resolvePlaceholders, resolveDelegateEndpoints);
        }
        return null;
    }

    public String dumpRouteStatsAsXml(boolean fullStats, boolean includeProcessors) throws Exception {
        long routeSelfTime;
        StringBuilder sb = new StringBuilder();
        long processorAccumulatedTime = 0L;
        if (includeProcessors) {
            sb.append("  <processorStats>\n");
            MBeanServer server = this.getContext().getManagementStrategy().getManagementAgent().getMBeanServer();
            if (server != null) {
                String prefix = this.getContext().getManagementStrategy().getManagementAgent().getIncludeHostName() != false ? "*/" : "";
                ObjectName query = ObjectName.getInstance(this.jmxDomain + ":context=" + prefix + this.getContext().getManagementName() + ",type=processors,*");
                Set<ObjectName> names = server.queryNames(query, null);
                ArrayList<ManagedProcessorMBean> mps = new ArrayList<ManagedProcessorMBean>();
                for (ObjectName on : names) {
                    ManagedProcessorMBean processor = (ManagedProcessorMBean)this.context.getManagementStrategy().getManagementAgent().newProxyClient(on, ManagedProcessorMBean.class);
                    if (!this.getRouteId().equals(processor.getRouteId())) continue;
                    mps.add(processor);
                }
                mps.sort(new OrderProcessorMBeans());
                HashMap<String, Long> accumulatedTimes = new HashMap<String, Long>();
                Collections.reverse(mps);
                for (ManagedProcessorMBean processor : mps) {
                    accumulatedTimes.put(processor.getProcessorId(), processorAccumulatedTime += processor.getTotalProcessingTime());
                }
                Collections.reverse(mps);
                for (ManagedProcessorMBean processor : mps) {
                    int line = processor.getSourceLineNumber() != null ? processor.getSourceLineNumber() : -1;
                    sb.append("    <processorStat").append(String.format(" id=\"%s\" index=\"%s\" state=\"%s\" sourceLineNumber=\"%s\"", processor.getProcessorId(), processor.getIndex(), processor.getState(), line));
                    Long accTime = (Long)accumulatedTimes.get(processor.getProcessorId());
                    if (accTime != null) {
                        sb.append(" accumulatedProcessingTime=\"").append(accTime).append("\"");
                    }
                    sb.append(" ").append(processor.dumpStatsAsXml(fullStats).substring(7)).append("\n");
                }
            }
            sb.append("  </processorStats>\n");
        }
        if ((routeSelfTime = this.getTotalProcessingTime() - processorAccumulatedTime) < 0L) {
            routeSelfTime = 0L;
        }
        StringBuilder answer = new StringBuilder();
        answer.append("<routeStat").append(String.format(" id=\"%s\"", this.route.getId())).append(String.format(" state=\"%s\"", this.getState()));
        if (this.sourceLocation != null) {
            answer.append(String.format(" sourceLocation=\"%s\"", this.getSourceLocation()));
        }
        String stat = this.dumpStatsAsXml(fullStats);
        answer.append(" exchangesInflight=\"").append(this.getInflightExchanges()).append("\"");
        answer.append(" selfProcessingTime=\"").append(routeSelfTime).append("\"");
        InflightRepository.InflightExchange oldest = this.getOldestInflightEntry();
        if (oldest == null) {
            answer.append(" oldestInflightExchangeId=\"\"");
            answer.append(" oldestInflightDuration=\"\"");
        } else {
            answer.append(" oldestInflightExchangeId=\"").append(oldest.getExchange().getExchangeId()).append("\"");
            answer.append(" oldestInflightDuration=\"").append(oldest.getDuration()).append("\"");
        }
        answer.append(" ").append(stat, 7, stat.length() - 2).append(">\n");
        if (includeProcessors) {
            answer.append((CharSequence)sb);
        }
        answer.append("</routeStat>");
        return answer.toString();
    }

    public String dumpStepStatsAsXml(boolean fullStats) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("  <stepStats>\n");
        MBeanServer server = this.getContext().getManagementStrategy().getManagementAgent().getMBeanServer();
        if (server != null) {
            String prefix = this.getContext().getManagementStrategy().getManagementAgent().getIncludeHostName() != false ? "*/" : "";
            ObjectName query = ObjectName.getInstance(this.jmxDomain + ":context=" + prefix + this.getContext().getManagementName() + ",type=steps,*");
            Set<ObjectName> names = server.queryNames(query, null);
            ArrayList<Object> mps = new ArrayList<Object>();
            for (ObjectName objectName : names) {
                ManagedStepMBean step = (ManagedStepMBean)this.context.getManagementStrategy().getManagementAgent().newProxyClient(objectName, ManagedStepMBean.class);
                if (!this.getRouteId().equals(step.getRouteId())) continue;
                mps.add(step);
            }
            mps.sort(new OrderProcessorMBeans());
            for (ManagedStepMBean managedStepMBean : mps) {
                int line = managedStepMBean.getSourceLineNumber() != null ? managedStepMBean.getSourceLineNumber() : -1;
                sb.append("    <stepStat").append(String.format(" id=\"%s\" index=\"%s\" state=\"%s\" sourceLineNumber=\"%s\"", managedStepMBean.getProcessorId(), managedStepMBean.getIndex(), managedStepMBean.getState(), line));
                sb.append(" ").append(managedStepMBean.dumpStatsAsXml(fullStats).substring(7)).append("\n");
            }
        }
        sb.append("  </stepStats>\n");
        StringBuilder answer = new StringBuilder();
        answer.append("<routeStat").append(String.format(" id=\"%s\"", this.route.getId())).append(String.format(" state=\"%s\"", this.getState()));
        if (this.sourceLocation != null) {
            answer.append(String.format(" sourceLocation=\"%s\"", this.getSourceLocation()));
        }
        String stat = this.dumpStatsAsXml(fullStats);
        answer.append(" exchangesInflight=\"").append(this.getInflightExchanges()).append("\"");
        InflightRepository.InflightExchange oldest = this.getOldestInflightEntry();
        if (oldest == null) {
            answer.append(" oldestInflightExchangeId=\"\"");
            answer.append(" oldestInflightDuration=\"\"");
        } else {
            answer.append(" oldestInflightExchangeId=\"").append(oldest.getExchange().getExchangeId()).append("\"");
            answer.append(" oldestInflightDuration=\"").append(oldest.getDuration()).append("\"");
        }
        answer.append(" ").append(stat, 7, stat.length() - 2).append(">\n");
        answer.append((CharSequence)sb);
        answer.append("</routeStat>");
        return answer.toString();
    }

    public String dumpRouteSourceLocationsAsXml() throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("<routeLocations>");
        MBeanServer server = this.getContext().getManagementStrategy().getManagementAgent().getMBeanServer();
        if (server != null) {
            String prefix = this.getContext().getManagementStrategy().getManagementAgent().getIncludeHostName() != false ? "*/" : "";
            ArrayList<ManagedProcessorMBean> processors = new ArrayList<ManagedProcessorMBean>();
            ObjectName query = ObjectName.getInstance(this.jmxDomain + ":context=" + prefix + this.getContext().getManagementName() + ",type=processors,*");
            Set<ObjectName> names = server.queryNames(query, null);
            for (ObjectName on : names) {
                ManagedProcessorMBean processor = (ManagedProcessorMBean)this.context.getManagementStrategy().getManagementAgent().newProxyClient(on, ManagedProcessorMBean.class);
                if (!this.getRouteId().equals(processor.getRouteId())) continue;
                processors.add(processor);
            }
            processors.sort(new OrderProcessorMBeans());
            RouteDefinition rd = ((ModelCamelContext)this.context.adapt(ModelCamelContext.class)).getRouteDefinition(this.route.getRouteId());
            if (rd != null) {
                String id = rd.getRouteId();
                int line = rd.getInput().getLineNumber();
                String location = this.getSourceLocation() != null ? this.getSourceLocation() : "";
                sb.append("\n    <routeLocation").append(String.format(" routeId=\"%s\" id=\"%s\" index=\"%s\" sourceLocation=\"%s\" sourceLineNumber=\"%s\"/>", this.route.getRouteId(), id, 0, location, line));
            }
            for (ManagedProcessorMBean processor : processors) {
                if (!this.route.getRouteId().equals(processor.getRouteId())) continue;
                int line = processor.getSourceLineNumber() != null ? processor.getSourceLineNumber() : -1;
                String location = processor.getSourceLocation() != null ? processor.getSourceLocation() : "";
                sb.append("\n    <routeLocation").append(String.format(" routeId=\"%s\" id=\"%s\" index=\"%s\" sourceLocation=\"%s\" sourceLineNumber=\"%s\"/>", this.route.getRouteId(), processor.getProcessorId(), processor.getIndex(), location, line));
            }
        }
        sb.append("\n</routeLocations>");
        return sb.toString();
    }

    public void reset(boolean includeProcessors) throws Exception {
        MBeanServer server;
        this.reset();
        if (includeProcessors && (server = this.getContext().getManagementStrategy().getManagementAgent().getMBeanServer()) != null) {
            String prefix = this.getContext().getManagementStrategy().getManagementAgent().getIncludeHostName() != false ? "*/" : "";
            ObjectName query = ObjectName.getInstance(this.jmxDomain + ":context=" + prefix + this.getContext().getManagementName() + ",type=processors,*");
            QueryExp queryExp = Query.match(new AttributeValueExp("RouteId"), new StringValueExp(this.getRouteId()));
            Set<ObjectName> names = server.queryNames(query, queryExp);
            for (ObjectName name : names) {
                server.invoke(name, "reset", null, null);
            }
        }
    }

    public boolean equals(Object o) {
        return this == o || o != null && this.getClass() == o.getClass() && this.route.equals(((ManagedRoute)o).route);
    }

    public int hashCode() {
        return this.route.hashCode();
    }

    private InflightRepository.InflightExchange getOldestInflightEntry() {
        return this.getContext().getInflightRepository().oldest(this.getRouteId());
    }

    public Long getOldestInflightDuration() {
        InflightRepository.InflightExchange oldest = this.getOldestInflightEntry();
        if (oldest == null) {
            return null;
        }
        return oldest.getDuration();
    }

    public String getOldestInflightExchangeId() {
        InflightRepository.InflightExchange oldest = this.getOldestInflightEntry();
        if (oldest == null) {
            return null;
        }
        return oldest.getExchange().getExchangeId();
    }

    public Boolean getHasRouteController() {
        return this.route.getRouteController() != null;
    }

    public RouteError getLastError() {
        final org.apache.camel.spi.RouteError error = this.route.getLastError();
        if (error == null) {
            return null;
        }
        return new RouteError(){

            public RouteError.Phase getPhase() {
                if (error.getPhase() != null) {
                    switch (error.getPhase()) {
                        case START: {
                            return RouteError.Phase.START;
                        }
                        case STOP: {
                            return RouteError.Phase.STOP;
                        }
                        case SUSPEND: {
                            return RouteError.Phase.SUSPEND;
                        }
                        case RESUME: {
                            return RouteError.Phase.RESUME;
                        }
                        case SHUTDOWN: {
                            return RouteError.Phase.SHUTDOWN;
                        }
                        case REMOVE: {
                            return RouteError.Phase.REMOVE;
                        }
                    }
                    throw new IllegalStateException();
                }
                return null;
            }

            public Throwable getException() {
                return error.getException();
            }
        };
    }

    public Collection<String> processorIds() throws Exception {
        ArrayList<String> ids = new ArrayList<String>();
        MBeanServer server = this.getContext().getManagementStrategy().getManagementAgent().getMBeanServer();
        if (server != null) {
            String prefix = this.getContext().getManagementStrategy().getManagementAgent().getIncludeHostName() != false ? "*/" : "";
            ObjectName query = ObjectName.getInstance(this.jmxDomain + ":context=" + prefix + this.getContext().getManagementName() + ",type=processors,*");
            Set<ObjectName> names = server.queryNames(query, null);
            for (ObjectName on : names) {
                ManagedProcessorMBean processor = (ManagedProcessorMBean)this.context.getManagementStrategy().getManagementAgent().newProxyClient(on, ManagedProcessorMBean.class);
                if (!this.getRouteId().equals(processor.getRouteId())) continue;
                ids.add(processor.getProcessorId());
            }
        }
        return ids;
    }

    private Integer getInflightExchanges() {
        return (int)super.getExchangesInflight();
    }

    private static final class OrderProcessorMBeans
    implements Comparator<ManagedProcessorMBean>,
    Serializable {
        private OrderProcessorMBeans() {
        }

        @Override
        public int compare(ManagedProcessorMBean o1, ManagedProcessorMBean o2) {
            return o1.getIndex().compareTo(o2.getIndex());
        }
    }
}

