/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Expression;
import org.apache.camel.MessageHistory;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.Predicate;
import org.apache.camel.Route;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.ManagedBacklogDebuggerMBean;
import org.apache.camel.impl.debugger.BacklogDebugger;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.support.LoggerHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.URISupport;

@ManagedResource(description="Managed BacklogDebugger")
public class ManagedBacklogDebugger
implements ManagedBacklogDebuggerMBean {
    private final CamelContext camelContext;
    private final BacklogDebugger backlogDebugger;

    public ManagedBacklogDebugger(CamelContext camelContext, BacklogDebugger backlogDebugger) {
        this.camelContext = camelContext;
        this.backlogDebugger = backlogDebugger;
    }

    public void init(ManagementStrategy strategy) {
    }

    public CamelContext getContext() {
        return this.camelContext;
    }

    public BacklogDebugger getBacklogDebugger() {
        return this.backlogDebugger;
    }

    public String getCamelId() {
        return this.camelContext.getName();
    }

    public String getCamelManagementName() {
        return this.camelContext.getManagementName();
    }

    public String getLoggingLevel() {
        return this.backlogDebugger.getLoggingLevel();
    }

    public void setLoggingLevel(String level) {
        this.backlogDebugger.setLoggingLevel(level);
    }

    public boolean isEnabled() {
        return this.backlogDebugger.isEnabled();
    }

    public void enableDebugger() {
        this.backlogDebugger.enableDebugger();
    }

    public void disableDebugger() {
        this.backlogDebugger.disableDebugger();
    }

    public void addBreakpoint(String nodeId) {
        this.backlogDebugger.addBreakpoint(nodeId);
    }

    public void addConditionalBreakpoint(String nodeId, String language, String predicate) {
        this.backlogDebugger.addConditionalBreakpoint(nodeId, language, predicate);
    }

    public void removeBreakpoint(String nodeId) {
        this.backlogDebugger.removeBreakpoint(nodeId);
    }

    public void removeAllBreakpoints() {
        this.backlogDebugger.removeAllBreakpoints();
    }

    public Set<String> getBreakpoints() {
        return this.breakpoints();
    }

    public Set<String> breakpoints() {
        return this.backlogDebugger.getBreakpoints();
    }

    public void resumeBreakpoint(String nodeId) {
        this.backlogDebugger.resumeBreakpoint(nodeId);
    }

    public void setMessageBodyOnBreakpoint(String nodeId, Object body) {
        this.backlogDebugger.setMessageBodyOnBreakpoint(nodeId, body);
    }

    public void setMessageBodyOnBreakpoint(String nodeId, Object body, String type) {
        try {
            Class classType = this.camelContext.getClassResolver().resolveMandatoryClass(type);
            this.backlogDebugger.setMessageBodyOnBreakpoint(nodeId, body, classType);
        }
        catch (ClassNotFoundException e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
    }

    public void removeMessageBodyOnBreakpoint(String nodeId) {
        this.backlogDebugger.removeMessageBodyOnBreakpoint(nodeId);
    }

    public void setMessageHeaderOnBreakpoint(String nodeId, String headerName, Object value) {
        try {
            this.backlogDebugger.setMessageHeaderOnBreakpoint(nodeId, headerName, value);
        }
        catch (NoTypeConversionAvailableException e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
    }

    public void setMessageHeaderOnBreakpoint(String nodeId, String headerName, Object value, String type) {
        try {
            Class classType = this.camelContext.getClassResolver().resolveMandatoryClass(type);
            this.backlogDebugger.setMessageHeaderOnBreakpoint(nodeId, headerName, value, classType);
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
    }

    public void removeMessageHeaderOnBreakpoint(String nodeId, String headerName) {
        this.backlogDebugger.removeMessageHeaderOnBreakpoint(nodeId, headerName);
    }

    public void resumeAll() {
        this.backlogDebugger.resumeAll();
    }

    public void stepBreakpoint(String nodeId) {
        this.backlogDebugger.stepBreakpoint(nodeId);
    }

    public boolean isSingleStepMode() {
        return this.backlogDebugger.isSingleStepMode();
    }

    public void step() {
        this.backlogDebugger.step();
    }

    public Set<String> getSuspendedBreakpointNodeIds() {
        return this.suspendedBreakpointNodeIds();
    }

    public Set<String> suspendedBreakpointNodeIds() {
        return this.backlogDebugger.getSuspendedBreakpointNodeIds();
    }

    public void disableBreakpoint(String nodeId) {
        this.backlogDebugger.disableBreakpoint(nodeId);
    }

    public void enableBreakpoint(String nodeId) {
        this.backlogDebugger.enableBreakpoint(nodeId);
    }

    public int getBodyMaxChars() {
        return this.backlogDebugger.getBodyMaxChars();
    }

    public void setBodyMaxChars(int bodyMaxChars) {
        this.backlogDebugger.setBodyMaxChars(bodyMaxChars);
    }

    public boolean isBodyIncludeStreams() {
        return this.backlogDebugger.isBodyIncludeStreams();
    }

    public void setBodyIncludeStreams(boolean bodyIncludeStreams) {
        this.backlogDebugger.setBodyIncludeStreams(bodyIncludeStreams);
    }

    public boolean isBodyIncludeFiles() {
        return this.backlogDebugger.isBodyIncludeFiles();
    }

    public void setBodyIncludeFiles(boolean bodyIncludeFiles) {
        this.backlogDebugger.setBodyIncludeFiles(bodyIncludeFiles);
    }

    public String dumpTracedMessagesAsXml(String nodeId) {
        return this.dumpTracedMessagesAsXml(nodeId, false);
    }

    public String dumpTracedMessagesAsXml(String nodeId, boolean includeExchangeProperties) {
        Object messageAsXml = this.backlogDebugger.dumpTracedMessagesAsXml(nodeId);
        if (messageAsXml != null && includeExchangeProperties) {
            String closingTag = "</backlogTracerEventMessage>";
            String exchangePropertiesAsXml = this.dumpExchangePropertiesAsXml(nodeId);
            messageAsXml = ((String)messageAsXml).replace(closingTag, exchangePropertiesAsXml) + "\n" + closingTag;
        }
        return messageAsXml;
    }

    public long getDebugCounter() {
        return this.backlogDebugger.getDebugCounter();
    }

    public void resetDebugCounter() {
        this.backlogDebugger.resetDebugCounter();
    }

    public String validateConditionalBreakpoint(String language, String predicate) {
        Language lan = null;
        try {
            lan = this.camelContext.resolveLanguage(language);
            lan.createPredicate(predicate);
            return null;
        }
        catch (Exception e) {
            if (lan == null) {
                return e.getMessage();
            }
            return "Invalid syntax " + predicate + " due: " + e.getMessage();
        }
    }

    public long getFallbackTimeout() {
        return this.backlogDebugger.getFallbackTimeout();
    }

    public void setFallbackTimeout(long fallbackTimeout) {
        this.backlogDebugger.setFallbackTimeout(fallbackTimeout);
    }

    public String evaluateExpressionAtBreakpoint(String nodeId, String language, String expression) {
        return this.evaluateExpressionAtBreakpoint(nodeId, language, expression, "java.lang.String").toString();
    }

    public void setExchangePropertyOnBreakpoint(String nodeId, String exchangePropertyName, Object value) {
        Exchange suspendedExchange = this.backlogDebugger.getSuspendedExchange(nodeId);
        if (suspendedExchange != null) {
            suspendedExchange.setProperty(exchangePropertyName, value);
        }
    }

    public void removeExchangePropertyOnBreakpoint(String nodeId, String exchangePropertyName) {
        Exchange suspendedExchange = this.backlogDebugger.getSuspendedExchange(nodeId);
        if (suspendedExchange != null) {
            suspendedExchange.removeProperty(exchangePropertyName);
        }
    }

    public void setExchangePropertyOnBreakpoint(String nodeId, String exchangePropertyName, Object value, String type) {
        try {
            Class classType = this.camelContext.getClassResolver().resolveMandatoryClass(type);
            if (type != null) {
                Exchange suspendedExchange = this.backlogDebugger.getSuspendedExchange(nodeId);
                if (suspendedExchange != null) {
                    value = suspendedExchange.getContext().getTypeConverter().mandatoryConvertTo(classType, suspendedExchange, value);
                    suspendedExchange.setProperty(exchangePropertyName, value);
                }
            } else {
                this.setExchangePropertyOnBreakpoint(nodeId, exchangePropertyName, value);
            }
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
    }

    public Object evaluateExpressionAtBreakpoint(String nodeId, String language, String expression, String resultType) {
        try {
            Language lan = this.camelContext.resolveLanguage(language);
            Exchange suspendedExchange = this.backlogDebugger.getSuspendedExchange(nodeId);
            if (suspendedExchange != null) {
                String resultStr;
                Object result;
                Class resultClass = this.camelContext.getClassResolver().resolveMandatoryClass(resultType);
                if (!Boolean.class.isAssignableFrom(resultClass)) {
                    Expression expr = lan.createExpression(expression);
                    expr.init(this.camelContext);
                    result = expr.evaluate(suspendedExchange, resultClass);
                } else {
                    Predicate pred = lan.createPredicate(expression);
                    pred.init(this.camelContext);
                    result = pred.matches(suspendedExchange);
                }
                if (!ManagedBacklogDebugger.isSerializable(result) && (resultStr = (String)suspendedExchange.getContext().getTypeConverter().tryConvertTo(String.class, result)) != null) {
                    result = resultStr;
                }
                return result;
            }
        }
        catch (Exception e) {
            return e.getMessage();
        }
        return null;
    }

    public String messageHistoryOnBreakpointAsXml(String nodeId) {
        List list;
        StringBuffer messageHistoryBuffer = new StringBuffer();
        messageHistoryBuffer.append("<messageHistory>\n");
        Exchange suspendedExchange = this.backlogDebugger.getSuspendedExchange(nodeId);
        if (suspendedExchange != null && (list = (List)suspendedExchange.getProperty(ExchangePropertyKey.MESSAGE_HISTORY, List.class)) != null) {
            String routeId = suspendedExchange.getFromRouteId();
            Route route = suspendedExchange.getContext().getRoute(routeId);
            String loc = route != null ? route.getSourceLocation() : "";
            String id = routeId;
            Object label = "";
            if (suspendedExchange.getFromEndpoint() != null) {
                label = "from[" + URISupport.sanitizeUri((String)StringHelper.limitLength((String)suspendedExchange.getFromEndpoint().getEndpointUri(), (int)100)) + "]";
            }
            long elapsed = new StopWatch(suspendedExchange.getCreated()).taken();
            messageHistoryBuffer.append("    <messageHistoryEntry").append(" location=\"").append(StringHelper.xmlEncode((String)loc)).append("\"").append(" routeId=\"").append(StringHelper.xmlEncode((String)routeId)).append("\"").append(" processorId=\"").append(StringHelper.xmlEncode((String)id)).append("\"").append(" processor=\"").append(StringHelper.xmlEncode((String)label)).append("\"").append(" elapsed=\"").append(elapsed).append("\"").append("/>\n");
            for (MessageHistory history : list) {
                loc = LoggerHelper.getLineNumberLoggerName((Object)history.getNode());
                if (loc == null) {
                    loc = "";
                }
                routeId = history.getRouteId() != null ? history.getRouteId() : "";
                id = history.getNode().getId();
                label = URISupport.sanitizeUri((String)StringHelper.limitLength((String)history.getNode().getLabel(), (int)100));
                elapsed = history.getElapsed();
                messageHistoryBuffer.append("    <messageHistoryEntry").append(" location=\"").append(StringHelper.xmlEncode((String)loc)).append("\"").append(" routeId=\"").append(StringHelper.xmlEncode((String)routeId)).append("\"").append(" processorId=\"").append(StringHelper.xmlEncode((String)id)).append("\"").append(" processor=\"").append(StringHelper.xmlEncode((String)label)).append("\"").append(" elapsed=\"").append(elapsed).append("\"").append("/>\n");
            }
        }
        messageHistoryBuffer.append("</messageHistory>\n");
        return messageHistoryBuffer.toString();
    }

    private String dumpExchangePropertiesAsXml(String id) {
        StringBuilder sb = new StringBuilder();
        sb.append("  <exchangeProperties>\n");
        Exchange suspendedExchange = this.backlogDebugger.getSuspendedExchange(id);
        if (suspendedExchange != null) {
            Map properties = suspendedExchange.getAllProperties();
            properties.forEach((propertyName, propertyValue) -> {
                String type = ObjectHelper.classCanonicalName((Object)propertyValue);
                sb.append("    <exchangeProperty name=\"").append((String)propertyName).append("\"");
                if (type != null) {
                    sb.append(" type=\"").append(type).append("\"");
                }
                sb.append(">");
                if (propertyValue != null) {
                    try {
                        String xml = (String)suspendedExchange.getContext().getTypeConverter().tryConvertTo(String.class, suspendedExchange, propertyValue);
                        if (xml != null) {
                            sb.append(StringHelper.xmlEncode((String)xml));
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                sb.append("</exchangeProperty>\n");
            });
        }
        sb.append("  </exchangeProperties>");
        return sb.toString();
    }

    private static boolean isSerializable(Object obj) {
        boolean bl;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        ObjectOutputStream out = new ObjectOutputStream(baos);
        try {
            out.writeObject(obj);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return false;
            }
        }
        out.close();
        return bl;
    }
}

