/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.api.management.mbean;

import javax.management.openmbean.TabularData;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.api.management.mbean.ManagedPerformanceCounterMBean;
import org.apache.camel.api.management.mbean.RouteError;
import org.apache.camel.meta.Experimental;

public interface ManagedRouteMBean
extends ManagedPerformanceCounterMBean {
    @ManagedAttribute(description="Route ID")
    public String getRouteId();

    @ManagedAttribute(description="Route Group")
    public String getRouteGroup();

    @ManagedAttribute(description="Route Properties")
    public TabularData getRouteProperties();

    @ManagedAttribute(description="Route Description")
    public String getDescription();

    @ManagedAttribute(description="Route Endpoint URI", mask=true)
    public String getEndpointUri();

    @ManagedAttribute(description="Route State")
    public String getState();

    @ManagedAttribute(description="Route Uptime [human readable text]")
    public String getUptime();

    @ManagedAttribute(description="Route Uptime [milliseconds]")
    public long getUptimeMillis();

    @ManagedAttribute(description="Camel ID")
    public String getCamelId();

    @ManagedAttribute(description="Camel ManagementName")
    public String getCamelManagementName();

    @ManagedAttribute(description="Tracing")
    public Boolean getTracing();

    @ManagedAttribute(description="Tracing")
    public void setTracing(Boolean var1);

    @ManagedAttribute(description="Message History")
    public Boolean getMessageHistory();

    @ManagedAttribute(description="Route Policy List")
    public String getRoutePolicyList();

    @ManagedAttribute(description="Average load over the last minute")
    public String getLoad01();

    @ManagedAttribute(description="Average load over the last five minutes")
    public String getLoad05();

    @ManagedAttribute(description="Average load over the last fifteen minutes")
    public String getLoad15();

    @ManagedOperation(description="Start route")
    public void start() throws Exception;

    @ManagedOperation(description="Stop route")
    public void stop() throws Exception;

    @ManagedOperation(description="Stop route (using timeout in seconds)")
    public void stop(long var1) throws Exception;

    @ManagedOperation(description="Stop route, abort stop after timeout (in seconds)")
    public boolean stop(Long var1, Boolean var2) throws Exception;

    @ManagedOperation(description="Shutdown route")
    @Deprecated
    public void shutdown() throws Exception;

    @ManagedOperation(description="Shutdown route (using timeout in seconds)")
    @Deprecated
    public void shutdown(long var1) throws Exception;

    @ManagedOperation(description="Remove route (must be stopped)")
    public boolean remove() throws Exception;

    @ManagedOperation(description="Restarts route (1 second delay before starting)")
    public void restart() throws Exception;

    @ManagedOperation(description="Restarts route (using delay in seconds before starting)")
    public void restart(long var1) throws Exception;

    @ManagedOperation(description="Dumps the route as XML")
    public String dumpRouteAsXml() throws Exception;

    @ManagedOperation(description="Dumps the route as XML")
    public String dumpRouteAsXml(boolean var1) throws Exception;

    @ManagedOperation(description="Updates the route from XML")
    public void updateRouteFromXml(String var1) throws Exception;

    @ManagedOperation(description="Dumps the routes stats as XML")
    public String dumpRouteStatsAsXml(boolean var1, boolean var2) throws Exception;

    @ManagedOperation(description="Dumps the routes and steps stats as XML")
    public String dumpStepStatsAsXml(boolean var1) throws Exception;

    @ManagedOperation(description="Reset counters")
    public void reset(boolean var1) throws Exception;

    @ManagedOperation(description="Returns the JSON representation of all the static and dynamic endpoints defined in this route")
    public String createRouteStaticEndpointJson();

    @ManagedOperation(description="Returns the JSON representation of all the static endpoints (and possible dynamic) defined in this route")
    public String createRouteStaticEndpointJson(boolean var1);

    @ManagedAttribute(description="Oldest inflight exchange duration")
    public Long getOldestInflightDuration();

    @ManagedAttribute(description="Oldest inflight exchange id")
    public String getOldestInflightExchangeId();

    @Experimental
    @ManagedAttribute(description="Route controller")
    public Boolean getHasRouteController();

    @Experimental
    @ManagedAttribute(description="Last error")
    public RouteError getLastError();
}

