/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.builder.ThreadPoolProfileBuilder;
import org.apache.camel.main.FaultToleranceConfigurationProperties;
import org.apache.camel.main.HystrixConfigurationProperties;
import org.apache.camel.main.MainConfigurationProperties;
import org.apache.camel.main.MainHelper;
import org.apache.camel.main.Resilience4jConfigurationProperties;
import org.apache.camel.main.ThreadPoolConfigurationProperties;
import org.apache.camel.main.ThreadPoolProfileConfigurationProperties;
import org.apache.camel.model.FaultToleranceConfigurationDefinition;
import org.apache.camel.model.HystrixConfigurationDefinition;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.Resilience4jConfigurationDefinition;
import org.apache.camel.spi.ThreadPoolProfile;
import org.apache.camel.util.PropertiesHelper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MainSupportModelConfigurer {
    private static final Logger LOG = LoggerFactory.getLogger(MainSupportModelConfigurer.class);

    private MainSupportModelConfigurer() {
    }

    static void configureModelCamelContext(CamelContext camelContext, MainConfigurationProperties mainConfigurationProperties, Map<String, String> autoConfiguredProperties, Map<String, Object> hystrixProperties, Map<String, Object> resilience4jProperties, Map<String, Object> faultToleranceProperties) throws Exception {
        ModelCamelContext model = (ModelCamelContext)camelContext.adapt(ModelCamelContext.class);
        if (!hystrixProperties.isEmpty()) {
            HystrixConfigurationProperties hystrix = mainConfigurationProperties.hystrix();
            LOG.debug("Auto-configuring Hystrix Circuit Breaker EIP from loaded properties: {}", (Object)hystrixProperties.size());
            MainHelper.setPropertiesOnTarget(camelContext, hystrix, hystrixProperties, "camel.hystrix.", mainConfigurationProperties.isAutoConfigurationFailFast(), true, autoConfiguredProperties);
            HystrixConfigurationDefinition hystrixModel = model.getHystrixConfiguration(null);
            if (hystrixModel == null) {
                hystrixModel = new HystrixConfigurationDefinition();
                model.setHystrixConfiguration(hystrixModel);
            }
            if (hystrix != null) {
                MainHelper.setPropertiesOnTarget(camelContext, hystrixModel, hystrix);
            }
        }
        if (!resilience4jProperties.isEmpty()) {
            Resilience4jConfigurationProperties resilience4j = mainConfigurationProperties.resilience4j();
            LOG.debug("Auto-configuring Resilience4j Circuit Breaker EIP from loaded properties: {}", (Object)resilience4jProperties.size());
            MainHelper.setPropertiesOnTarget(camelContext, resilience4j, resilience4jProperties, "camel.resilience4j.", mainConfigurationProperties.isAutoConfigurationFailFast(), true, autoConfiguredProperties);
            Resilience4jConfigurationDefinition resilience4jModel = model.getResilience4jConfiguration(null);
            if (resilience4jModel == null) {
                resilience4jModel = new Resilience4jConfigurationDefinition();
                model.setResilience4jConfiguration(resilience4jModel);
            }
            MainHelper.setPropertiesOnTarget(camelContext, resilience4jModel, resilience4j);
        }
        if (!faultToleranceProperties.isEmpty()) {
            FaultToleranceConfigurationProperties faultTolerance = mainConfigurationProperties.faultTolerance();
            LOG.debug("Auto-configuring MicroProfile Fault Tolerance Circuit Breaker EIP from loaded properties: {}", (Object)faultToleranceProperties.size());
            MainHelper.setPropertiesOnTarget(camelContext, faultTolerance, faultToleranceProperties, "camel.faulttolerance.", mainConfigurationProperties.isAutoConfigurationFailFast(), true, autoConfiguredProperties);
            FaultToleranceConfigurationDefinition faultToleranceModel = model.getFaultToleranceConfiguration(null);
            if (faultToleranceModel == null) {
                faultToleranceModel = new FaultToleranceConfigurationDefinition();
                model.setFaultToleranceConfiguration(faultToleranceModel);
            }
            MainHelper.setPropertiesOnTarget(camelContext, faultToleranceModel, faultTolerance);
        }
    }

    static void setThreadPoolProperties(CamelContext camelContext, MainConfigurationProperties mainConfigurationProperties, Map<String, Object> threadPoolProperties, boolean failIfNotSet, Map<String, String> autoConfiguredProperties) throws Exception {
        ThreadPoolConfigurationProperties tp = mainConfigurationProperties.threadPool();
        Map hcConfig = PropertiesHelper.extractProperties(threadPoolProperties, (String)"config", (boolean)false);
        HashMap<String, ThreadPoolProfileConfigurationProperties> tpConfigs = new HashMap<String, ThreadPoolProfileConfigurationProperties>();
        for (Map.Entry entry : hcConfig.entrySet()) {
            ThreadPoolProfileConfigurationProperties tcp;
            String id = StringHelper.between((String)((String)entry.getKey()), (String)"[", (String)"]");
            if (id == null || (tcp = (ThreadPoolProfileConfigurationProperties)tpConfigs.get(id)) != null) continue;
            tcp = new ThreadPoolProfileConfigurationProperties();
            tcp.setId(id);
            tpConfigs.put(id, tcp);
        }
        if (tp.getConfig() != null) {
            tp.getConfig().putAll(tpConfigs);
        } else {
            tp.setConfig(tpConfigs);
        }
        MainHelper.setPropertiesOnTarget(camelContext, tp, threadPoolProperties, "camel.threadpool.", mainConfigurationProperties.isAutoConfigurationFailFast(), true, autoConfiguredProperties);
        ThreadPoolProfile dp = new ThreadPoolProfileBuilder("default").poolSize(tp.getPoolSize()).maxPoolSize(tp.getMaxPoolSize()).keepAliveTime(tp.getKeepAliveTime(), tp.getTimeUnit()).maxQueueSize(tp.getMaxQueueSize()).allowCoreThreadTimeOut(tp.getAllowCoreThreadTimeOut()).rejectedPolicy(tp.getRejectedPolicy()).build();
        for (ThreadPoolProfileConfigurationProperties config : tp.getConfig().values()) {
            ThreadPoolProfileBuilder builder = new ThreadPoolProfileBuilder(config.getId(), dp);
            ThreadPoolProfile tpp = builder.poolSize(config.getPoolSize()).maxPoolSize(config.getMaxPoolSize()).keepAliveTime(config.getKeepAliveTime(), config.getTimeUnit()).maxQueueSize(config.getMaxQueueSize()).allowCoreThreadTimeOut(config.getAllowCoreThreadTimeOut()).rejectedPolicy(config.getRejectedPolicy()).build();
            if (tpp.isEmpty()) continue;
            camelContext.getExecutorServiceManager().registerThreadPoolProfile(tpp);
        }
        if (!dp.isEmpty()) {
            dp.setDefaultProfile(Boolean.valueOf(true));
            camelContext.getExecutorServiceManager().setDefaultThreadPoolProfile(dp);
        }
    }
}

