/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.main.RoutesCollector;
import org.apache.camel.model.RoutesDefinition;
import org.apache.camel.model.rest.RestsDefinition;
import org.apache.camel.spi.PackageScanResourceResolver;
import org.apache.camel.util.AntPathMatcher;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRoutesCollector
implements RoutesCollector {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public List<RoutesBuilder> collectRoutesFromRegistry(CamelContext camelContext, String excludePattern, String includePattern) {
        ArrayList<RoutesBuilder> routes = new ArrayList<RoutesBuilder>();
        AntPathMatcher matcher = new AntPathMatcher();
        Set builders = camelContext.getRegistry().findByType(RoutesBuilder.class);
        for (RoutesBuilder routesBuilder : builders) {
            String[] parts;
            boolean match;
            boolean abs = Modifier.isAbstract(routesBuilder.getClass().getModifiers());
            if (abs) continue;
            String name = routesBuilder.getClass().getName();
            name = name.replace('.', '/');
            boolean bl = match = !"false".equals(includePattern);
            if (match && ObjectHelper.isNotEmpty((Object)excludePattern)) {
                for (String part : parts = excludePattern.split(",")) {
                    match = !matcher.match(part, name);
                    this.log.trace("Java RoutesBuilder: {} exclude filter: {} -> {}", new Object[]{name, part, match});
                    if (!match) break;
                }
            }
            if (match && ObjectHelper.isNotEmpty((Object)includePattern)) {
                for (String part : parts = includePattern.split(",")) {
                    match = matcher.match(part, name);
                    this.log.trace("Java RoutesBuilder: {} include filter: {} -> {}", new Object[]{name, part, match});
                    if (match) break;
                }
            }
            this.log.debug("Java RoutesBuilder: {} accepted by include/exclude filter: {}", (Object)name, (Object)match);
            if (!match) continue;
            routes.add(routesBuilder);
        }
        return routes;
    }

    @Override
    public List<RoutesDefinition> collectXmlRoutesFromDirectory(CamelContext camelContext, String directory) {
        String[] parts;
        ArrayList<RoutesDefinition> answer = new ArrayList<RoutesDefinition>();
        PackageScanResourceResolver resolver = ((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getPackageScanResourceResolver();
        StopWatch watch = new StopWatch();
        int count = 0;
        for (String part : parts = directory.split(",")) {
            this.log.debug("Loading additional Camel XML routes from: {}", (Object)part);
            try {
                Set set = resolver.findResources(part);
                for (InputStream is : set) {
                    this.log.debug("Found XML routes from location: {}", (Object)part);
                    ExtendedCamelContext ecc = (ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class);
                    RoutesDefinition routes = (RoutesDefinition)ecc.getXMLRoutesDefinitionLoader().loadRoutesDefinition((CamelContext)ecc, is);
                    answer.add(routes);
                    IOHelper.close((Closeable)is);
                    count += routes.getRoutes().size();
                }
            }
            catch (FileNotFoundException e) {
                this.log.debug("No XML routes found in {}. Skipping XML routes detection.", (Object)part);
            }
            catch (Exception e) {
                throw RuntimeCamelException.wrapRuntimeException((Throwable)e);
            }
            if (count > 0) {
                this.log.info("Loaded {} ({} millis) additional Camel XML routes from: {}", new Object[]{count, watch.taken(), directory});
                continue;
            }
            this.log.info("No additional Camel XML routes discovered from: {}", (Object)directory);
        }
        return answer;
    }

    @Override
    public List<RestsDefinition> collectXmlRestsFromDirectory(CamelContext camelContext, String directory) {
        String[] parts;
        ArrayList<RestsDefinition> answer = new ArrayList<RestsDefinition>();
        PackageScanResourceResolver resolver = ((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getPackageScanResourceResolver();
        StopWatch watch = new StopWatch();
        int count = 0;
        for (String part : parts = directory.split(",")) {
            this.log.debug("Loading additional Camel XML rests from: {}", (Object)part);
            try {
                Set set = resolver.findResources(part);
                for (InputStream is : set) {
                    this.log.debug("Found XML rest from location: {}", (Object)part);
                    ExtendedCamelContext ecc = (ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class);
                    RestsDefinition rests = (RestsDefinition)ecc.getXMLRoutesDefinitionLoader().loadRestsDefinition((CamelContext)ecc, is);
                    answer.add(rests);
                    IOHelper.close((Closeable)is);
                    count += rests.getRests().size();
                }
            }
            catch (FileNotFoundException e) {
                this.log.debug("No XML rests found in {}. Skipping XML rests detection.", (Object)part);
            }
            catch (Exception e) {
                throw RuntimeCamelException.wrapRuntimeException((Throwable)e);
            }
            if (count > 0) {
                this.log.info("Loaded {} ({} millis) additional Camel XML rests from: {}", new Object[]{count, watch.taken(), directory});
                continue;
            }
            this.log.info("No additional Camel XML rests discovered from: {}", (Object)directory);
        }
        return answer;
    }
}

