/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.CamelContext;
import org.apache.camel.main.MainLifecycleStrategy;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.support.EventNotifierSupport;
import org.apache.camel.util.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainDurationEventNotifier
extends EventNotifierSupport {
    private static final Logger LOG = LoggerFactory.getLogger(MainLifecycleStrategy.class);
    private final CamelContext camelContext;
    private final int maxMessages;
    private final long maxIdleSeconds;
    private final AtomicBoolean completed;
    private final CountDownLatch latch;
    private final boolean stopCamelContext;
    private volatile int doneMessages;
    private volatile StopWatch watch;
    private volatile ScheduledExecutorService idleExecutorService;

    public MainDurationEventNotifier(CamelContext camelContext, int maxMessages, long maxIdleSeconds, AtomicBoolean completed, CountDownLatch latch, boolean stopCamelContext) {
        this.camelContext = camelContext;
        this.maxMessages = maxMessages;
        this.maxIdleSeconds = maxIdleSeconds;
        this.completed = completed;
        this.latch = latch;
        this.stopCamelContext = stopCamelContext;
    }

    public void notify(CamelEvent event) throws Exception {
        boolean complete;
        boolean begin = event instanceof CamelEvent.ExchangeCreatedEvent;
        boolean bl = complete = event instanceof CamelEvent.ExchangeCompletedEvent || event instanceof CamelEvent.ExchangeFailedEvent;
        if (this.maxMessages > 0 && complete) {
            ++this.doneMessages;
            boolean result = this.doneMessages >= this.maxMessages;
            LOG.trace("Duration max messages check {} >= {} -> {}", new Object[]{this.doneMessages, this.maxMessages, result});
            if (result && this.completed.compareAndSet(false, true)) {
                LOG.info("Duration max messages triggering shutdown of the JVM.");
                Thread thread = this.camelContext.getExecutorServiceManager().newThread("CamelMainShutdownCamelContext", (Runnable)new ShutdownTask());
                thread.start();
                if (this.idleExecutorService != null) {
                    this.idleExecutorService.shutdownNow();
                }
            }
        }
        if (this.maxIdleSeconds > 0L && (begin || complete)) {
            LOG.trace("Message activity so restarting stop watch");
            this.watch.restart();
        }
    }

    public boolean isEnabled(CamelEvent event) {
        return event instanceof CamelEvent.ExchangeCreatedEvent || event instanceof CamelEvent.ExchangeCompletedEvent || event instanceof CamelEvent.ExchangeFailedEvent;
    }

    public String toString() {
        return "MainDurationEventNotifier[" + this.maxMessages + " max messages]";
    }

    protected void doStart() throws Exception {
        if (this.maxIdleSeconds > 0L) {
            this.camelContext.addStartupListener((context, alreadyStarted) -> {
                this.watch = new StopWatch();
            });
            this.idleExecutorService = Executors.newSingleThreadScheduledExecutor();
            Runnable task = () -> {
                if (this.watch == null) {
                    return;
                }
                int inflight = this.camelContext.getInflightRepository().size();
                if (inflight > 0) {
                    LOG.trace("Duration max idle check is skipped due {} inflight messages", (Object)inflight);
                    return;
                }
                long seconds = this.watch.taken() / 1000L;
                boolean result = seconds >= this.maxIdleSeconds;
                LOG.trace("Duration max idle check {} >= {} -> {}", new Object[]{seconds, this.maxIdleSeconds, result});
                if (result && this.completed.compareAndSet(false, true)) {
                    LOG.info("Duration max idle triggering shutdown of the JVM.");
                    Thread thread = this.camelContext.getExecutorServiceManager().newThread("CamelMainShutdownCamelContext", (Runnable)new ShutdownTask());
                    thread.start();
                }
            };
            this.idleExecutorService.scheduleAtFixedRate(task, 1L, 1L, TimeUnit.SECONDS);
        }
    }

    private class ShutdownTask
    implements Runnable {
        private ShutdownTask() {
        }

        @Override
        public void run() {
            try {
                if (MainDurationEventNotifier.this.stopCamelContext) {
                    MainDurationEventNotifier.this.camelContext.stop();
                }
            }
            catch (Exception e) {
                LOG.warn("Error during stopping CamelContext. This exception is ignored.", (Throwable)e);
            }
            finally {
                MainDurationEventNotifier.this.latch.countDown();
            }
        }
    }
}

