/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.NoSuchLanguageException;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.PropertyBindingException;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.main.DefaultConfigurationConfigurer;
import org.apache.camel.main.MainConfigurationProperties;
import org.apache.camel.main.MainDurationEventNotifier;
import org.apache.camel.main.MainLifecycleStrategy;
import org.apache.camel.main.MainListener;
import org.apache.camel.model.HystrixConfigurationDefinition;
import org.apache.camel.model.Model;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.CamelBeanPostProcessor;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.support.LifecycleStrategySupport;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.OrderedProperties;
import org.apache.camel.util.ReflectionHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.concurrent.ThreadHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MainSupport
extends ServiceSupport {
    protected static final Logger LOG = LoggerFactory.getLogger(MainSupport.class);
    protected static final int UNINITIALIZED_EXIT_CODE = Integer.MIN_VALUE;
    protected static final int DEFAULT_EXIT_CODE = 0;
    protected final List<MainListener> listeners = new ArrayList<MainListener>();
    protected final List<Option> options = new ArrayList<Option>();
    protected final CountDownLatch latch = new CountDownLatch(1);
    protected final AtomicBoolean completed = new AtomicBoolean(false);
    protected final AtomicInteger exitCode = new AtomicInteger(Integer.MIN_VALUE);
    protected volatile CamelContext camelContext;
    protected volatile ProducerTemplate camelTemplate;
    protected final MainConfigurationProperties mainConfigurationProperties = new MainConfigurationProperties();
    protected List<RouteBuilder> routeBuilders = new ArrayList<RouteBuilder>();
    protected String routeBuilderClasses;
    protected List<Object> configurations = new ArrayList<Object>();
    protected String configurationClasses;
    protected String propertyPlaceholderLocations;
    protected Properties initialProperties;
    protected Properties overrideProperties;

    protected MainSupport(Class ... configurationClasses) {
        this();
        this.addConfigurationClass(configurationClasses);
    }

    protected MainSupport() {
        this.addOption(new Option("h", "help", "Displays the help screen"){

            @Override
            protected void doProcess(String arg, LinkedList<String> remainingArgs) {
                MainSupport.this.showOptions();
                MainSupport.this.completed();
            }
        });
        this.addOption(new ParameterOption("r", "routers", "Sets the router builder classes which will be loaded while starting the camel context", "routerBuilderClasses"){

            @Override
            protected void doProcess(String arg, String parameter, LinkedList<String> remainingArgs) {
                MainSupport.this.setRouteBuilderClasses(parameter);
            }
        });
        this.addOption(new ParameterOption("d", "duration", "Sets the time duration (seconds) that the application will run for before terminating.", "duration"){

            @Override
            protected void doProcess(String arg, String parameter, LinkedList<String> remainingArgs) {
                if (parameter.endsWith("s") || parameter.endsWith("S")) {
                    parameter = parameter.substring(0, parameter.length() - 1);
                }
                MainSupport.this.configure().setDurationMaxSeconds(Integer.parseInt(parameter));
            }
        });
        this.addOption(new ParameterOption("dm", "durationMaxMessages", "Sets the duration of maximum number of messages that the application will process before terminating.", "durationMaxMessages"){

            @Override
            protected void doProcess(String arg, String parameter, LinkedList<String> remainingArgs) {
                MainSupport.this.configure().setDurationMaxMessages(Integer.parseInt(parameter));
            }
        });
        this.addOption(new ParameterOption("di", "durationIdle", "Sets the idle time duration (seconds) duration that the application can be idle before terminating.", "durationIdle"){

            @Override
            protected void doProcess(String arg, String parameter, LinkedList<String> remainingArgs) {
                if (parameter.endsWith("s") || parameter.endsWith("S")) {
                    parameter = parameter.substring(0, parameter.length() - 1);
                }
                MainSupport.this.configure().setDurationMaxIdleSeconds(Integer.parseInt(parameter));
            }
        });
        this.addOption(new Option("t", "trace", "Enables tracing"){

            @Override
            protected void doProcess(String arg, LinkedList<String> remainingArgs) {
                MainSupport.this.enableTrace();
            }
        });
        this.addOption(new ParameterOption("e", "exitcode", "Sets the exit code if duration was hit", "exitcode"){

            @Override
            protected void doProcess(String arg, String parameter, LinkedList<String> remainingArgs) {
                MainSupport.this.configure().setDurationHitExitCode(Integer.parseInt(parameter));
            }
        });
        this.addOption(new ParameterOption("pl", "propertiesLocation", "Sets location(s) to load properties, such as from classpath or file system.", "propertiesLocation"){

            @Override
            protected void doProcess(String arg, String parameter, LinkedList<String> remainingArgs) {
                MainSupport.this.setPropertyPlaceholderLocations(parameter);
            }
        });
    }

    public void run() throws Exception {
        if (!this.completed.get()) {
            this.internalBeforeStart();
            this.beforeStart();
            this.start();
            try {
                this.afterStart();
                this.waitUntilCompleted();
                this.internalBeforeStop();
                this.beforeStop();
                this.stop();
                this.afterStop();
            }
            catch (Exception e) {
                LOG.error("Failed: {}", (Object)e, (Object)e);
            }
        }
    }

    public void disableHangupSupport() {
        this.mainConfigurationProperties.setHangupInterceptorEnabled(false);
    }

    public void enableHangupSupport() {
        this.mainConfigurationProperties.setHangupInterceptorEnabled(true);
    }

    public void addMainListener(MainListener listener) {
        this.listeners.add(listener);
    }

    public void removeMainListener(MainListener listener) {
        this.listeners.remove(listener);
    }

    protected void beforeStart() throws Exception {
        for (MainListener listener : this.listeners) {
            listener.beforeStart(this);
        }
    }

    protected void afterStart() throws Exception {
        for (MainListener listener : this.listeners) {
            listener.afterStart(this);
        }
    }

    private void internalBeforeStart() {
        if (this.mainConfigurationProperties.isHangupInterceptorEnabled()) {
            String threadName = ThreadHelper.resolveThreadName(null, (String)"CamelHangupInterceptor");
            HangupInterceptor task = new HangupInterceptor(this);
            task.setName(threadName);
            Runtime.getRuntime().addShutdownHook(task);
        }
    }

    protected void beforeStop() throws Exception {
        for (MainListener listener : this.listeners) {
            listener.beforeStop(this);
        }
    }

    protected void afterStop() throws Exception {
        for (MainListener listener : this.listeners) {
            listener.afterStop(this);
        }
    }

    private void internalBeforeStop() {
        try {
            if (this.camelTemplate != null) {
                ServiceHelper.stopService((Object)this.camelTemplate);
                this.camelTemplate = null;
            }
        }
        catch (Exception e) {
            LOG.debug("Error stopping camelTemplate due " + e.getMessage() + ". This exception is ignored.", (Throwable)e);
        }
    }

    public void completed() {
        this.completed.set(true);
        this.exitCode.compareAndSet(Integer.MIN_VALUE, 0);
        this.latch.countDown();
    }

    public void showOptions() {
        this.showOptionsHeader();
        for (Option option : this.options) {
            System.out.println(option.getInformation());
        }
    }

    public void parseArguments(String[] arguments) {
        LinkedList<String> args = new LinkedList<String>(Arrays.asList(arguments));
        boolean valid = true;
        while (!args.isEmpty()) {
            String arg = args.removeFirst();
            boolean handled = false;
            for (Option option : this.options) {
                if (!option.processOption(arg, args)) continue;
                handled = true;
                break;
            }
            if (handled) continue;
            System.out.println("Unknown option: " + arg);
            System.out.println();
            valid = false;
            break;
        }
        if (!valid) {
            this.showOptions();
            this.completed();
        }
    }

    public void addOption(Option option) {
        this.options.add(option);
    }

    public MainConfigurationProperties configure() {
        return this.mainConfigurationProperties;
    }

    @Deprecated
    public int getDuration() {
        return this.mainConfigurationProperties.getDurationMaxSeconds();
    }

    @Deprecated
    public void setDuration(int duration) {
        this.mainConfigurationProperties.setDurationMaxSeconds(duration);
    }

    @Deprecated
    public int getDurationIdle() {
        return this.mainConfigurationProperties.getDurationMaxIdleSeconds();
    }

    @Deprecated
    public void setDurationIdle(int durationIdle) {
        this.mainConfigurationProperties.setDurationMaxIdleSeconds(durationIdle);
    }

    @Deprecated
    public int getDurationMaxMessages() {
        return this.mainConfigurationProperties.getDurationMaxMessages();
    }

    @Deprecated
    public void setDurationMaxMessages(int durationMaxMessages) {
        this.mainConfigurationProperties.setDurationMaxMessages(durationMaxMessages);
    }

    @Deprecated
    public void setDurationHitExitCode(int durationHitExitCode) {
        this.mainConfigurationProperties.setDurationHitExitCode(durationHitExitCode);
    }

    @Deprecated
    public int getDurationHitExitCode() {
        return this.mainConfigurationProperties.getDurationHitExitCode();
    }

    public int getExitCode() {
        return this.exitCode.get();
    }

    public String getConfigurationClasses() {
        return this.configurationClasses;
    }

    public void setConfigurationClasses(String configurations) {
        this.configurationClasses = configurations;
    }

    public void addConfigurationClass(Class ... configuration) {
        String existing = this.configurationClasses;
        if (existing == null) {
            existing = "";
        }
        if (configuration != null) {
            for (Class clazz : configuration) {
                if (!existing.isEmpty()) {
                    existing = existing + ",";
                }
                existing = existing + clazz.getName();
            }
        }
        this.setConfigurationClasses(existing);
    }

    public void addConfiguration(Object configuration) {
        this.configurations.add(configuration);
    }

    public String getRouteBuilderClasses() {
        return this.routeBuilderClasses;
    }

    public void setRouteBuilderClasses(String builders) {
        this.routeBuilderClasses = builders;
    }

    public String getPropertyPlaceholderLocations() {
        return this.propertyPlaceholderLocations;
    }

    public void setPropertyPlaceholderLocations(String location) {
        this.propertyPlaceholderLocations = location;
    }

    @Deprecated
    public boolean isAutoConfigurationEnabled() {
        return this.mainConfigurationProperties.isAutoConfigurationEnabled();
    }

    @Deprecated
    public void setAutoConfigurationEnabled(boolean autoConfigurationEnabled) {
        this.mainConfigurationProperties.setAutoConfigurationEnabled(autoConfigurationEnabled);
    }

    public Properties getInitialProperties() {
        return this.initialProperties;
    }

    public void setInitialProperties(Properties initialProperties) {
        this.initialProperties = initialProperties;
    }

    public Properties getOverrideProperties() {
        return this.overrideProperties;
    }

    public void setOverrideProperties(Properties overrideProperties) {
        this.overrideProperties = overrideProperties;
    }

    public boolean isTrace() {
        return this.mainConfigurationProperties.isTracing();
    }

    public void enableTrace() {
        this.mainConfigurationProperties.setTracing(true);
    }

    protected void doStop() throws Exception {
        this.completed();
    }

    protected void doStart() throws Exception {
    }

    protected void waitUntilCompleted() {
        while (!this.completed.get()) {
            try {
                int idle = this.mainConfigurationProperties.getDurationMaxIdleSeconds();
                int max = this.mainConfigurationProperties.getDurationMaxMessages();
                long sec = this.mainConfigurationProperties.getDurationMaxSeconds();
                if (sec > 0L) {
                    LOG.info("Waiting for: {} seconds", (Object)sec);
                    this.latch.await(sec, TimeUnit.SECONDS);
                    this.exitCode.compareAndSet(Integer.MIN_VALUE, this.mainConfigurationProperties.getDurationHitExitCode());
                    this.completed.set(true);
                    continue;
                }
                if (idle > 0 || max > 0) {
                    if (idle > 0 && max > 0) {
                        LOG.info("Waiting to be idle for: {} seconds or until: {} messages has been processed", (Object)idle, (Object)max);
                    } else if (idle > 0) {
                        LOG.info("Waiting to be idle for: {} seconds", (Object)idle);
                    } else {
                        LOG.info("Waiting until: {} messages has been processed", (Object)max);
                    }
                    this.exitCode.compareAndSet(Integer.MIN_VALUE, this.mainConfigurationProperties.getDurationHitExitCode());
                    this.latch.await();
                    this.completed.set(true);
                    continue;
                }
                this.latch.await();
            }
            catch (InterruptedException e) {
                this.completed.set(true);
                this.latch.countDown();
                Thread.currentThread().interrupt();
            }
        }
    }

    public void run(String[] args) throws Exception {
        this.parseArguments(args);
        this.run();
        LOG.info("MainSupport exiting code: {}", (Object)this.getExitCode());
    }

    public void showOptionsHeader() {
        System.out.println("Apache Camel Runner takes the following options");
        System.out.println();
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public List<RouteBuilder> getRouteBuilders() {
        return this.routeBuilders;
    }

    public void setRouteBuilders(List<RouteBuilder> routeBuilders) {
        this.routeBuilders = routeBuilders;
    }

    public List<Object> getConfigurations() {
        return this.configurations;
    }

    public void setConfigurations(List<Object> configurations) {
        this.configurations = configurations;
    }

    public List<RouteDefinition> getRouteDefinitions() {
        ArrayList<RouteDefinition> answer = new ArrayList<RouteDefinition>();
        if (this.camelContext != null) {
            answer.addAll(((Model)this.camelContext.getExtension(Model.class)).getRouteDefinitions());
        }
        return answer;
    }

    public ProducerTemplate getCamelTemplate() throws Exception {
        if (this.camelTemplate == null) {
            this.camelTemplate = this.findOrCreateCamelTemplate();
        }
        return this.camelTemplate;
    }

    protected abstract ProducerTemplate findOrCreateCamelTemplate();

    protected abstract CamelContext createCamelContext();

    protected void initCamelContext() throws Exception {
        this.camelContext = this.createCamelContext();
        this.postProcessCamelContext(this.camelContext);
    }

    protected void loadRouteBuilders(CamelContext camelContext) throws Exception {
        CamelBeanPostProcessor postProcessor = ((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getBeanPostProcessor();
        for (RouteBuilder routeBuilder : this.getRouteBuilders()) {
            postProcessor.postProcessBeforeInitialization((Object)routeBuilder, routeBuilder.getClass().getName());
            postProcessor.postProcessAfterInitialization((Object)routeBuilder, routeBuilder.getClass().getName());
        }
        if (this.routeBuilderClasses != null) {
            String[] routeClasses;
            for (String routeClass : routeClasses = this.routeBuilderClasses.split(",")) {
                Class routeClazz = camelContext.getClassResolver().resolveClass(routeClass);
                Object builder = camelContext.getInjector().newInstance(routeClazz);
                if (builder instanceof RouteBuilder) {
                    this.getRouteBuilders().add((RouteBuilder)builder);
                    continue;
                }
                LOG.warn("Class {} is not a RouteBuilder class", (Object)routeClazz);
            }
        }
    }

    protected void loadConfigurations(CamelContext camelContext) throws Exception {
        CamelBeanPostProcessor postProcessor = ((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getBeanPostProcessor();
        for (Object object : this.getConfigurations()) {
            postProcessor.postProcessBeforeInitialization(object, object.getClass().getName());
            postProcessor.postProcessAfterInitialization(object, object.getClass().getName());
        }
        if (this.configurationClasses != null) {
            String[] configClasses;
            for (String configClass : configClasses = this.configurationClasses.split(",")) {
                Class configClazz = camelContext.getClassResolver().resolveClass(configClass);
                Object config = camelContext.getInjector().newInstance(configClazz);
                this.getConfigurations().add(config);
            }
        }
        for (Object object : this.getConfigurations()) {
            Method method = ReflectionHelper.findMethod(object.getClass(), (String)"configure", (Class[])new Class[0]);
            if (method == null) continue;
            this.log.info("Calling configure method on configuration class: {}", (Object)object.getClass().getName());
            ObjectHelper.invokeMethod((Method)method, (Object)object, (Object[])new Object[0]);
        }
    }

    protected void postProcessCamelContext(CamelContext camelContext) throws Exception {
        PropertiesComponent pc;
        if (this.propertyPlaceholderLocations != null) {
            pc = camelContext.getPropertiesComponent();
            pc.addLocation(this.propertyPlaceholderLocations);
            if (this.initialProperties != null) {
                pc.setInitialProperties(this.initialProperties);
            }
            if (this.overrideProperties != null) {
                pc.setOverrideProperties(this.overrideProperties);
            }
            LOG.info("Using properties from: {}", (Object)this.propertyPlaceholderLocations);
        } else {
            pc = camelContext.getPropertiesComponent();
            if (pc.getLocations().isEmpty()) {
                pc.addLocation("classpath:application.properties;optional=true");
            }
            if (this.initialProperties != null) {
                pc.setInitialProperties(this.initialProperties);
            }
            if (this.overrideProperties != null) {
                pc.setOverrideProperties(this.overrideProperties);
            }
            LOG.info("Using properties from classpath:application.properties");
        }
        if (this.mainConfigurationProperties.getDurationMaxMessages() > 0 || this.mainConfigurationProperties.getDurationMaxIdleSeconds() > 0) {
            MainDurationEventNotifier notifier = new MainDurationEventNotifier(camelContext, this.mainConfigurationProperties.getDurationMaxMessages(), this.mainConfigurationProperties.getDurationMaxIdleSeconds(), this.completed, this.latch, true);
            ServiceHelper.startService((Object)((Object)notifier));
            camelContext.getManagementStrategy().addEventNotifier((EventNotifier)notifier);
        }
        LinkedHashMap<String, String> autoConfiguredProperties = new LinkedHashMap<String, String>();
        if (this.mainConfigurationProperties.isAutoConfigurationEnabled()) {
            this.autoConfigurationFailFast(camelContext, autoConfiguredProperties);
            this.autoConfigurationPropertiesComponent(camelContext, autoConfiguredProperties);
            this.autoConfigurationMainConfiguration(camelContext, this.mainConfigurationProperties, autoConfiguredProperties);
        }
        this.doConfigureCamelContextFromMainConfiguration(camelContext, this.mainConfigurationProperties, autoConfiguredProperties);
        this.loadConfigurations(camelContext);
        if (this.mainConfigurationProperties.isAutowireComponentProperties() || this.mainConfigurationProperties.isAutowireComponentPropertiesDeep()) {
            this.autowireConfigurationFromRegistry(camelContext, this.mainConfigurationProperties.isAutowireComponentPropertiesDeep());
        }
        if (this.mainConfigurationProperties.isAutoConfigurationEnabled()) {
            this.autoConfigurationFromProperties(camelContext, autoConfiguredProperties);
        }
        if (this.mainConfigurationProperties.isAutoConfigurationLogSummary() && !autoConfiguredProperties.isEmpty()) {
            LOG.info("Auto-configuration summary:");
            autoConfiguredProperties.forEach((k, v) -> {
                boolean sensitive;
                boolean bl = sensitive = k.toLowerCase(Locale.US).contains("password") || k.contains("secret") || k.contains("passphrase") || k.contains("token");
                if (sensitive) {
                    LOG.info("\t{}=xxxxxx", k);
                } else {
                    LOG.info("\t{}={}", k, v);
                }
            });
        }
        this.loadRouteBuilders(camelContext);
        for (RouteBuilder routeBuilder : this.routeBuilders) {
            camelContext.addRoutes((RoutesBuilder)routeBuilder);
        }
        camelContext.addLifecycleStrategy((LifecycleStrategy)new MainLifecycleStrategy(this.completed, this.latch));
        for (MainListener listener : this.listeners) {
            listener.configure(camelContext);
        }
    }

    protected void autoConfigurationFailFast(CamelContext camelContext, Map<String, String> autoConfiguredProperties) throws Exception {
        Object failFast;
        Properties prop = camelContext.getPropertiesComponent().loadProperties();
        LOG.debug("Properties from Camel properties component:");
        for (String key : prop.stringPropertyNames()) {
            LOG.debug("    {}={}", (Object)key, (Object)prop.getProperty(key));
        }
        Object envEnabled = prop.remove("camel.main.autoConfigurationEnvironmentVariablesEnabled");
        if (envEnabled == null && (envEnabled = prop.remove("camel.main.auto-configuration-environment-variables-enabled")) != null) {
            PropertyBindingSupport.bindMandatoryProperty((CamelContext)camelContext, (Object)this.mainConfigurationProperties, (String)"autoConfigurationEnvironmentVariablesEnabled", (Object)envEnabled, (boolean)true);
            autoConfiguredProperties.put("camel.main.auto-configuration-environment-variables-enabled", envEnabled.toString());
        }
        Properties propENV = null;
        if (this.mainConfigurationProperties.isAutoConfigurationEnvironmentVariablesEnabled() && !(propENV = MainSupport.loadEnvironmentVariablesAsProperties(new String[]{"camel.main."})).isEmpty()) {
            prop.putAll((Map<?, ?>)propENV);
            LOG.debug("Properties from OS environment variables:");
            for (String key : propENV.stringPropertyNames()) {
                LOG.debug("    {}={}", (Object)key, (Object)propENV.getProperty(key));
            }
        }
        Object object = failFast = propENV != null ? propENV.remove("camel.main.autoconfigurationfailfast") : null;
        if (failFast != null) {
            PropertyBindingSupport.bindMandatoryProperty((CamelContext)camelContext, (Object)this.mainConfigurationProperties, (String)"autoConfigurationFailFast", (Object)failFast, (boolean)true);
        } else {
            failFast = prop.remove("camel.main.autoConfigurationFailFast");
            if (failFast == null) {
                failFast = prop.remove("camel.main.auto-configuration-fail-fast");
            }
            if (failFast != null) {
                PropertyBindingSupport.bindMandatoryProperty((CamelContext)camelContext, (Object)this.mainConfigurationProperties, (String)"autoConfigurationFailFast", (Object)failFast, (boolean)true);
                autoConfiguredProperties.put("camel.main.auto-configuration-fail-fast", failFast.toString());
            }
        }
    }

    protected void doConfigureCamelContextFromMainConfiguration(CamelContext camelContext, MainConfigurationProperties config, Map<String, String> autoConfiguredProperties) throws Exception {
        RestConfiguration rest;
        HystrixConfigurationDefinition hystrix;
        ModelCamelContext model;
        Properties propENV;
        if (config.getFileConfigurations() != null) {
            String[] locs;
            for (String loc : locs = config.getFileConfigurations().split(",")) {
                String pattern;
                File[] files;
                String path = FileUtil.onlyPath((String)loc);
                if (path == null || (files = new File(path).listFiles(arg_0 -> MainSupport.lambda$doConfigureCamelContextFromMainConfiguration$1(pattern = loc.length() > path.length() ? loc.substring(path.length() + 1) : null, arg_0))) == null) continue;
                for (File file : files) {
                    Properties props = new Properties();
                    try (FileInputStream is = new FileInputStream(file);){
                        props.load(is);
                    }
                    if (props.isEmpty()) continue;
                    if (this.overrideProperties == null) {
                        this.overrideProperties = new Properties();
                        PropertiesComponent pc = camelContext.getPropertiesComponent();
                        pc.setOverrideProperties(this.overrideProperties);
                    }
                    LOG.info("Loaded additional {} properties from file: {}", (Object)props.size(), (Object)file);
                    this.overrideProperties.putAll((Map<?, ?>)props);
                }
            }
        }
        DefaultConfigurationConfigurer.configure(camelContext, config);
        DefaultConfigurationConfigurer.afterPropertiesSet(camelContext);
        Properties prop = camelContext.getPropertiesComponent().loadProperties();
        if (this.mainConfigurationProperties.isAutoConfigurationEnvironmentVariablesEnabled() && !(propENV = MainSupport.loadEnvironmentVariablesAsProperties(new String[]{"camel.component.properties."})).isEmpty()) {
            prop.putAll((Map<?, ?>)propENV);
            LOG.debug("Properties from OS environment variables:");
            for (String key : propENV.stringPropertyNames()) {
                LOG.debug("    {}={}", (Object)key, (Object)propENV.getProperty(key));
            }
        }
        LinkedHashMap<String, Object> contextProperties = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> hystrixProperties = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> restProperties = new LinkedHashMap<String, Object>();
        for (String key : prop.stringPropertyNames()) {
            String option;
            String value;
            if (key.startsWith("camel.context.")) {
                value = prop.getProperty(key);
                option = key.substring(14);
                this.validateOptionAndValue(key, option, value);
                contextProperties.put(MainSupport.optionKey(option), value);
                continue;
            }
            if (key.startsWith("camel.hystrix.")) {
                value = prop.getProperty(key);
                option = key.substring(14);
                this.validateOptionAndValue(key, option, value);
                hystrixProperties.put(MainSupport.optionKey(option), value);
                continue;
            }
            if (!key.startsWith("camel.rest.")) continue;
            value = prop.getProperty(key);
            option = key.substring(11);
            this.validateOptionAndValue(key, option, value);
            restProperties.put(MainSupport.optionKey(option), value);
        }
        if (!contextProperties.isEmpty()) {
            LOG.debug("Auto-configuring CamelContext from loaded properties: {}", (Object)contextProperties.size());
            MainSupport.setPropertiesOnTarget(camelContext, camelContext, contextProperties, null, "camel.context.", this.mainConfigurationProperties.isAutoConfigurationFailFast(), true, autoConfiguredProperties);
        }
        if (!hystrixProperties.isEmpty()) {
            LOG.debug("Auto-configuring Hystrix EIP from loaded properties: {}", (Object)hystrixProperties.size());
            model = (ModelCamelContext)camelContext.adapt(ModelCamelContext.class);
            hystrix = model.getHystrixConfiguration(null);
            if (hystrix == null) {
                hystrix = new HystrixConfigurationDefinition();
                model.setHystrixConfiguration(hystrix);
            }
            MainSupport.setPropertiesOnTarget(camelContext, hystrix, hystrixProperties, null, "camel.hsytrix.", this.mainConfigurationProperties.isAutoConfigurationFailFast(), true, autoConfiguredProperties);
        }
        if (!restProperties.isEmpty()) {
            LOG.debug("Auto-configuring Rest DSL from loaded properties: {}", (Object)restProperties.size());
            model = (ModelCamelContext)camelContext.adapt(ModelCamelContext.class);
            rest = model.getRestConfiguration();
            if (rest == null) {
                rest = new RestConfiguration();
                model.setRestConfiguration(rest);
            }
            MainSupport.setPropertiesOnTarget(camelContext, rest, restProperties, null, "camel.rest.", this.mainConfigurationProperties.isAutoConfigurationFailFast(), true, autoConfiguredProperties);
        }
        if (!contextProperties.isEmpty()) {
            contextProperties.forEach((k, v) -> LOG.warn("Property not auto-configured: camel.context.{}={} on bean: {}", new Object[]{k, v, camelContext}));
        }
        if (!hystrixProperties.isEmpty()) {
            model = (ModelCamelContext)camelContext.adapt(ModelCamelContext.class);
            hystrix = model.getHystrixConfiguration(null);
            hystrixProperties.forEach((k, v) -> LOG.warn("Property not auto-configured: camel.hystrix.{}={} on bean: {}", new Object[]{k, v, hystrix}));
        }
        if (!restProperties.isEmpty()) {
            model = (ModelCamelContext)camelContext.adapt(ModelCamelContext.class);
            rest = model.getRestConfiguration();
            restProperties.forEach((k, v) -> LOG.warn("Property not auto-configured: camel.rest.{}={} on bean: {}", new Object[]{k, v, rest}));
        }
    }

    protected void autoConfigurationPropertiesComponent(CamelContext camelContext, Map<String, String> autoConfiguredProperties) throws Exception {
        Properties propENV;
        Properties prop = camelContext.getPropertiesComponent().loadProperties();
        if (this.mainConfigurationProperties.isAutoConfigurationEnvironmentVariablesEnabled() && !(propENV = MainSupport.loadEnvironmentVariablesAsProperties(new String[]{"camel.component.properties."})).isEmpty()) {
            prop.putAll((Map<?, ?>)propENV);
        }
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        for (String key : prop.stringPropertyNames()) {
            if (!key.startsWith("camel.component.properties.")) continue;
            int dot = key.indexOf(".", 26);
            String option = dot == -1 ? "" : key.substring(dot + 1);
            String value = prop.getProperty(key, "");
            this.validateOptionAndValue(key, option, value);
            properties.put(MainSupport.optionKey(option), value);
        }
        if (!properties.isEmpty()) {
            LOG.debug("Auto-configuring properties component from loaded properties: {}", (Object)properties.size());
            MainSupport.setPropertiesOnTarget(camelContext, camelContext.getPropertiesComponent(), properties, null, "camel.component.properties.", this.mainConfigurationProperties.isAutoConfigurationFailFast(), true, autoConfiguredProperties);
        }
        if (!properties.isEmpty()) {
            properties.forEach((k, v) -> LOG.warn("Property not auto-configured: camel.component.properties.{}={} on object: {}", new Object[]{k, v, camelContext.getPropertiesComponent()}));
        }
    }

    protected void autoConfigurationMainConfiguration(CamelContext camelContext, MainConfigurationProperties config, Map<String, String> autoConfiguredProperties) throws Exception {
        Properties propENV;
        Properties prop = camelContext.getPropertiesComponent().loadProperties();
        if (this.mainConfigurationProperties.isAutoConfigurationEnvironmentVariablesEnabled() && !(propENV = MainSupport.loadEnvironmentVariablesAsProperties(new String[]{"camel.main."})).isEmpty()) {
            prop.putAll((Map<?, ?>)propENV);
        }
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        for (String key : prop.stringPropertyNames()) {
            if (!key.startsWith("camel.main.")) continue;
            String value = prop.getProperty(key);
            String option = key.substring(11);
            this.validateOptionAndValue(key, option, value);
            properties.put(MainSupport.optionKey(option), value);
        }
        if (!properties.isEmpty()) {
            LOG.debug("Auto-configuring main from loaded properties: {}", (Object)properties.size());
            MainSupport.setPropertiesOnTarget(camelContext, config, properties, null, "camel.main.", this.mainConfigurationProperties.isAutoConfigurationFailFast(), true, autoConfiguredProperties);
        }
        if (!properties.isEmpty()) {
            properties.forEach((k, v) -> LOG.warn("Property not auto-configured: camel.main.{}={} on bean: {}", new Object[]{k, v, config}));
        }
    }

    protected void autoConfigurationFromProperties(CamelContext camelContext, Map<String, String> autoConfiguredProperties) throws Exception {
        Properties propENV;
        OrderedProperties prop = new OrderedProperties();
        try {
            InputStream is = camelContext.getClassResolver().loadResourceAsStream("/META-INF/services/org/apache/camel/autowire.properties");
            if (is != null) {
                prop.load(is);
                if (!prop.isEmpty()) {
                    LOG.info("Autowired enabled from classpath: META-INF/services/org/apache/camel/autowire.properties with {} properties", (Object)prop.size());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Properties from classpath: META-INF/services/org/apache/camel/autowire.properties:");
                        for (String string : prop.stringPropertyNames()) {
                            LOG.debug("    {}={}", (Object)string, (Object)prop.getProperty(string));
                        }
                    }
                }
                IOHelper.close((Closeable)is);
            }
        }
        catch (Throwable is) {
            // empty catch block
        }
        Properties propPC = camelContext.getPropertiesComponent().loadProperties();
        prop.putAll((Map<?, ?>)propPC);
        if (this.mainConfigurationProperties.isAutoConfigurationEnvironmentVariablesEnabled() && !(propENV = MainSupport.loadEnvironmentVariablesAsProperties(new String[]{"camel.component.", "camel.dataformat.", "camel.language."})).isEmpty()) {
            prop.putAll((Map<?, ?>)propENV);
        }
        LinkedHashMap<PropertyOptionKey, Map> properties = new LinkedHashMap<PropertyOptionKey, Map>();
        for (String key : prop.stringPropertyNames()) {
            Language language;
            Map values;
            PropertyOptionKey pok;
            String prefix;
            String value;
            String option;
            String name;
            int dot;
            if (key.startsWith("camel.component.")) {
                dot = key.indexOf(".", 16);
                name = dot == -1 ? key.substring(16) : key.substring(16, dot);
                if ("properties".equals(name)) continue;
                Component component = camelContext.getComponent(name);
                if (component == null) {
                    throw new IllegalArgumentException("Error configuring property: " + key + " because cannot find component with name " + name + ". Make sure you have the component on the classpath");
                }
                option = dot == -1 ? "" : key.substring(dot + 1);
                value = prop.getProperty(key, "");
                prefix = dot == -1 ? "" : key.substring(0, dot + 1);
                this.validateOptionAndValue(key, option, value);
                pok = new PropertyOptionKey(key, component, prefix);
                values = properties.getOrDefault(pok, new LinkedHashMap());
                values.put(MainSupport.optionKey(option), value);
                properties.put(pok, values);
            }
            if (key.startsWith("camel.dataformat.")) {
                dot = key.indexOf(".", 17);
                name = dot == -1 ? key.substring(17) : key.substring(17, dot);
                DataFormat dataformat = camelContext.resolveDataFormat(name);
                if (dataformat == null) {
                    throw new IllegalArgumentException("Error configuring property: " + key + " because cannot find dataformat with name " + name + ". Make sure you have the dataformat on the classpath");
                }
                option = dot == -1 ? "" : key.substring(dot + 1);
                value = prop.getProperty(key, "");
                prefix = dot == -1 ? "" : key.substring(0, dot + 1);
                this.validateOptionAndValue(key, option, value);
                pok = new PropertyOptionKey(key, dataformat, prefix);
                values = properties.getOrDefault(pok, new LinkedHashMap());
                values.put(MainSupport.optionKey(option), value);
                properties.put(pok, values);
            }
            if (!key.startsWith("camel.language.")) continue;
            dot = key.indexOf(".", 15);
            name = dot == -1 ? key.substring(15) : key.substring(15, dot);
            try {
                language = camelContext.resolveLanguage(name);
            }
            catch (NoSuchLanguageException e) {
                throw new IllegalArgumentException("Error configuring property: " + key + " because cannot find language with name " + name + ". Make sure you have the language on the classpath");
            }
            option = dot == -1 ? "" : key.substring(dot + 1);
            value = prop.getProperty(key, "");
            prefix = dot == -1 ? "" : key.substring(0, dot + 1);
            this.validateOptionAndValue(key, option, value);
            pok = new PropertyOptionKey(key, language, prefix);
            values = properties.getOrDefault(pok, new LinkedHashMap());
            values.put(MainSupport.optionKey(option), value);
            properties.put(pok, values);
        }
        if (!properties.isEmpty()) {
            long l = properties.values().stream().mapToLong(Map::size).sum();
            LOG.debug("Auto-configuring {} components/dataformat/languages from loaded properties: {}", (Object)properties.size(), (Object)l);
        }
        for (PropertyOptionKey pok : properties.keySet()) {
            Map values = (Map)properties.get(pok);
            String optionKey = pok.getKey().substring(pok.getOptionPrefix().length());
            MainSupport.setPropertiesOnTarget(camelContext, pok.getInstance(), values, optionKey, pok.getOptionPrefix(), this.mainConfigurationProperties.isAutoConfigurationFailFast(), true, autoConfiguredProperties);
        }
        if (!properties.isEmpty()) {
            for (PropertyOptionKey pok : properties.keySet()) {
                Map values = (Map)properties.get(pok);
                values.forEach((k, v) -> {
                    String stringValue = v != null ? v.toString() : null;
                    LOG.warn("Property ({}={}) not auto-configured with name: {} on bean: {} with value: {}", new Object[]{pok.getKey(), stringValue, k, pok.getInstance(), stringValue});
                });
            }
        }
    }

    protected void autowireConfigurationFromRegistry(final CamelContext camelContext, final boolean deepNesting) throws Exception {
        camelContext.addLifecycleStrategy((LifecycleStrategy)new LifecycleStrategySupport(){

            public void onComponentAdd(String name, Component component) {
                PropertyBindingSupport.autowireSingletonPropertiesFromRegistry((CamelContext)camelContext, (Object)component, (boolean)false, (boolean)deepNesting, (obj, propertyName, type, value) -> LOG.info("Autowired property: {} on component: {} as exactly one instance of type: {} found in the registry", new Object[]{propertyName, component.getClass().getSimpleName(), type.getName()}));
            }
        });
    }

    protected static Properties loadEnvironmentVariablesAsProperties(String[] prefixes) {
        OrderedProperties answer = new OrderedProperties();
        if (prefixes == null || prefixes.length == 0) {
            return answer;
        }
        for (String prefix : prefixes) {
            String pk = prefix.toUpperCase(Locale.US).replaceAll("[^\\w]", "-");
            String pk2 = pk.replace('-', '_');
            System.getenv().forEach((arg_0, arg_1) -> MainSupport.lambda$loadEnvironmentVariablesAsProperties$8(pk, pk2, (Properties)answer, arg_0, arg_1));
        }
        return answer;
    }

    protected void validateOptionAndValue(String key, String option, String value) {
        if (org.apache.camel.util.ObjectHelper.isEmpty((Object)option)) {
            throw new IllegalArgumentException("Error configuring property: " + key + " because option is empty");
        }
        if (org.apache.camel.util.ObjectHelper.isEmpty((Object)value)) {
            throw new IllegalArgumentException("Error configuring property: " + key + " because value is empty");
        }
    }

    private static String optionKey(String key) {
        key = StringHelper.replaceAll((String)key, (String)"-", (String)"");
        key = key.toLowerCase(Locale.US);
        return key;
    }

    public void addRouteBuilder(RouteBuilder routeBuilder) {
        this.getRouteBuilders().add(routeBuilder);
    }

    public void addRouteBuilder(Class ... routeBuilder) {
        String existing = this.routeBuilderClasses;
        if (existing == null) {
            existing = "";
        }
        if (routeBuilder != null) {
            for (Class clazz : routeBuilder) {
                if (!existing.isEmpty()) {
                    existing = existing + ",";
                }
                existing = existing + clazz.getName();
            }
        }
        this.setRouteBuilderClasses(existing);
    }

    private static boolean setPropertiesOnTarget(CamelContext context, Object target, Map<String, Object> properties, String optionKey, String optionPrefix, boolean failIfNotSet, boolean ignoreCase, Map<String, String> autoConfiguredProperties) throws Exception {
        org.apache.camel.util.ObjectHelper.notNull((Object)context, (String)"context");
        org.apache.camel.util.ObjectHelper.notNull((Object)target, (String)"target");
        org.apache.camel.util.ObjectHelper.notNull(properties, (String)"properties");
        boolean rc = false;
        Iterator<Map.Entry<String, Object>> it = properties.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Object> entry = it.next();
            String name = entry.getKey();
            Object value = entry.getValue();
            String stringValue = value != null ? value.toString() : null;
            String key = name;
            if (optionPrefix != null && optionKey != null) {
                key = optionPrefix + optionKey;
            } else if (optionPrefix != null) {
                key = optionPrefix + name;
            }
            LOG.debug("Configuring property: {}={} on bean: {}", new Object[]{key, stringValue, target});
            try {
                boolean hit;
                if (failIfNotSet) {
                    PropertyBindingSupport.bindMandatoryProperty((CamelContext)context, (Object)target, (String)name, (Object)stringValue, (boolean)ignoreCase);
                    hit = true;
                } else {
                    hit = PropertyBindingSupport.bindProperty((CamelContext)context, (Object)target, (String)name, (Object)stringValue, (boolean)ignoreCase);
                }
                if (!hit) continue;
                it.remove();
                rc = true;
                LOG.debug("Configured property: {}={} on bean: {}", new Object[]{key, stringValue, target});
                autoConfiguredProperties.put(key, stringValue);
            }
            catch (PropertyBindingException e) {
                if (failIfNotSet) {
                    throw new PropertyBindingException(e.getTarget(), e.getPropertyName(), e.getValue(), optionPrefix, optionKey, e.getCause());
                }
                LOG.debug("Error configuring property (" + key + ") with name: " + name + ") on bean: " + target + " with value: " + stringValue + ". This exception is ignored as failIfNotSet=false.", (Throwable)e);
            }
        }
        return rc;
    }

    private static /* synthetic */ void lambda$loadEnvironmentVariablesAsProperties$8(String pk, String pk2, Properties answer, String k, String v) {
        if ((k = k.toUpperCase(Locale.US)).startsWith(pk) || k.startsWith(pk2)) {
            String key = k.toLowerCase(Locale.US).replace('_', '.');
            answer.put(key, v);
        }
    }

    private static /* synthetic */ boolean lambda$doConfigureCamelContextFromMainConfiguration$1(String pattern, File f) {
        return StringHelper.matches((String)pattern, (String)f.getName());
    }

    public abstract class ParameterOption
    extends Option {
        private String parameterName;

        protected ParameterOption(String abbreviation, String fullName, String description, String parameterName) {
            super(abbreviation, fullName, description);
            this.parameterName = parameterName;
        }

        @Override
        protected void doProcess(String arg, LinkedList<String> remainingArgs) {
            if (remainingArgs.isEmpty()) {
                System.err.println("Expected fileName for ");
                MainSupport.this.showOptions();
                MainSupport.this.completed();
            } else {
                String parameter = remainingArgs.removeFirst();
                this.doProcess(arg, parameter, remainingArgs);
            }
        }

        @Override
        public String getInformation() {
            return "  " + this.getAbbreviation() + " or " + this.getFullName() + " <" + this.parameterName + "> = " + this.getDescription();
        }

        protected abstract void doProcess(String var1, String var2, LinkedList<String> var3);
    }

    public abstract class Option {
        private String abbreviation;
        private String fullName;
        private String description;

        protected Option(String abbreviation, String fullName, String description) {
            this.abbreviation = "-" + abbreviation;
            this.fullName = "-" + fullName;
            this.description = description;
        }

        public boolean processOption(String arg, LinkedList<String> remainingArgs) {
            if (arg.equalsIgnoreCase(this.abbreviation) || this.fullName.startsWith(arg)) {
                this.doProcess(arg, remainingArgs);
                return true;
            }
            return false;
        }

        public String getAbbreviation() {
            return this.abbreviation;
        }

        public String getDescription() {
            return this.description;
        }

        public String getFullName() {
            return this.fullName;
        }

        public String getInformation() {
            return "  " + this.getAbbreviation() + " or " + this.getFullName() + " = " + this.getDescription();
        }

        protected abstract void doProcess(String var1, LinkedList<String> var2);
    }

    private static final class PropertyOptionKey {
        private final String key;
        private final Object instance;
        private final String optionPrefix;

        private PropertyOptionKey(String key, Object instance, String optionPrefix) {
            this.key = key;
            this.instance = instance;
            this.optionPrefix = optionPrefix;
        }

        public String getKey() {
            return this.key;
        }

        public Object getInstance() {
            return this.instance;
        }

        public String getOptionPrefix() {
            return this.optionPrefix;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PropertyOptionKey that = (PropertyOptionKey)o;
            return this.key.equals(that.key) && this.instance.equals(that.instance);
        }

        public int hashCode() {
            return Objects.hash(this.key, this.instance);
        }
    }

    private static final class HangupInterceptor
    extends Thread {
        Logger log = LoggerFactory.getLogger(this.getClass());
        final MainSupport mainInstance;

        HangupInterceptor(MainSupport main) {
            this.mainInstance = main;
        }

        @Override
        public void run() {
            this.log.info("Received hang up - stopping the main instance.");
            try {
                this.mainInstance.stop();
            }
            catch (Exception ex) {
                this.log.warn("Error during stopping the main instance.", (Throwable)ex);
            }
        }
    }
}

