/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.mime.multipart;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParseException;
import javax.mail.util.ByteArrayDataSource;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.attachment.Attachment;
import org.apache.camel.attachment.AttachmentMessage;
import org.apache.camel.attachment.DefaultAttachment;
import org.apache.camel.spi.annotations.Dataformat;
import org.apache.camel.support.DefaultDataFormat;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.util.IOHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Dataformat(value="mimeMultipart")
public class MimeMultipartDataFormat
extends DefaultDataFormat {
    private static final Logger LOG = LoggerFactory.getLogger(MimeMultipartDataFormat.class);
    private static final String MIME_VERSION = "MIME-Version";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String CONTENT_TRANSFER_ENCODING = "Content-Transfer-Encoding";
    private static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";
    private static final String[] STANDARD_HEADERS = new String[]{"Message-ID", "MIME-Version", "Content-Type"};
    private String multipartSubType = "mixed";
    private boolean multipartWithoutAttachment;
    private boolean headersInline;
    private String includeHeaders;
    private Pattern includeHeadersPattern;
    private boolean binaryContent;

    public void setBinaryContent(boolean binaryContent) {
        this.binaryContent = binaryContent;
    }

    public void setHeadersInline(boolean headersInline) {
        this.headersInline = headersInline;
    }

    public void setIncludeHeaders(String includeHeaders) {
        this.includeHeaders = includeHeaders;
    }

    public void setMultipartWithoutAttachment(boolean multipartWithoutAttachment) {
        this.multipartWithoutAttachment = multipartWithoutAttachment;
    }

    public void setMultipartSubType(String multipartSubType) {
        this.multipartSubType = multipartSubType;
    }

    public void marshal(Exchange exchange, Object graph, OutputStream stream) throws NoTypeConversionAvailableException, MessagingException, IOException {
        if (this.multipartWithoutAttachment || this.headersInline || ((AttachmentMessage)exchange.getIn(AttachmentMessage.class)).hasAttachments()) {
            ContentType contentType = this.getContentType(exchange);
            exchange.getMessage().removeHeader(CONTENT_TYPE);
            byte[] bodyContent = (byte[])ExchangeHelper.convertToMandatoryType((Exchange)exchange, byte[].class, (Object)graph);
            Session session = Session.getInstance((Properties)System.getProperties());
            MimeMessage mm = new MimeMessage(session);
            MimeMultipart mp = new MimeMultipart(this.multipartSubType);
            MimeBodyPart part = new MimeBodyPart();
            this.writeBodyPart(bodyContent, (Part)part, contentType);
            mp.addBodyPart((BodyPart)part);
            if (((AttachmentMessage)exchange.getIn(AttachmentMessage.class)).hasAttachments()) {
                ArrayList idsToRemove = new ArrayList();
                for (Map.Entry entry : ((AttachmentMessage)exchange.getIn(AttachmentMessage.class)).getAttachmentObjects().entrySet()) {
                    String attachmentFilename = (String)entry.getKey();
                    Attachment attachment = (Attachment)entry.getValue();
                    part = new MimeBodyPart();
                    part.setDataHandler(attachment.getDataHandler());
                    part.setFileName(MimeUtility.encodeText((String)attachmentFilename, (String)"UTF-8", null));
                    String ct = attachment.getDataHandler().getContentType();
                    contentType = new ContentType(ct);
                    part.setHeader(CONTENT_TYPE, ct);
                    if (!contentType.match("text/*") && this.binaryContent) {
                        part.setHeader(CONTENT_TRANSFER_ENCODING, "binary");
                    } else {
                        this.setContentTransferEncoding((Part)part, contentType);
                    }
                    for (String headerName : attachment.getHeaderNames()) {
                        List values = attachment.getHeaderAsList(headerName);
                        for (String value : values) {
                            part.setHeader(headerName, value);
                        }
                    }
                    mp.addBodyPart((BodyPart)part);
                    idsToRemove.add(attachmentFilename);
                }
                Iterator iterator = idsToRemove.iterator();
                while (iterator.hasNext()) {
                    String id = (String)iterator.next();
                    ((AttachmentMessage)exchange.getMessage(AttachmentMessage.class)).removeAttachment(id);
                }
            }
            mm.setContent((Multipart)mp);
            if (this.headersInline && this.includeHeadersPattern != null) {
                for (Map.Entry entry : exchange.getIn().getHeaders().entrySet()) {
                    String headerStr;
                    if (!this.includeHeadersPattern.matcher((CharSequence)entry.getKey()).matches() || (headerStr = (String)ExchangeHelper.convertToType((Exchange)exchange, String.class, entry.getValue())) == null) continue;
                    mm.setHeader((String)entry.getKey(), headerStr);
                }
            }
            mm.saveChanges();
            Enumeration hl = mm.getAllHeaders();
            ArrayList<String> arrayList = new ArrayList<String>();
            if (!this.headersInline) {
                while (hl.hasMoreElements()) {
                    Object ho = hl.nextElement();
                    if (!(ho instanceof Header)) continue;
                    Header h = (Header)ho;
                    exchange.getMessage().setHeader(h.getName(), (Object)h.getValue());
                    arrayList.add(h.getName());
                }
            }
            mm.writeTo(stream, arrayList.toArray(new String[0]));
        } else {
            InputStream is = (InputStream)ExchangeHelper.convertToMandatoryType((Exchange)exchange, InputStream.class, (Object)graph);
            IOHelper.copyAndCloseInput((InputStream)is, (OutputStream)stream);
        }
    }

    private ContentType getContentType(Exchange exchange) throws ParseException {
        String contentTypeStr = ExchangeHelper.getContentType((Exchange)exchange);
        if (contentTypeStr == null) {
            contentTypeStr = DEFAULT_CONTENT_TYPE;
        }
        ContentType contentType = new ContentType(contentTypeStr);
        String contentEncoding = ExchangeHelper.getContentEncoding((Exchange)exchange);
        if (contentEncoding != null && contentType.match("text/*")) {
            contentType.setParameter("charset", MimeUtility.mimeCharset((String)contentEncoding));
        }
        return contentType;
    }

    private void writeBodyPart(byte[] bodyContent, Part part, ContentType contentType) throws MessagingException {
        ByteArrayDataSource ds = new ByteArrayDataSource(bodyContent, contentType.toString());
        part.setDataHandler(new DataHandler((DataSource)ds));
        this.setContentTransferEncoding(part, contentType);
    }

    private void setContentTransferEncoding(Part part, ContentType contentType) throws MessagingException {
        part.setHeader(CONTENT_TYPE, contentType.toString());
        if (contentType.match("text/*")) {
            part.setHeader(CONTENT_TRANSFER_ENCODING, "8bit");
        } else if (this.binaryContent) {
            part.setHeader(CONTENT_TRANSFER_ENCODING, "binary");
        } else {
            part.setHeader(CONTENT_TRANSFER_ENCODING, "base64");
        }
    }

    public Object unmarshal(Exchange exchange, InputStream stream) throws IOException, MessagingException {
        String contentType;
        Message camelMessage;
        MimeBodyPart mimeMessage;
        Object content = null;
        if (this.headersInline) {
            mimeMessage = new MimeBodyPart(stream);
            camelMessage = exchange.getMessage();
            MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)camelMessage, (boolean)true);
            contentType = mimeMessage.getHeader(CONTENT_TYPE, null);
            Enumeration headersEnum = mimeMessage.getNonMatchingHeaders(STANDARD_HEADERS);
            while (headersEnum.hasMoreElements()) {
                Object ho = headersEnum.nextElement();
                if (!(ho instanceof Header)) continue;
                Header header = (Header)ho;
                camelMessage.setHeader(header.getName(), (Object)header.getValue());
            }
        } else {
            contentType = (String)exchange.getIn().getHeader(CONTENT_TYPE, String.class);
            if (contentType == null) {
                return stream;
            }
            try {
                ContentType ct = new ContentType(contentType);
                if (!ct.match("multipart/*")) {
                    return stream;
                }
            }
            catch (ParseException e) {
                LOG.warn("Invalid Content-Type {} ignored", (Object)contentType);
                return stream;
            }
            camelMessage = exchange.getMessage();
            MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)camelMessage, (boolean)true);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            IOHelper.copyAndCloseInput((InputStream)stream, (OutputStream)bos);
            InternetHeaders headers = new InternetHeaders();
            this.extractHeader(CONTENT_TYPE, camelMessage, headers);
            this.extractHeader(MIME_VERSION, camelMessage, headers);
            mimeMessage = new MimeBodyPart(headers, bos.toByteArray());
            bos.close();
        }
        try {
            DataHandler dh = mimeMessage.getDataHandler();
            if (dh != null) {
                content = dh.getContent();
                contentType = dh.getContentType();
            }
        }
        catch (MessagingException e) {
            LOG.warn("cannot parse message, no unmarshalling done");
        }
        if (content instanceof MimeMultipart) {
            MimeMultipart mp = (MimeMultipart)content;
            content = mp.getBodyPart(0);
            for (int i = 1; i < mp.getCount(); ++i) {
                BodyPart bp = mp.getBodyPart(i);
                DefaultAttachment camelAttachment = new DefaultAttachment(bp.getDataHandler());
                Enumeration headers = bp.getAllHeaders();
                while (headers.hasMoreElements()) {
                    Header header = (Header)headers.nextElement();
                    camelAttachment.addHeader(header.getName(), header.getValue());
                }
                ((AttachmentMessage)camelMessage.getExchange().getMessage(AttachmentMessage.class)).addAttachmentObject(this.getAttachmentKey(bp), (Attachment)camelAttachment);
            }
        }
        if (content instanceof BodyPart) {
            BodyPart bp = (BodyPart)content;
            camelMessage.setBody((Object)bp.getInputStream());
            contentType = bp.getContentType();
            if (contentType != null && !DEFAULT_CONTENT_TYPE.equals(contentType)) {
                camelMessage.setHeader(CONTENT_TYPE, (Object)contentType);
                ContentType ct = new ContentType(contentType);
                String charset = ct.getParameter("charset");
                if (charset != null) {
                    camelMessage.setHeader("Content-Encoding", (Object)MimeUtility.javaCharset((String)charset));
                }
            }
        } else {
            LOG.info("no MIME part found");
        }
        return camelMessage;
    }

    private void extractHeader(String headerMame, Message camelMessage, InternetHeaders headers) {
        String h = (String)camelMessage.getHeader(headerMame, String.class);
        if (h != null) {
            headers.addHeader(headerMame, h);
            camelMessage.removeHeader(headerMame);
        }
    }

    private String getAttachmentKey(BodyPart bp) throws MessagingException, UnsupportedEncodingException {
        Object key = bp.getFileName();
        if (key == null && bp instanceof MimeBodyPart && (key = ((MimeBodyPart)bp).getContentID()) != null && ((String)key).startsWith("<") && ((String)key).length() > 2) {
            key = ((String)key).substring(1, ((String)key).length() - 1);
        }
        if (key == null) {
            key = UUID.randomUUID() + "@camel.apache.org";
        }
        return MimeUtility.decodeText((String)key);
    }

    protected void doInit() throws Exception {
        if (this.includeHeaders != null) {
            this.includeHeadersPattern = Pattern.compile(this.includeHeaders, 2);
        }
    }
}

