/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mail;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class MailEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":host:port";
    private static final String[] SCHEMES = new String[]{"imap", "imaps", "pop3", "pop3s", "smtp", "smtps"};
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;
    private static final Set<String> MULTI_VALUE_PREFIXES;

    public boolean isEnabled(String scheme) {
        for (String s : SCHEMES) {
            if (!s.equals(scheme)) continue;
            return true;
        }
        return false;
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax = scheme + BASE;
        Object uri = syntax;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, (String)uri, "host", null, true, copy);
        uri = this.buildPathParameter(syntax, (String)uri, "port", null, false, copy);
        uri = this.buildQueryParameters((String)uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public Set<String> multiValuePrefixes() {
        return MULTI_VALUE_PREFIXES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(68);
        props.add("additionalJavaMailProperties");
        props.add("alternativeBodyHeader");
        props.add("attachmentsContentTransferEncodingResolver");
        props.add("authenticator");
        props.add("backoffErrorThreshold");
        props.add("backoffIdleThreshold");
        props.add("backoffMultiplier");
        props.add("bcc");
        props.add("binding");
        props.add("bridgeErrorHandler");
        props.add("cc");
        props.add("closeFolder");
        props.add("connectionTimeout");
        props.add("contentType");
        props.add("contentTypeResolver");
        props.add("copyTo");
        props.add("debugMode");
        props.add("decodeFilename");
        props.add("delay");
        props.add("delete");
        props.add("disconnect");
        props.add("exceptionHandler");
        props.add("exchangePattern");
        props.add("fetchSize");
        props.add("folderName");
        props.add("from");
        props.add("greedy");
        props.add("handleFailedMessage");
        props.add("headerFilterStrategy");
        props.add("host");
        props.add("idempotentRepository");
        props.add("idempotentRepositoryRemoveOnCommit");
        props.add("ignoreUnsupportedCharset");
        props.add("ignoreUriScheme");
        props.add("initialDelay");
        props.add("javaMailProperties");
        props.add("javaMailSender");
        props.add("lazyStartProducer");
        props.add("mailUidGenerator");
        props.add("mapMailMessage");
        props.add("maxMessagesPerPoll");
        props.add("mimeDecodeHeaders");
        props.add("moveTo");
        props.add("password");
        props.add("peek");
        props.add("pollStrategy");
        props.add("port");
        props.add("postProcessAction");
        props.add("repeatCount");
        props.add("replyTo");
        props.add("runLoggingLevel");
        props.add("scheduledExecutorService");
        props.add("scheduler");
        props.add("schedulerProperties");
        props.add("searchTerm");
        props.add("sendEmptyMessageWhenIdle");
        props.add("session");
        props.add("skipFailedMessage");
        props.add("sortTerm");
        props.add("sslContextParameters");
        props.add("startScheduler");
        props.add("subject");
        props.add("timeUnit");
        props.add("to");
        props.add("unseen");
        props.add("useFixedDelay");
        props.add("useInlineAttachments");
        props.add("username");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(2);
        secretProps.add("password");
        secretProps.add("username");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
        HashSet<String> prefixes = new HashSet<String>(3);
        prefixes.add("mail.");
        prefixes.add("scheduler.");
        prefixes.add("searchTerm.");
        MULTI_VALUE_PREFIXES = Collections.unmodifiableSet(prefixes);
    }
}

