/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mail;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.Session;
import javax.net.ssl.SSLContext;
import org.apache.camel.CamelContext;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.mail.DefaultAuthenticator;
import org.apache.camel.component.mail.DefaultJavaMailSender;
import org.apache.camel.component.mail.JavaMailSender;
import org.apache.camel.component.mail.MailUtils;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.jsse.SSLContextParameters;

@UriParams
public class MailConfiguration
implements Cloneable {
    private ClassLoader applicationClassLoader;
    private Session session;
    private Properties javaMailProperties;
    private Map<Message.RecipientType, String> recipients = new HashMap<Message.RecipientType, String>();
    private String protocol;
    @UriPath
    @Metadata(required="true")
    private String host;
    @UriPath
    private int port = -1;
    @UriParam(label="security")
    private String username;
    @UriParam(label="security")
    private String password;
    @UriParam
    @Metadata(label="producer")
    private String subject;
    @UriParam
    @Metadata(label="producer,advanced")
    private JavaMailSender javaMailSender;
    @UriParam(defaultValue="true", label="consumer,advanced")
    private boolean mapMailMessage = true;
    @UriParam(defaultValue="camel@localhost", label="producer")
    private String from = "camel@localhost";
    @UriParam(label="producer")
    private String to;
    @UriParam(label="producer")
    private String cc;
    @UriParam(label="producer")
    private String bcc;
    @UriParam(defaultValue="INBOX", label="consumer,advanced")
    private String folderName = "INBOX";
    @UriParam
    @Metadata(label="consumer")
    private boolean delete;
    @UriParam
    @Metadata(label="consumer")
    private String copyTo;
    @UriParam(defaultValue="true")
    @Metadata(label="consumer")
    private boolean unseen = true;
    @UriParam(label="advanced")
    private boolean ignoreUriScheme;
    @UriParam
    @Metadata(label="producer")
    private String replyTo;
    @UriParam(defaultValue="-1")
    @Metadata(label="consumer,advanced")
    private int fetchSize = -1;
    @UriParam(label="advanced")
    private boolean debugMode;
    @UriParam(defaultValue="30000", label="advanced")
    private int connectionTimeout = 30000;
    @UriParam(label="security")
    private boolean dummyTrustManager;
    @UriParam(defaultValue="text/plain", label="advanced")
    private String contentType = "text/plain";
    @UriParam(defaultValue="CamelMailAlternativeBody", label="advanced")
    private String alternativeBodyHeader = "CamelMailAlternativeBody";
    @UriParam(label="advanced")
    private boolean useInlineAttachments;
    @UriParam(label="advanced")
    private boolean ignoreUnsupportedCharset;
    @UriParam
    @Metadata(label="consumer")
    private boolean disconnect;
    @UriParam(defaultValue="true")
    @Metadata(label="consumer")
    private boolean closeFolder = true;
    @UriParam(defaultValue="true")
    @Metadata(label="consumer")
    private boolean peek = true;
    @UriParam
    @Metadata(label="consumer")
    private boolean skipFailedMessage;
    @UriParam
    @Metadata(label="consumer")
    private boolean handleFailedMessage;
    @UriParam(label="security")
    private SSLContextParameters sslContextParameters;
    @UriParam(label="advanced", prefix="mail.", multiValue=true)
    private Properties additionalJavaMailProperties;

    public MailConfiguration() {
    }

    public MailConfiguration(CamelContext context) {
        this.applicationClassLoader = context.getApplicationContextClassLoader();
    }

    public MailConfiguration copy() {
        try {
            MailConfiguration copy = (MailConfiguration)this.clone();
            copy.recipients = new HashMap<Message.RecipientType, String>();
            copy.recipients.putAll(this.recipients);
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    public void configure(URI uri) {
        int port;
        String userInfo;
        String scheme;
        String value = uri.getHost();
        if (value != null) {
            this.setHost(value);
        }
        if (!this.isIgnoreUriScheme() && (scheme = uri.getScheme()) != null) {
            this.setProtocol(scheme);
        }
        if ((userInfo = uri.getUserInfo()) != null) {
            String[] parts = uri.getUserInfo().split(":");
            if (parts.length == 2) {
                this.setUsername(parts[0]);
                this.setPassword(parts[1]);
            } else {
                this.setUsername(userInfo);
            }
        }
        if ((port = uri.getPort()) > 0) {
            this.setPort(port);
        } else if (port <= 0 && this.port <= 0) {
            this.setPort(MailUtils.getDefaultPortForProtocol(uri.getScheme()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JavaMailSender createJavaMailSender() {
        DefaultJavaMailSender answer = new DefaultJavaMailSender();
        if (this.javaMailProperties != null) {
            answer.setJavaMailProperties(this.javaMailProperties);
        } else {
            answer.setJavaMailProperties(this.createJavaMailProperties());
            if (this.additionalJavaMailProperties != null) {
                answer.getJavaMailProperties().putAll((Map<?, ?>)this.additionalJavaMailProperties);
            }
        }
        if (this.host != null) {
            answer.setHost(this.host);
        }
        if (this.port >= 0) {
            answer.setPort(this.port);
        }
        if (this.username != null) {
            answer.setUsername(this.username);
        }
        if (this.password != null) {
            answer.setPassword(this.password);
        }
        if (this.protocol != null) {
            answer.setProtocol(this.protocol);
        }
        if (this.session != null) {
            answer.setSession(this.session);
        } else {
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            try {
                if (this.applicationClassLoader != null) {
                    Thread.currentThread().setContextClassLoader(this.applicationClassLoader);
                }
                Session session = Session.getInstance((Properties)answer.getJavaMailProperties(), (Authenticator)new DefaultAuthenticator(this.getUsername(), this.getPassword()));
                session.setDebug(this.debugMode);
                answer.setSession(session);
            }
            finally {
                Thread.currentThread().setContextClassLoader(tccl);
            }
        }
        return answer;
    }

    private Properties createJavaMailProperties() {
        Properties properties = (Properties)System.getProperties().clone();
        properties.put("mail." + this.protocol + ".connectiontimeout", (Object)this.connectionTimeout);
        properties.put("mail." + this.protocol + ".timeout", (Object)this.connectionTimeout);
        properties.put("mail." + this.protocol + ".host", this.host);
        properties.put("mail." + this.protocol + ".port", "" + this.port);
        if (this.username != null) {
            properties.put("mail." + this.protocol + ".user", this.username);
            properties.put("mail.user", this.username);
            properties.put("mail." + this.protocol + ".auth", "true");
        } else {
            properties.put("mail." + this.protocol + ".auth", "false");
        }
        properties.put("mail.transport.protocol", this.protocol);
        properties.put("mail.store.protocol", this.protocol);
        properties.put("mail.host", this.host);
        if (this.debugMode) {
            properties.put("javax.net.debug", "all");
        }
        if (this.sslContextParameters != null && (this.isSecureProtocol() || this.isStartTlsEnabled())) {
            SSLContext sslContext;
            try {
                sslContext = this.sslContextParameters.createSSLContext();
            }
            catch (Exception e) {
                throw new RuntimeCamelException("Error initializing SSLContext.", (Throwable)e);
            }
            properties.put("mail." + this.protocol + ".socketFactory", sslContext.getSocketFactory());
            properties.put("mail." + this.protocol + ".socketFactory.fallback", "false");
            properties.put("mail." + this.protocol + ".socketFactory.port", "" + this.port);
        }
        if (this.dummyTrustManager && (this.isSecureProtocol() || this.isStartTlsEnabled())) {
            properties.put("mail." + this.protocol + ".socketFactory.class", "org.apache.camel.component.mail.DummySSLSocketFactory");
            properties.put("mail." + this.protocol + ".socketFactory.fallback", "false");
            properties.put("mail." + this.protocol + ".socketFactory.port", "" + this.port);
        }
        return properties;
    }

    public boolean isSecureProtocol() {
        return this.protocol.equalsIgnoreCase("smtps") || this.protocol.equalsIgnoreCase("pop3s") || this.protocol.equalsIgnoreCase("imaps");
    }

    public boolean isStartTlsEnabled() {
        if (this.additionalJavaMailProperties != null) {
            return ObjectHelper.equal((Object)this.additionalJavaMailProperties.getProperty("mail." + this.protocol + ".starttls.enable"), (Object)"true", (boolean)true);
        }
        return false;
    }

    public String getMailStoreLogInformation() {
        String ssl = "";
        if (this.isSecureProtocol()) {
            ssl = " (SSL enabled" + (this.dummyTrustManager ? " using DummyTrustManager)" : ")");
        }
        return this.protocol + "://" + this.host + ":" + this.port + ssl + ", folder=" + this.folderName;
    }

    public JavaMailSender getJavaMailSender() {
        return this.javaMailSender;
    }

    public void setJavaMailSender(JavaMailSender javaMailSender) {
        this.javaMailSender = javaMailSender;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Properties getJavaMailProperties() {
        return this.javaMailProperties;
    }

    public void setJavaMailProperties(Properties javaMailProperties) {
        this.javaMailProperties = javaMailProperties;
    }

    public Properties getAdditionalJavaMailProperties() {
        if (this.additionalJavaMailProperties == null) {
            this.additionalJavaMailProperties = new Properties();
        }
        return this.additionalJavaMailProperties;
    }

    public void setAdditionalJavaMailProperties(Properties additionalJavaMailProperties) {
        this.additionalJavaMailProperties = additionalJavaMailProperties;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
        if (this.getRecipients().size() == 0) {
            String address = username;
            if (address.indexOf("@") == -1) {
                address = address + "@" + this.host;
            }
            this.setTo(address);
        }
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public boolean isDelete() {
        return this.delete;
    }

    public void setDelete(boolean delete) {
        this.delete = delete;
    }

    public boolean isMapMailMessage() {
        return this.mapMailMessage;
    }

    public void setMapMailMessage(boolean mapMailMessage) {
        this.mapMailMessage = mapMailMessage;
    }

    public String getFolderName() {
        return this.folderName;
    }

    public void setFolderName(String folderName) {
        this.folderName = folderName;
    }

    public boolean isIgnoreUriScheme() {
        return this.ignoreUriScheme;
    }

    public void setIgnoreUriScheme(boolean ignoreUriScheme) {
        this.ignoreUriScheme = ignoreUriScheme;
    }

    public boolean isUnseen() {
        return this.unseen;
    }

    public void setUnseen(boolean unseen) {
        this.unseen = unseen;
    }

    public void setTo(String address) {
        this.to = this.to;
        this.recipients.put(Message.RecipientType.TO, address);
    }

    public String getTo() {
        return this.to;
    }

    public void setCc(String address) {
        this.cc = address;
        this.recipients.put(Message.RecipientType.CC, address);
    }

    public String getCc() {
        return this.cc;
    }

    public void setBcc(String address) {
        this.bcc = address;
        this.recipients.put(Message.RecipientType.BCC, address);
    }

    public String getBcc() {
        return this.bcc;
    }

    public Map<Message.RecipientType, String> getRecipients() {
        return this.recipients;
    }

    public String getReplyTo() {
        return this.replyTo;
    }

    public void setReplyTo(String replyTo) {
        this.replyTo = replyTo;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    public long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public boolean isDummyTrustManager() {
        return this.dummyTrustManager;
    }

    public void setDummyTrustManager(boolean dummyTrustManager) {
        this.dummyTrustManager = dummyTrustManager;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getAlternativeBodyHeader() {
        return this.alternativeBodyHeader;
    }

    public void setAlternativeBodyHeader(String alternativeBodyHeader) {
        this.alternativeBodyHeader = alternativeBodyHeader;
    }

    public boolean isUseInlineAttachments() {
        return this.useInlineAttachments;
    }

    public void setUseInlineAttachments(boolean useInlineAttachments) {
        this.useInlineAttachments = useInlineAttachments;
    }

    public boolean isIgnoreUnsupportedCharset() {
        return this.ignoreUnsupportedCharset;
    }

    public void setIgnoreUnsupportedCharset(boolean ignoreUnsupportedCharset) {
        this.ignoreUnsupportedCharset = ignoreUnsupportedCharset;
    }

    public boolean isDisconnect() {
        return this.disconnect;
    }

    public void setDisconnect(boolean disconnect) {
        this.disconnect = disconnect;
    }

    public boolean isCloseFolder() {
        return this.closeFolder;
    }

    public void setCloseFolder(boolean closeFolder) {
        this.closeFolder = closeFolder;
    }

    public SSLContextParameters getSslContextParameters() {
        return this.sslContextParameters;
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }

    public String getCopyTo() {
        return this.copyTo;
    }

    public void setCopyTo(String copyTo) {
        this.copyTo = copyTo;
    }

    public boolean isPeek() {
        return this.peek;
    }

    public void setPeek(boolean peek) {
        this.peek = peek;
    }

    public boolean isSkipFailedMessage() {
        return this.skipFailedMessage;
    }

    public void setSkipFailedMessage(boolean skipFailedMessage) {
        this.skipFailedMessage = skipFailedMessage;
    }

    public boolean isHandleFailedMessage() {
        return this.handleFailedMessage;
    }

    public void setHandleFailedMessage(boolean handleFailedMessage) {
        this.handleFailedMessage = handleFailedMessage;
    }
}

