/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mail;

import java.util.Iterator;
import java.util.Map;
import javax.activation.DataHandler;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.mail.MailEndpoint;
import org.apache.camel.component.mail.MailExchange;
import org.apache.camel.converter.ObjectConverter;

public class MailBinding {
    public void populateMailMessage(MailEndpoint endpoint, MimeMessage mimeMessage, Exchange exchange) throws MessagingException {
        this.appendHeadersFromCamel(mimeMessage, exchange, exchange.getIn());
        Map<Message.RecipientType, String> recipients = endpoint.getConfiguration().getRecipients();
        if (recipients.containsKey(Message.RecipientType.TO)) {
            mimeMessage.setRecipients(Message.RecipientType.TO, recipients.get(Message.RecipientType.TO));
        }
        if (recipients.containsKey(Message.RecipientType.CC)) {
            mimeMessage.setRecipients(Message.RecipientType.CC, recipients.get(Message.RecipientType.CC));
        }
        if (recipients.containsKey(Message.RecipientType.BCC)) {
            mimeMessage.setRecipients(Message.RecipientType.BCC, recipients.get(Message.RecipientType.BCC));
        }
        if (mimeMessage.getAllRecipients() == null) {
            throw new IllegalArgumentException("The mail message does not have any recipients set.");
        }
        if (MailBinding.empty(mimeMessage.getFrom())) {
            String from = endpoint.getConfiguration().getFrom();
            mimeMessage.setFrom((Address)new InternetAddress(from));
        }
        if (exchange.getIn().hasAttachments()) {
            this.appendAttachmentsFromCamel(mimeMessage, exchange, exchange.getIn());
        } else {
            mimeMessage.setText((String)exchange.getIn().getBody(String.class));
        }
    }

    public Object extractBodyFromMail(MailExchange exchange, javax.mail.Message message) {
        try {
            return message.getContent();
        }
        catch (Exception e) {
            throw new RuntimeCamelException("Failed to extract body due to: " + e.getMessage() + ". Exchange: " + (Object)((Object)exchange) + ". Message: " + message, (Throwable)e);
        }
    }

    protected void appendHeadersFromCamel(MimeMessage mimeMessage, Exchange exchange, Message camelMessage) throws MessagingException {
        for (Map.Entry entry : camelMessage.getHeaders().entrySet()) {
            String headerName = (String)entry.getKey();
            Object headerValue = entry.getValue();
            if (headerValue == null || !this.shouldOutputHeader(camelMessage, headerName, headerValue)) continue;
            if (ObjectConverter.isCollection(headerValue)) {
                Iterator iter = ObjectConverter.iterator(headerValue);
                while (iter.hasNext()) {
                    Object value = iter.next();
                    mimeMessage.addHeader(headerName, MailBinding.asString(exchange, value));
                }
                continue;
            }
            mimeMessage.setHeader(headerName, MailBinding.asString(exchange, headerValue));
        }
    }

    protected void appendAttachmentsFromCamel(MimeMessage mimeMessage, Exchange exchange, Message camelMessage) throws MessagingException {
        MimeMultipart multipart = new MimeMultipart();
        multipart.setSubType("mixed");
        MimeBodyPart textBodyPart = new MimeBodyPart();
        textBodyPart.setContent(exchange.getIn().getBody(String.class), "text/plain");
        multipart.addBodyPart((BodyPart)textBodyPart);
        for (Map.Entry entry : camelMessage.getAttachments().entrySet()) {
            String attachmentFilename = (String)entry.getKey();
            DataHandler handler = (DataHandler)entry.getValue();
            if (handler == null || !this.shouldOutputAttachment(camelMessage, attachmentFilename, handler)) continue;
            MimeBodyPart messageBodyPart = new MimeBodyPart();
            messageBodyPart.setDataHandler(handler);
            messageBodyPart.setFileName(attachmentFilename);
            messageBodyPart.setDisposition("attachment");
            multipart.addBodyPart((BodyPart)messageBodyPart);
        }
        mimeMessage.setContent((Multipart)multipart);
    }

    protected boolean shouldOutputHeader(Message camelMessage, String headerName, Object headerValue) {
        return true;
    }

    protected boolean shouldOutputAttachment(Message camelMessage, String attachmentFilename, DataHandler handler) {
        return true;
    }

    private static boolean empty(Address[] addresses) {
        return addresses == null || addresses.length == 0;
    }

    private static String asString(Exchange exchange, Object value) {
        return (String)exchange.getContext().getTypeConverter().convertTo(String.class, value);
    }
}

