/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.service.lra;

import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.service.lra.LRASagaService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LRASagaRoutes
extends RouteBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(LRASagaRoutes.class);
    private final LRASagaService sagaService;

    public LRASagaRoutes(LRASagaService sagaService) {
        this.sagaService = sagaService;
    }

    public void configure() throws Exception {
        this.rest(this.sagaService.getLocalParticipantContextPath()).put("/compensate").to("direct:lra-compensation");
        ((ChoiceDefinition)((RouteDefinition)this.from("direct:lra-compensation").routeId("lra-compensation").process(this::verifyRequest)).choice().when(this.header("Camel-Saga-Compensate").isNotNull()).toD("${header.Camel-Saga-Compensate}")).end();
        this.rest(this.sagaService.getLocalParticipantContextPath()).put("/complete").to("direct:lra-completion");
        ((ChoiceDefinition)((RouteDefinition)this.from("direct:lra-completion").routeId("lra-completion").process(this::verifyRequest)).choice().when(this.header("Camel-Saga-Complete").isNotNull()).toD("${header.Camel-Saga-Complete}")).end();
    }

    private Map<String, String> parseQuery(String queryStr) {
        Map<String, String> result;
        if (queryStr != null && !queryStr.isEmpty()) {
            result = Arrays.stream(queryStr.split("&")).collect(Collectors.toMap(element -> this.decode(this.saveArrayAccess(element.split("="), 0)), element -> this.decode(this.saveArrayAccess(element.split("="), 1))));
        } else {
            LOG.debug("query param is empty, nothing to parse.");
            result = new HashMap<String, String>();
        }
        return result;
    }

    private String saveArrayAccess(String[] keyValuePair, int index) {
        try {
            return keyValuePair[index];
        }
        catch (Exception ex) {
            LOG.warn("unable to read array index '{}' from '{}'", new Object[]{index, keyValuePair, ex});
            return "";
        }
    }

    private String decode(String encodedString) {
        return URLDecoder.decode(encodedString, StandardCharsets.UTF_8);
    }

    private void verifyRequest(Exchange exchange) {
        Map<String, String> queryParams;
        String completionURI;
        if (exchange.getIn().getHeader("Long-Running-Action") == null) {
            throw new IllegalArgumentException("Missing Long-Running-Action header in received request");
        }
        HashSet<String> usedURIs = new HashSet<String>();
        String compensationURI = (String)exchange.getIn().getHeader("Camel-Saga-Compensate", String.class);
        if (compensationURI != null) {
            usedURIs.add(compensationURI);
        }
        if ((completionURI = (String)exchange.getIn().getHeader("Camel-Saga-Complete", String.class)) != null) {
            usedURIs.add(completionURI);
        }
        if (usedURIs.isEmpty() && !(queryParams = this.parseQuery((String)exchange.getIn().getHeader("CamelHttpQuery", String.class))).isEmpty()) {
            if (queryParams.get("Camel-Saga-Compensate") != null) {
                compensationURI = queryParams.get("Camel-Saga-Compensate");
                usedURIs.add(compensationURI);
                exchange.getIn().setHeader("Camel-Saga-Compensate", (Object)compensationURI);
            }
            if (queryParams.get("Camel-Saga-Complete") != null) {
                completionURI = queryParams.get("Camel-Saga-Complete");
                usedURIs.add(completionURI);
                exchange.getIn().setHeader("Camel-Saga-Complete", (Object)completionURI);
            }
        }
        for (String uri : usedURIs) {
            if (this.sagaService.getRegisteredURIs().contains(uri)) continue;
            throw new IllegalArgumentException("URI " + uri + " is not allowed");
        }
    }
}

