/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ldap;

import java.util.ArrayList;
import javax.naming.NamingEnumeration;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.ldap.LdapEndpoint;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.impl.DefaultProducer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapProducer<E extends Exchange>
extends DefaultProducer<DefaultExchange> {
    private static final transient Log LOG = LogFactory.getLog(LdapProducer.class);
    private DirContext ldapContext;
    private SearchControls controls;
    private String searchBase;

    public LdapProducer(LdapEndpoint endpoint, String remaining, String base, int scope) throws Exception {
        super((Endpoint)endpoint);
        this.ldapContext = (DirContext)this.getEndpoint().getCamelContext().getRegistry().lookup(remaining);
        this.searchBase = base;
        this.controls = new SearchControls();
        this.controls.setSearchScope(scope);
    }

    public void process(Exchange exchange) throws Exception {
        String filter = (String)exchange.getIn().getBody(String.class);
        ArrayList<SearchResult> data = new ArrayList<SearchResult>();
        NamingEnumeration<SearchResult> namingEnumeration = this.ldapContext.search(this.searchBase, filter, this.getControls());
        while (namingEnumeration.hasMore()) {
            data.add(namingEnumeration.next());
        }
        exchange.getOut().setBody(data);
    }

    public DirContext getDirContext() {
        return this.ldapContext;
    }

    protected SearchControls getControls() {
        return this.controls;
    }
}

