/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.language;

import java.io.Closeable;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.component.language.LanguageEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.IOHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LanguageProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(LanguageProducer.class);

    public LanguageProducer(LanguageEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Exchange exchange) throws Exception {
        Object result;
        String script = null;
        Expression exp = (Expression)exchange.getIn().getHeader("CamelLanguageScript", Expression.class);
        if (exp == null && (script = (String)exchange.getIn().getHeader("CamelLanguageScript", String.class)) != null) {
            script = this.getEndpoint().resolveScript(script);
            exp = this.getEndpoint().getLanguage().createExpression(script);
        }
        if (exp == null && this.getEndpoint().isCacheScript()) {
            exp = this.getEndpoint().getExpression();
        }
        Object is = null;
        if (exp == null) {
            script = this.getEndpoint().getScript();
            if (script == null && this.getEndpoint().getResourceUri() == null) {
                throw new CamelExchangeException("No script to evaluate", exchange);
            }
            if (script == null) {
                is = this.getEndpoint().getResourceAsInputStream();
            } else if (ResourceHelper.hasScheme((String)script)) {
                is = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)this.getEndpoint().getCamelContext(), (String)script);
            } else if (EndpointHelper.isReferenceParameter((String)script)) {
                String ref = "ref:" + script.substring(1);
                is = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)this.getEndpoint().getCamelContext(), (String)ref);
            }
            if (is != null && !this.getEndpoint().isBinary()) {
                try {
                    script = (String)this.getEndpoint().getCamelContext().getTypeConverter().convertTo(String.class, exchange, is);
                }
                finally {
                    IOHelper.close((Closeable)is);
                }
            }
        }
        if (script != null) {
            exp = this.getEndpoint().getLanguage().createExpression(script);
            this.getEndpoint().setContentResolvedFromResource(true);
            if (this.getEndpoint().isCacheScript()) {
                this.getEndpoint().setExpression(exp);
            }
        }
        if (exp != null) {
            try {
                result = exp.evaluate(exchange, Object.class);
                LOG.debug("Evaluated expression as: {} with: {}", result, (Object)exchange);
            }
            finally {
                if (!this.getEndpoint().isCacheScript()) {
                    ServiceHelper.stopService((Object)exp);
                    this.getEndpoint().getCamelContext().removeService((Object)exp);
                }
            }
        } else {
            result = is;
        }
        if (this.getEndpoint().isTransform()) {
            exchange.getMessage().setBody(result);
        }
    }

    public LanguageEndpoint getEndpoint() {
        return (LanguageEndpoint)super.getEndpoint();
    }
}

