/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.langchain4j.chat.openai;

import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.openai.OpenAiChatModel;
import java.time.Duration;

public final class OpenAiChatLanguageModelBuilder {
    private String apiKey;
    private String modelName;
    private long timeout;
    private int maxRetries;
    private boolean logRequests;
    private boolean logResponses;
    private Double temperature;

    public OpenAiChatLanguageModelBuilder apiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    public OpenAiChatLanguageModelBuilder modelName(String modelName) {
        this.modelName = modelName;
        return this;
    }

    public OpenAiChatLanguageModelBuilder timeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    public OpenAiChatLanguageModelBuilder maxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
        return this;
    }

    public OpenAiChatLanguageModelBuilder logRequests(boolean logRequests) {
        this.logRequests = logRequests;
        return this;
    }

    public OpenAiChatLanguageModelBuilder logResponses(boolean logResponses) {
        this.logResponses = logResponses;
        return this;
    }

    public OpenAiChatLanguageModelBuilder temperature(Double temperature) {
        this.temperature = temperature;
        return this;
    }

    public ChatModel build() {
        return OpenAiChatModel.builder().apiKey(this.apiKey).modelName(this.modelName).timeout(Duration.ofSeconds(this.timeout)).maxRetries(Integer.valueOf(this.maxRetries)).logRequests(Boolean.valueOf(this.logRequests)).logRequests(Boolean.valueOf(this.logResponses)).temperature(this.temperature).build();
    }
}

