/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.langchain4j.agent;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.service.tool.ToolExecutor;
import dev.langchain4j.service.tool.ToolProvider;
import dev.langchain4j.service.tool.ToolProviderResult;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadRuntimeException;
import org.apache.camel.component.langchain4j.agent.LangChain4jAgentEndpoint;
import org.apache.camel.component.langchain4j.agent.ToolsTagsHelper;
import org.apache.camel.component.langchain4j.agent.api.Agent;
import org.apache.camel.component.langchain4j.agent.api.AgentFactory;
import org.apache.camel.component.langchain4j.agent.api.AiAgentBody;
import org.apache.camel.component.langchain4j.tools.spec.CamelToolExecutorCache;
import org.apache.camel.component.langchain4j.tools.spec.CamelToolSpecification;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LangChain4jAgentProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(LangChain4jAgentProducer.class);
    private final LangChain4jAgentEndpoint endpoint;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private AgentFactory agentFactory;

    public LangChain4jAgentProducer(LangChain4jAgentEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    public void process(Exchange exchange) throws Exception {
        Object messagePayload = exchange.getIn().getBody();
        ObjectHelper.notNull((Object)messagePayload, (String)"body");
        Agent agent = this.agentFactory != null ? this.agentFactory.createAgent() : this.endpoint.getConfiguration().getAgent();
        AiAgentBody aiAgentBody = this.processBody(messagePayload, exchange);
        String tags = this.endpoint.getConfiguration().getTags();
        ToolProvider toolProvider = this.createCamelToolProvider(tags, exchange);
        String response = agent.chat(aiAgentBody, toolProvider);
        exchange.getMessage().setBody((Object)response);
    }

    private AiAgentBody processBody(Object messagePayload, Exchange exchange) {
        if (messagePayload instanceof AiAgentBody) {
            return (AiAgentBody)messagePayload;
        }
        if (!(messagePayload instanceof String)) {
            throw new InvalidPayloadRuntimeException(exchange, AiAgentBody.class);
        }
        String systemMessage = (String)exchange.getIn().getHeader("CamelLangChain4jAgentSystemMessage", String.class);
        Object memoryId = exchange.getIn().getHeader("CamelLangChain4jAgentMemoryId");
        return new AiAgentBody((String)messagePayload, systemMessage, memoryId);
    }

    private ToolProvider createCamelToolProvider(String tags, Exchange exchange) {
        ToolProvider toolProvider = null;
        if (tags != null && !tags.trim().isEmpty()) {
            Map<String, CamelToolSpecification> availableTools = this.discoverToolsByName(tags);
            if (!availableTools.isEmpty()) {
                LOG.debug("Creating AI Service with {} tools for tags: {}", (Object)availableTools.size(), (Object)tags);
                toolProvider = this.createCamelToolProvider(availableTools, exchange);
            } else {
                LOG.debug("No tools found for tags: {}, using simple AI Service", (Object)tags);
            }
        }
        return toolProvider;
    }

    private ToolProvider createCamelToolProvider(Map<String, CamelToolSpecification> availableTools, Exchange exchange) {
        return toolProviderRequest -> {
            ToolProviderResult.Builder resultBuilder = ToolProviderResult.builder();
            for (Map.Entry entry : availableTools.entrySet()) {
                String toolName = (String)entry.getKey();
                CamelToolSpecification camelToolSpec = (CamelToolSpecification)entry.getValue();
                ToolSpecification toolSpecification = camelToolSpec.getToolSpecification();
                ToolExecutor toolExecutor = (toolExecutionRequest, memoryId) -> {
                    LOG.info("Executing Camel route tool: '{}' with arguments: {}", (Object)toolName, (Object)toolExecutionRequest.arguments());
                    try {
                        String arguments = toolExecutionRequest.arguments();
                        if (arguments != null && !arguments.trim().isEmpty()) {
                            JsonNode jsonNode = (JsonNode)this.objectMapper.readValue(arguments, JsonNode.class);
                            jsonNode.fieldNames().forEachRemaining(name -> exchange.getMessage().setHeader(name, (Object)jsonNode.get(name)));
                        }
                        exchange.getMessage().setHeader("CamelToolName", (Object)toolName);
                        camelToolSpec.getConsumer().getProcessor().process(exchange);
                        String result = (String)exchange.getIn().getBody(String.class);
                        LOG.info("Tool '{}' execution completed successfully", (Object)toolName);
                        return result != null ? result : "No result";
                    }
                    catch (Exception e) {
                        LOG.error("Error executing tool '{}': {}", new Object[]{toolName, e.getMessage(), e});
                        return String.format("Error executing tool '%s': %s", toolName, e.getMessage());
                    }
                };
                resultBuilder.add(toolSpecification, toolExecutor);
                LOG.info("Added dynamic tool: '{}' - {}", (Object)toolSpecification.name(), (Object)toolSpecification.description());
            }
            return resultBuilder.build();
        };
    }

    private Map<String, CamelToolSpecification> discoverToolsByName(String tags) {
        CamelToolExecutorCache toolCache = CamelToolExecutorCache.getInstance();
        Map tools = toolCache.getTools();
        String[] tagArray = ToolsTagsHelper.splitTags(tags);
        Map<String, CamelToolSpecification> toolsByName = Arrays.stream(tagArray).flatMap(tag -> tools.entrySet().stream().filter(entry -> ((String)entry.getKey()).equals(tag)).flatMap(entry -> ((Set)entry.getValue()).stream())).collect(Collectors.toMap(camelToolSpec -> camelToolSpec.getToolSpecification().name(), camelToolSpec -> camelToolSpec, (existing, replacement) -> existing));
        LOG.info("Discovered {} unique tools for tags: {}", (Object)toolsByName.size(), (Object)tags);
        return toolsByName;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.agentFactory = this.endpoint.getConfiguration().getAgentFactory();
        if (this.agentFactory != null) {
            this.agentFactory.setCamelContext(this.endpoint.getCamelContext());
        }
    }
}

