/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.langchain4j.agent;

import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.langchain4j.agent.Headers;
import org.apache.camel.component.langchain4j.agent.LangChain4jAgentConfiguration;
import org.apache.camel.component.langchain4j.agent.LangChain4jAgentProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;

@UriEndpoint(firstVersion="4.14.0", scheme="langchain4j-agent", title="LangChain4j Agent", syntax="langchain4j-agent:agentId", producerOnly=true, category={Category.AI}, headersClass=Headers.class)
public class LangChain4jAgentEndpoint
extends DefaultEndpoint {
    @Metadata(required=true)
    @UriPath(description="The Agent id")
    private final String agentId;
    @UriParam
    private LangChain4jAgentConfiguration configuration;

    public LangChain4jAgentEndpoint(String endpointUri, Component component, String agentId, LangChain4jAgentConfiguration configuration) {
        super(endpointUri, component);
        this.agentId = agentId;
        this.configuration = configuration;
    }

    public Producer createProducer() throws Exception {
        return new LangChain4jAgentProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Consumer not supported");
    }

    public String getAgentId() {
        return this.agentId;
    }

    public LangChain4jAgentConfiguration getConfiguration() {
        return this.configuration;
    }
}

