/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.langchain4j.agent.api;

import dev.langchain4j.memory.chat.ChatMemoryProvider;
import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.rag.RetrievalAugmentor;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(AgentConfiguration.class);
    private ChatModel chatModel;
    private ChatMemoryProvider chatMemoryProvider;
    private RetrievalAugmentor retrievalAugmentor;
    private List<Class<?>> inputGuardrailClasses;
    private List<Class<?>> outputGuardrailClasses;
    private List<Object> customTools;

    public ChatModel getChatModel() {
        return this.chatModel;
    }

    public AgentConfiguration withChatModel(ChatModel chatModel) {
        this.chatModel = chatModel;
        return this;
    }

    public ChatMemoryProvider getChatMemoryProvider() {
        return this.chatMemoryProvider;
    }

    public AgentConfiguration withChatMemoryProvider(ChatMemoryProvider chatMemoryProvider) {
        this.chatMemoryProvider = chatMemoryProvider;
        return this;
    }

    public RetrievalAugmentor getRetrievalAugmentor() {
        return this.retrievalAugmentor;
    }

    public AgentConfiguration withRetrievalAugmentor(RetrievalAugmentor retrievalAugmentor) {
        this.retrievalAugmentor = retrievalAugmentor;
        return this;
    }

    public List<Class<?>> getInputGuardrailClasses() {
        return this.inputGuardrailClasses;
    }

    public AgentConfiguration withInputGuardrailClassesList(String inputGuardrailClasses) {
        return this.withInputGuardrailClasses(AgentConfiguration.parseGuardrailClasses(inputGuardrailClasses));
    }

    public AgentConfiguration withInputGuardrailClassesArray(String[] inputGuardrailClasses) {
        return this.withInputGuardrailClasses(AgentConfiguration.parseGuardrailClasses(inputGuardrailClasses));
    }

    public AgentConfiguration withInputGuardrailClasses(List<Class<?>> inputGuardrailClasses) {
        this.inputGuardrailClasses = inputGuardrailClasses;
        return this;
    }

    public List<Class<?>> getOutputGuardrailClasses() {
        return this.outputGuardrailClasses;
    }

    public AgentConfiguration withOutputGuardrailClassesList(String outputGuardrailClasses) {
        return this.withOutputGuardrailClasses(AgentConfiguration.parseGuardrailClasses(outputGuardrailClasses));
    }

    public AgentConfiguration withOutputGuardrailClassesArray(String[] outputGuardrailClasses) {
        return this.withOutputGuardrailClasses(AgentConfiguration.parseGuardrailClasses(outputGuardrailClasses));
    }

    public AgentConfiguration withOutputGuardrailClasses(List<Class<?>> outputGuardrailClasses) {
        this.outputGuardrailClasses = outputGuardrailClasses;
        return this;
    }

    public static List<Class<?>> parseGuardrailClasses(String guardrailClassNames) {
        if (guardrailClassNames == null || guardrailClassNames.trim().isEmpty()) {
            return Collections.emptyList();
        }
        return AgentConfiguration.parseGuardrailClasses(guardrailClassNames.split(","));
    }

    public static List<Class<?>> parseGuardrailClasses(String[] guardrailClassNames) {
        if (guardrailClassNames == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(guardrailClassNames).map(String::trim).filter(name -> !name.isEmpty()).map(AgentConfiguration::loadGuardrailClass).filter(clazz -> clazz != null).collect(Collectors.toList());
    }

    public List<Object> getCustomTools() {
        return this.customTools;
    }

    public AgentConfiguration withCustomTools(List<Object> customTools) {
        this.customTools = customTools;
        return this;
    }

    protected static Class<?> loadGuardrailClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            LOG.warn("Failed to load guardrail class: {}", (Object)className, (Object)e);
            return null;
        }
    }
}

