/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.hpa;

import io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscaler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.kubernetes.AbstractKubernetesEndpoint;
import org.apache.camel.component.kubernetes.KubernetesHelper;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesHPAConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesHPAConsumer.class);
    private final Processor processor;
    private ExecutorService executor;
    private HpaConsumerTask hpasWatcher;

    public KubernetesHPAConsumer(AbstractKubernetesEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.processor = processor;
    }

    public AbstractKubernetesEndpoint getEndpoint() {
        return (AbstractKubernetesEndpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.executor = this.getEndpoint().createExecutor((Object)this);
        this.hpasWatcher = new HpaConsumerTask();
        this.executor.submit(this.hpasWatcher);
    }

    protected void doStop() throws Exception {
        super.doStop();
        LOG.debug("Stopping Kubernetes HPA Consumer");
        if (this.executor != null) {
            KubernetesHelper.close(this.hpasWatcher, this.hpasWatcher::getWatch);
            if (this.getEndpoint() != null && this.getEndpoint().getCamelContext() != null) {
                this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdownNow(this.executor);
            } else {
                this.executor.shutdownNow();
            }
        }
        this.executor = null;
    }

    class HpaConsumerTask
    implements Runnable {
        private Watch watch;

        HpaConsumerTask() {
        }

        @Override
        public void run() {
            FilterWatchListDeletable w;
            String namespace = KubernetesHPAConsumer.this.getEndpoint().getKubernetesConfiguration().getNamespace();
            String labelKey = KubernetesHPAConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelKey();
            String labelValue = KubernetesHPAConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelValue();
            String resourceName = KubernetesHPAConsumer.this.getEndpoint().getKubernetesConfiguration().getResourceName();
            if (ObjectHelper.isEmpty((String)namespace)) {
                w = (FilterWatchListDeletable)KubernetesHPAConsumer.this.getEndpoint().getKubernetesClient().autoscaling().v1().horizontalPodAutoscalers().inAnyNamespace();
                if (ObjectHelper.isNotEmpty((String)labelKey) && ObjectHelper.isNotEmpty((String)labelValue)) {
                    w = (FilterWatchListDeletable)w.withLabel(labelKey, labelValue);
                }
            } else {
                NonNamespaceOperation client = (NonNamespaceOperation)KubernetesHPAConsumer.this.getEndpoint().getKubernetesClient().autoscaling().v1().horizontalPodAutoscalers().inNamespace(namespace);
                w = client;
                if (ObjectHelper.isNotEmpty((String)labelKey) && ObjectHelper.isNotEmpty((String)labelValue)) {
                    w = (FilterWatchListDeletable)client.withLabel(labelKey, labelValue);
                } else if (ObjectHelper.isNotEmpty((String)resourceName)) {
                    w = (FilterWatchListDeletable)client.withName(resourceName);
                }
            }
            this.watch = w.watch((Watcher)new Watcher<HorizontalPodAutoscaler>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void eventReceived(Watcher.Action action, HorizontalPodAutoscaler resource) {
                    Exchange exchange = KubernetesHPAConsumer.this.createExchange(false);
                    exchange.getIn().setBody((Object)resource);
                    exchange.getIn().setHeader("CamelKubernetesEventAction", (Object)action);
                    exchange.getIn().setHeader("CamelKubernetesEventTimestamp", (Object)System.currentTimeMillis());
                    try {
                        KubernetesHPAConsumer.this.processor.process(exchange);
                    }
                    catch (Exception e) {
                        KubernetesHPAConsumer.this.getExceptionHandler().handleException("Error during processing", exchange, (Throwable)e);
                    }
                    finally {
                        KubernetesHPAConsumer.this.releaseExchange(exchange, false);
                    }
                }

                public void onClose(WatcherException cause) {
                    if (cause != null) {
                        LOG.error(cause.getMessage(), (Throwable)cause);
                    }
                }
            });
        }

        public Watch getWatch() {
            return this.watch;
        }

        public void setWatch(Watch watch) {
            this.watch = watch;
        }
    }
}

