/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.customresources;

import io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.base.CustomResourceDefinitionContext;
import io.fabric8.kubernetes.client.dsl.base.ResourceDefinitionContext;
import io.fabric8.kubernetes.client.utils.Serialization;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.kubernetes.AbstractKubernetesEndpoint;
import org.apache.camel.component.kubernetes.KubernetesConfiguration;
import org.apache.camel.component.kubernetes.KubernetesHelper;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesCustomResourcesConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesCustomResourcesConsumer.class);
    private final Processor processor;
    private ExecutorService executor;
    private CustomResourcesConsumerTask customResourcesWatcher;

    public KubernetesCustomResourcesConsumer(AbstractKubernetesEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.processor = processor;
    }

    public AbstractKubernetesEndpoint getEndpoint() {
        return (AbstractKubernetesEndpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.executor = this.getEndpoint().createExecutor();
        this.customResourcesWatcher = new CustomResourcesConsumerTask();
        this.executor.submit(this.customResourcesWatcher);
    }

    protected void doStop() throws Exception {
        LOG.debug("Stopping Kubernetes Custom Resources Consumer");
        if (this.executor != null) {
            KubernetesHelper.close(this.customResourcesWatcher, this.customResourcesWatcher::getWatch);
            if (this.getEndpoint() != null && this.getEndpoint().getCamelContext() != null) {
                this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdownNow(this.executor);
            } else {
                this.executor.shutdownNow();
            }
        }
        this.executor = null;
        super.doStop();
    }

    private CustomResourceDefinitionContext getCRDContext(KubernetesConfiguration config) {
        if (ObjectHelper.isEmpty((String)config.getCrdName()) || ObjectHelper.isEmpty((String)config.getCrdGroup()) || ObjectHelper.isEmpty((String)config.getCrdScope()) || ObjectHelper.isEmpty((String)config.getCrdVersion()) || ObjectHelper.isEmpty((String)config.getCrdPlural())) {
            LOG.error("one of more of the custom resource definition argument(s) are missing.");
            throw new IllegalArgumentException("one of more of the custom resource definition argument(s) are missing.");
        }
        return new CustomResourceDefinitionContext.Builder().withName(config.getCrdName()).withGroup(config.getCrdGroup()).withScope(config.getCrdScope()).withVersion(config.getCrdVersion()).withPlural(config.getCrdPlural()).build();
    }

    class CustomResourcesConsumerTask
    implements Runnable {
        private Watch watch;

        CustomResourcesConsumerTask() {
        }

        @Override
        public void run() {
            if (ObjectHelper.isNotEmpty((String)KubernetesCustomResourcesConsumer.this.getEndpoint().getKubernetesConfiguration().getNamespace())) {
                LOG.error("namespace is not specified.");
            }
            String namespace = KubernetesCustomResourcesConsumer.this.getEndpoint().getKubernetesConfiguration().getNamespace();
            try {
                ((NonNamespaceOperation)KubernetesCustomResourcesConsumer.this.getEndpoint().getKubernetesClient().genericKubernetesResources((ResourceDefinitionContext)KubernetesCustomResourcesConsumer.this.getCRDContext(KubernetesCustomResourcesConsumer.this.getEndpoint().getKubernetesConfiguration())).inNamespace(namespace)).watch((Watcher)new Watcher<GenericKubernetesResource>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void eventReceived(Watcher.Action action, GenericKubernetesResource resource) {
                        Exchange exchange = KubernetesCustomResourcesConsumer.this.createExchange(false);
                        exchange.getIn().setBody((Object)Serialization.asJson((Object)resource));
                        exchange.getIn().setHeader("CamelKubernetesCRDEventAction", (Object)action);
                        exchange.getIn().setHeader("CamelKubernetesCRDEventTimestamp", (Object)System.currentTimeMillis());
                        try {
                            KubernetesCustomResourcesConsumer.this.processor.process(exchange);
                        }
                        catch (Exception e) {
                            KubernetesCustomResourcesConsumer.this.getExceptionHandler().handleException("Error during processing", exchange, (Throwable)e);
                        }
                        finally {
                            KubernetesCustomResourcesConsumer.this.releaseExchange(exchange, false);
                        }
                    }

                    public void onClose(WatcherException cause) {
                        if (cause != null) {
                            LOG.error(cause.getMessage(), (Throwable)cause);
                        }
                    }
                });
            }
            catch (Exception e) {
                LOG.error("Exception in handling githubsource instance change", (Throwable)e);
            }
        }

        public Watch getWatch() {
            return this.watch;
        }

        public void setWatch(Watch watch) {
            this.watch = watch;
        }
    }
}

