/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kserve;

import inference.GrpcPredictV2;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.DeferredContextBinding;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.kserve.KServeConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;

@DeferredContextBinding
public final class KServeConverterLoader
implements TypeConverterLoader,
CamelContextAware {
    private CamelContext camelContext;

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        KServeConverterLoader.addTypeConverter(registry, GrpcPredictV2.ModelInferRequest.class, GrpcPredictV2.ModelInferRequest.Builder.class, false, (type, exchange, value) -> KServeConverter.toModelInferRequest((GrpcPredictV2.ModelInferRequest.Builder)value));
        KServeConverterLoader.addTypeConverter(registry, GrpcPredictV2.ModelMetadataRequest.class, GrpcPredictV2.ModelMetadataRequest.Builder.class, false, (type, exchange, value) -> KServeConverter.toModelMetadataRequest((GrpcPredictV2.ModelMetadataRequest.Builder)value));
        KServeConverterLoader.addTypeConverter(registry, GrpcPredictV2.ModelReadyRequest.class, GrpcPredictV2.ModelReadyRequest.Builder.class, false, (type, exchange, value) -> KServeConverter.toModelReadyRequest((GrpcPredictV2.ModelReadyRequest.Builder)value));
        KServeConverterLoader.addTypeConverter(registry, GrpcPredictV2.ServerLiveRequest.class, GrpcPredictV2.ServerLiveRequest.Builder.class, false, (type, exchange, value) -> KServeConverter.toServerLiveRequest((GrpcPredictV2.ServerLiveRequest.Builder)value));
        KServeConverterLoader.addTypeConverter(registry, GrpcPredictV2.ServerMetadataRequest.class, GrpcPredictV2.ServerMetadataRequest.Builder.class, false, (type, exchange, value) -> KServeConverter.toServerMetadataRequest((GrpcPredictV2.ServerMetadataRequest.Builder)value));
        KServeConverterLoader.addTypeConverter(registry, GrpcPredictV2.ServerReadyRequest.class, GrpcPredictV2.ServerReadyRequest.Builder.class, false, (type, exchange, value) -> KServeConverter.toServerReadyRequest((GrpcPredictV2.ServerReadyRequest.Builder)value));
    }

    private static void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, (TypeConverter)new SimpleTypeConverter(allowNull, method));
    }
}

