/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.knative.http;

import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.client.WebClient;
import io.vertx.ext.web.client.WebClientOptions;
import io.vertx.ext.web.client.impl.WebClientBase;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.component.knative.http.KnativeHttpHeaderFilterStrategy;
import org.apache.camel.component.knative.http.KnativeOidcClientOptions;
import org.apache.camel.component.knative.http.KnativeOidcInterceptor;
import org.apache.camel.component.knative.spi.KnativeResource;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedResource(description="Managed KnativeHttpProducer")
public class KnativeHttpProducer
extends DefaultAsyncProducer {
    private static final Logger LOGGER = LoggerFactory.getLogger(KnativeHttpProducer.class);
    private final KnativeResource serviceDefinition;
    private final Vertx vertx;
    private final WebClientOptions clientOptions;
    private final HeaderFilterStrategy headerFilterStrategy;
    private String uri;
    private String host;
    private WebClient client;

    public KnativeHttpProducer(Endpoint endpoint, KnativeResource serviceDefinition, Vertx vertx, WebClientOptions clientOptions) {
        super(endpoint);
        this.serviceDefinition = serviceDefinition;
        this.vertx = (Vertx)ObjectHelper.notNull((Object)vertx, (String)"vertx");
        this.clientOptions = (WebClientOptions)ObjectHelper.supplyIfEmpty((Object)clientOptions, WebClientOptions::new);
        this.headerFilterStrategy = new KnativeHttpHeaderFilterStrategy();
    }

    @ManagedAttribute(description="Url for calling the Knative HTTP service")
    public String getUrl() {
        return this.uri;
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        byte[] payload;
        if (exchange.getMessage().getBody() == null) {
            exchange.setException((Throwable)new IllegalArgumentException("body must not be null"));
            callback.done(true);
            return true;
        }
        try {
            payload = (byte[])exchange.getMessage().getMandatoryBody(byte[].class);
        }
        catch (InvalidPayloadException e) {
            exchange.setException((Throwable)e);
            callback.done(true);
            return true;
        }
        MultiMap headers = MultiMap.caseInsensitiveMultiMap();
        headers.add(HttpHeaders.CONTENT_LENGTH, (CharSequence)Integer.toString(payload.length));
        headers.add(HttpHeaders.HOST, (CharSequence)this.host);
        String contentType = MessageHelper.getContentType((Message)exchange.getMessage());
        if (contentType != null) {
            headers.add(HttpHeaders.CONTENT_TYPE, (CharSequence)contentType);
        }
        for (Map.Entry entry : exchange.getMessage().getHeaders().entrySet()) {
            if (this.headerFilterStrategy.applyFilterToCamelHeaders((String)entry.getKey(), entry.getValue(), exchange)) continue;
            headers.add((String)entry.getKey(), entry.getValue().toString());
        }
        this.client.postAbs(this.uri).putHeaders(headers).sendBuffer(Buffer.buffer((byte[])payload), response -> {
            if (response.succeeded()) {
                HttpResponse result = (HttpResponse)response.result();
                Message answer = exchange.getMessage();
                answer.setHeader("CamelHttpResponseCode", (Object)result.statusCode());
                for (Map.Entry entry : result.headers().entries()) {
                    if (this.headerFilterStrategy.applyFilterToExternalHeaders((String)entry.getKey(), entry.getValue(), exchange)) continue;
                    answer.setHeader((String)entry.getKey(), entry.getValue());
                }
                if (result.body() != null) {
                    answer.setBody((Object)((Buffer)result.body()).getBytes());
                } else {
                    answer.setBody(null);
                }
                if (result.statusCode() < 200 || result.statusCode() >= 300) {
                    String exceptionMessage = String.format("HTTP operation failed invoking %s with statusCode: %d, statusMessage: %s", URISupport.sanitizeUri((String)this.uri), result.statusCode(), result.statusMessage());
                    exchange.setException((Throwable)new CamelException(exceptionMessage));
                }
                answer.setHeader("CamelHttpResponseCode", (Object)result.statusCode());
            } else if (response.failed()) {
                String exceptionMessage = "HTTP operation failed invoking " + URISupport.sanitizeUri((String)this.uri);
                if (response.result() != null) {
                    exceptionMessage = exceptionMessage + " with statusCode: " + ((HttpResponse)response.result()).statusCode();
                }
                if (response.cause() != null) {
                    exceptionMessage = exceptionMessage + " caused by: " + response.cause().getMessage();
                    if (response.cause().getCause() != null) {
                        exceptionMessage = exceptionMessage + ", " + response.cause().getCause().getMessage();
                    }
                }
                exchange.setException((Throwable)new CamelException(exceptionMessage));
            }
            callback.done(false);
        });
        return false;
    }

    protected void doInit() throws Exception {
        KnativeOidcClientOptions oidcClientOptions;
        super.doInit();
        this.uri = this.getUrl(this.serviceDefinition);
        this.host = this.getHost(this.serviceDefinition);
        this.client = WebClient.create((Vertx)this.vertx, (WebClientOptions)this.clientOptions);
        WebClientOptions webClientOptions = this.clientOptions;
        if (webClientOptions instanceof KnativeOidcClientOptions && (oidcClientOptions = (KnativeOidcClientOptions)webClientOptions).isOidcEnabled()) {
            ((WebClientBase)this.client).addInterceptor((Handler)new KnativeOidcInterceptor(oidcClientOptions));
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.client != null) {
            LOGGER.debug("Shutting down client: {}", (Object)this.client);
            this.client.close();
            this.client = null;
        }
    }

    private String getUrl(KnativeResource definition) {
        Object url = definition.getUrl();
        if (url == null) {
            throw new RuntimeCamelException("Unable to determine the `url` for definition: " + String.valueOf(definition));
        }
        Object path = definition.getPath();
        if (path != null) {
            if (((String)path).charAt(0) != '/') {
                path = "/" + (String)path;
            }
            if (((String)url).endsWith("/")) {
                url = ((String)url).substring(0, ((String)url).length() - 1);
            }
            url = (String)url + (String)path;
        }
        return this.getEndpoint().getCamelContext().resolvePropertyPlaceholders((String)url);
    }

    private String getHost(KnativeResource definition) {
        String url = this.getUrl(definition);
        try {
            return new URL(url).getHost();
        }
        catch (MalformedURLException e) {
            throw new RuntimeCamelException("Unable to determine `host` for definition: " + String.valueOf(definition), (Throwable)e);
        }
    }
}

