/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.keycloak.security.cache;

import org.apache.camel.component.keycloak.security.KeycloakTokenIntrospector;
import org.apache.camel.component.keycloak.security.cache.CaffeineTokenCache;
import org.apache.camel.component.keycloak.security.cache.ConcurrentMapTokenCache;
import org.apache.camel.component.keycloak.security.cache.TokenCache;
import org.apache.camel.component.keycloak.security.cache.TokenCacheType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TokenCacheFactory {
    private static final Logger LOG = LoggerFactory.getLogger(TokenCacheFactory.class);

    private TokenCacheFactory() {
    }

    public static TokenCache createCache(TokenCacheType cacheType, long ttlSeconds, long maxSize, boolean recordStats) {
        if (cacheType == null) {
            cacheType = TokenCacheType.CONCURRENT_MAP;
        }
        switch (cacheType) {
            case CONCURRENT_MAP: {
                LOG.debug("Creating ConcurrentMap token cache");
                return new ConcurrentMapTokenCache(ttlSeconds);
            }
            case CAFFEINE: {
                LOG.debug("Creating Caffeine token cache");
                return TokenCacheFactory.createCaffeineCache(ttlSeconds, maxSize, recordStats);
            }
            case NONE: {
                LOG.debug("Token caching is disabled");
                return new NoOpTokenCache();
            }
        }
        throw new IllegalArgumentException("Unsupported cache type: " + String.valueOf((Object)cacheType));
    }

    public static TokenCache createCache(long ttlSeconds) {
        return TokenCacheFactory.createCache(TokenCacheType.CONCURRENT_MAP, ttlSeconds, 0L, false);
    }

    private static TokenCache createCaffeineCache(long ttlSeconds, long maxSize, boolean recordStats) {
        try {
            Class.forName("com.github.benmanes.caffeine.cache.Caffeine");
            return new CaffeineTokenCache(ttlSeconds, maxSize, recordStats);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Caffeine cache type selected but caffeine dependency is not available. Add caffeine to your dependencies or use CONCURRENT_MAP cache type.", e);
        }
    }

    private static class NoOpTokenCache
    implements TokenCache {
        private NoOpTokenCache() {
        }

        @Override
        public KeycloakTokenIntrospector.IntrospectionResult get(String token) {
            return null;
        }

        @Override
        public void put(String token, KeycloakTokenIntrospector.IntrospectionResult result) {
        }

        @Override
        public void remove(String token) {
        }

        @Override
        public void clear() {
        }

        @Override
        public long size() {
            return 0L;
        }

        @Override
        public TokenCache.CacheStats getStats() {
            return new TokenCache.CacheStats(0L, 0L, 0L);
        }
    }
}

