/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.keycloak.security.cache;

import org.apache.camel.component.keycloak.security.KeycloakTokenIntrospector;

public interface TokenCache {
    public KeycloakTokenIntrospector.IntrospectionResult get(String var1);

    public void put(String var1, KeycloakTokenIntrospector.IntrospectionResult var2);

    public void remove(String var1);

    public void clear();

    public long size();

    default public void close() {
    }

    default public CacheStats getStats() {
        return null;
    }

    public static class CacheStats {
        private final long hitCount;
        private final long missCount;
        private final long evictionCount;
        private final double hitRate;

        public CacheStats(long hitCount, long missCount, long evictionCount) {
            this.hitCount = hitCount;
            this.missCount = missCount;
            this.evictionCount = evictionCount;
            long totalRequests = hitCount + missCount;
            this.hitRate = totalRequests == 0L ? 0.0 : (double)hitCount / (double)totalRequests;
        }

        public long getHitCount() {
            return this.hitCount;
        }

        public long getMissCount() {
            return this.missCount;
        }

        public long getEvictionCount() {
            return this.evictionCount;
        }

        public double getHitRate() {
            return this.hitRate;
        }

        public String toString() {
            return String.format("CacheStats{hits=%d, misses=%d, hitRate=%.2f%%, evictions=%d}", this.hitCount, this.missCount, this.hitRate * 100.0, this.evictionCount);
        }
    }
}

