/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.keycloak.security.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import java.util.concurrent.TimeUnit;
import org.apache.camel.component.keycloak.security.KeycloakTokenIntrospector;
import org.apache.camel.component.keycloak.security.cache.TokenCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaffeineTokenCache
implements TokenCache {
    private static final Logger LOG = LoggerFactory.getLogger(CaffeineTokenCache.class);
    private final Cache<String, KeycloakTokenIntrospector.IntrospectionResult> cache;

    public CaffeineTokenCache(long ttlSeconds, long maxSize, boolean recordStats) {
        Caffeine builder = Caffeine.newBuilder().expireAfterWrite(ttlSeconds, TimeUnit.SECONDS);
        if (maxSize > 0L) {
            builder.maximumSize(maxSize);
        }
        if (recordStats) {
            builder.recordStats();
        }
        this.cache = builder.build();
        LOG.debug("Initialized Caffeine token cache with TTL={}s, maxSize={}, stats={}", new Object[]{ttlSeconds, maxSize > 0L ? Long.valueOf(maxSize) : "unlimited", recordStats});
    }

    public CaffeineTokenCache(long ttlSeconds) {
        this(ttlSeconds, 0L, true);
    }

    @Override
    public KeycloakTokenIntrospector.IntrospectionResult get(String token) {
        KeycloakTokenIntrospector.IntrospectionResult result = (KeycloakTokenIntrospector.IntrospectionResult)this.cache.getIfPresent((Object)token);
        if (result != null) {
            LOG.trace("Cache hit for token");
        } else {
            LOG.trace("Cache miss for token");
        }
        return result;
    }

    @Override
    public void put(String token, KeycloakTokenIntrospector.IntrospectionResult result) {
        this.cache.put((Object)token, (Object)result);
        LOG.trace("Token introspection result cached");
    }

    @Override
    public void remove(String token) {
        this.cache.invalidate((Object)token);
        LOG.trace("Token removed from cache");
    }

    @Override
    public void clear() {
        this.cache.invalidateAll();
        LOG.debug("Cache cleared");
    }

    @Override
    public long size() {
        return this.cache.estimatedSize();
    }

    @Override
    public void close() {
        this.cache.invalidateAll();
        this.cache.cleanUp();
        LOG.debug("Cache closed and cleaned up");
    }

    @Override
    public TokenCache.CacheStats getStats() {
        CacheStats caffeineStats = this.cache.stats();
        return new TokenCache.CacheStats(caffeineStats.hitCount(), caffeineStats.missCount(), caffeineStats.evictionCount());
    }

    public Cache<String, KeycloakTokenIntrospector.IntrospectionResult> getCaffeineCache() {
        return this.cache;
    }
}

